#include "common.h"
#include "libWrapper.h"
#include "buffsize.h"
#include <ctype.h>
#include "dataDir.h"

#ifndef _SCHEMA_H
#define _SCHEMA_H
#include "schema.h"
#endif

/****************************************************************
 *
 * Gloval variable
 *
 ***************************************************************/
extern SCHEMA HeadSchema;

/****************************************************************
 *
 * Private Function
 *
 ***************************************************************/
static void
parseForCreateIndex(const char buff[], char schemaName[], char attrName[], char indexName[], char indexType[])
{
  int nameid;
  int offset;

  for (offset = 0;
       offset < BUFFSIZE;
       offset ++) {
    if ((buff[offset] == 'c') && (strncmp(&buff[offset], "create", strlen("create")) == 0)) { 
      offset += strlen("create");
      for (; offset < BUFFSIZE; offset ++) {
	if ((buff[offset] == 'i') && (strncmp(&buff[offset], "index", strlen("index")) == 0)) { 
	  offset += strlen("index");
	  break;
	}
      }
      break;
    }
  }

  for (; buff[offset] == ' ';  offset ++) {;;;;;} /* skip spaces */
  bzero(indexName, BUFFSIZE);
  for (nameid = 0; 
       buff[offset] != ' ';
       nameid ++, offset ++) {
    indexName[nameid] = buff[offset];
  }

#ifdef DEBUG
  printf("indexName: [%s]\n", indexName);
#endif

  for (; (offset < BUFFSIZE) && (buff[offset] != 'o') && (strncmp(&buff[offset], "on", strlen("on")) != 0);
       offset ++) {;;;;;}
  offset += strlen("on");
  for (; buff[offset] == ' ';  offset ++) {;;;;;} /* skip spaces */

  bzero(schemaName, BUFFSIZE);
  for (nameid = 0;
       buff[offset] != ' ';
       nameid ++, offset ++) {
    schemaName[nameid] = buff[offset];
  }

#ifdef DEBUG
  printf("schemaName: [%s]\n", schemaName);
#endif

  for (; buff[offset] == ' ';  offset ++) {;;;;;} /* skip spaces */
  for (; (offset < BUFFSIZE) && (buff[offset] != 'u') && (strncmp(&buff[offset], "using", strlen("using")) != 0);
       offset ++) {;;;;;}
  offset += strlen("using");

  for (; buff[offset] == ' ';  offset ++) {;;;;;} /* skip spaces */
  bzero(indexType, BUFFSIZE);  
  for (nameid = 0;
       buff[offset] != ' ';
       nameid ++, offset ++) {
    indexType[nameid] = buff[offset];
  }

#ifdef DEBUG
  printf("indexType: [%s]\n", indexType);
#endif

  for (; buff[offset] != '(';  offset ++) {;;;;;} 
  offset += strlen("(");
  for (; buff[offset] == ' ';  offset ++) {;;;;;} /* skip spaces */
  bzero(attrName, BUFFSIZE);    
  for (nameid = 0;
       ((buff[offset] != ')') && (buff[offset] != ' '));
       nameid ++, offset ++) {
    attrName[nameid] = buff[offset];
  }

#ifdef DEBUG
  printf("attrName: [%s]\n", attrName);
#endif

}

static int
initPrimeNumber(void)
{
  int primeNumber;

  primeNumber = 13; /* No meaning, just this is an prime number and I have no time now */

  return primeNumber;
}

static HASH_NODE *
getNewHashNode(TUPLE *pTuple)
{
  HASH_NODE *pHashNode;

  if ((pHashNode = calloc(1, sizeof(HASH_NODE))) == NULL) ERR;
  pHashNode->pTuple = pTuple;
    
  return pHashNode;
}

static int
getModNumber(const SCHEMA *pSchema, const INDEX *pIndex, const TUPLE *pTuple)
{
  int byteOffset;
  int attrid;
  int *pIntData;
  int modNumber;

  for (byteOffset = 0, attrid = 0; 
       attrid < pSchema->numOfAttr; 
       attrid ++) {
    byteOffset += pSchema->attr[attrid].sizOfAttr;
  }
  pIntData = (int *)(pTuple->obj + byteOffset);
  modNumber = (*pIntData) % pIndex->primeNumber;

  return modNumber;
}

/****************************************************************
 *
 * Public Function
 *
 ***************************************************************/
extern void
makeBtreeDataStructure(INDEX *pIndex, SCHEMA *pSchema)
{
  execCreateBtree(pIndex, pSchema);
}

extern void
makeHashDataStructure(INDEX *pIndex, SCHEMA *pSchema)
{
  int hashKey;
  int modNumber;
  TUPLE *pTuple;
  HASH_BUCKET *pHashBucket;
  HASH_NODE *pHashNode;

  for (hashKey = 0, pHashBucket = &(pIndex->headHashBucket);
       hashKey < pIndex->primeNumber;
       hashKey ++, pHashBucket = pHashBucket->next) {
    if ((pHashBucket->next = calloc(1, sizeof(HASH_BUCKET))) == NULL) ERR;
    pHashBucket->next->hashKey = hashKey;
  }
  
  for (pTuple = pSchema->headTuple.next;
       pTuple != NULL;
       pTuple = pTuple->next) {
    modNumber = getModNumber(pSchema, pIndex, pTuple);

    for (pHashBucket = pIndex->headHashBucket.next, hashKey = 0;
         hashKey < modNumber; 
         pHashBucket = pHashBucket->next, hashKey ++) {;;;;;}

    for (pHashNode = &(pHashBucket->headHashNode);
         pHashNode->next != NULL;
         pHashNode = pHashNode->next) {;;;;;}

    pHashNode->next = getNewHashNode(pTuple);
  }
}

extern BOOLEAN
createIndex(const char buff[])
{
  int fd;
  char schemaName[BUFFSIZE];
  char attrName[BUFFSIZE];
  char indexName[BUFFSIZE];
  char indexType[BUFFSIZE];
  char indexFileName[BUFFSIZE];
  SCHEMA *pSchema;
  INDEX *pIndex;
  BOOLEAN occurParseError = FALSE;

  for (pSchema = &HeadSchema;
       pSchema->next != NULL;
       pSchema = pSchema->next) 
    ;
  parseForCreateIndex(buff, schemaName, attrName, indexName, indexType);

  if (pthread_rwlock_wrlock(&(pSchema->rwlock)) != 0) ERR;

  for (pIndex = &(pSchema->headIndex);
       pIndex->next != NULL;
       pIndex = pIndex->next) 
    ;
  if ((pIndex->next = calloc(1, sizeof(INDEX))) == NULL) ERR;
  pIndex = pIndex->next;

  if (pthread_rwlock_init(&(pIndex->rwlock), NULL) != 0) ERR;
  strcpy(pIndex->indexName, indexName);
  strcpy(pIndex->attrName, attrName);  

  if (strcmp(indexType, "hash") == 0) {
    pIndex->indexType = HASH_INDEX;
    pIndex->primeNumber = initPrimeNumber();
    makeHashDataStructure(pIndex, pSchema);
  }
  else if (strcmp(indexType, "btree") == 0) {
    pIndex->indexType = BTREE_INDEX;
    pIndex->minBtreeFanout = MIN_BTREE_FANOUT;
    makeBtreeDataStructure(pIndex, pSchema);
  }
  else {
    printf("No such index type\n");
    exit(1);
  }

  bzero(indexFileName, BUFFSIZE);
  sprintf(indexFileName, "%s/%s/index", DATA_DIR, pSchema->schemaName);
  if ((fd = open(indexFileName, O_WRONLY|O_APPEND)) == -1) ERR;
  if (write(fd, pIndex, sizeof(INDEX)) == -1) ERR;
  if (fsync(fd) == -1) ERR;
  if (close(fd) == -1) ERR;
  
  if (pthread_rwlock_unlock(&(pSchema->rwlock)) != 0) ERR;

  return occurParseError;
}
