#include "common.h"
#include "libWrapper.h"
#include "buffsize.h"
#include "dataDir.h"
#include "schemaDir.h"
#include "errno.h"

#ifndef _TRANS_INFO_H
#define _TRANS_INFO_H
#include "transInfo.h"
#endif

#include "sensorImageSize.h"

/****************************************************************
 *
 * Definition
 *
 ***************************************************************/
#define SENSOR_DIR "sensor"
#define RELATION_FILE_NAME "relation"
#define OBJECT_FILE "object"
/****************************************************************
 *
 * Global variable
 *
 ***************************************************************/
extern SCHEMA HeadSchema;

/****************************************************************
 *
 * Public Function
 *
 ***************************************************************/
extern void
setAttrInSchema(const char schemaName[], SCHEMA *schemaP)
{
  int attrid;
  char buff[BUFFSIZE];
  char schemaFileName[BUFFSIZE];
  char relationFileName[BUFFSIZE];
  char attrType[BUFFSIZE];
	char *hdp; /* Home Directory Pointer */
  FILE *fpin;

  bzero(buff, BUFFSIZE);
  bzero(schemaFileName, BUFFSIZE);
  bzero(attrType, BUFFSIZE);
  bzero(relationFileName, BUFFSIZE);

  strncpy(schemaP->schemaName, schemaName, strlen(schemaName));
	hdp = getenv("HOME");
  sprintf(schemaFileName, "%s/%s/%s", hdp, SCHEMA_DIR, schemaName);
  sprintf(relationFileName, "%s/%s/%s/%s", hdp, DATA_DIR, schemaName, RELATION_FILE_NAME);

  if ((fpin = fopen(schemaFileName, "r")) == NULL) ERR;
  while (fgets(buff, sizeof(buff), fpin)) 
    schemaP->numOfAttr ++;

  if ((schemaP->attr = calloc(schemaP->numOfAttr, sizeof(ATTR))) == NULL) ERR;
  rewind(fpin);
  for (attrid = 0; attrid < schemaP->numOfAttr; attrid ++) {
    strncpy(schemaP->attr[attrid].schemaName, schemaName, strlen(schemaName));

    fgets(buff, sizeof(buff), fpin);    
    bzero(attrType, BUFFSIZE);
    sscanf(buff, "%s%s", schemaP->attr[attrid].attrName, attrType);
    
    if (strncmp(attrType, "int", strlen("int")) == 0) {
      schemaP->attr[attrid].attrType = INT;
      schemaP->attr[attrid].sizOfAttr = sizeof(int);
    }
    else if (strncmp(attrType, "double", strlen("double")) == 0) {
      schemaP->attr[attrid].attrType = DOUBLE;
      schemaP->attr[attrid].sizOfAttr = sizeof(double);
    }
    else if (strncmp(attrType, "text", strlen("text")) == 0) {
      schemaP->attr[attrid].attrType = TEXT;
      schemaP->attr[attrid].sizOfAttr = BUFFSIZE;
    }
    else if (strncmp(attrType, "sensor", strlen("sensor")) == 0) {
      sscanf(buff, "%s%s%d", schemaP->attr[attrid].attrName, attrType, &schemaP->attr[attrid].szsa); /* Stupid impl... */
      schemaP->attr[attrid].attrType = SENSOR_SEGMENT_DOUBLE;
      schemaP->attr[attrid].sizOfAttr = sizeof(SENSOR_SEGMENT);
			
    }
    else {
      ERR;
    }
    schemaP->sizOfObj += schemaP->attr[attrid].sizOfAttr;
  }

	initPagePtr(schemaP);

  if (fclose(fpin) != 0) ERR;
}

extern SCHEMA *
getSchema(const char schemaName[])
{
  SCHEMA *schemaP;

  for (schemaP = HeadSchema.next; schemaP != NULL; schemaP = schemaP->next) {
    if (strcmp(schemaP->schemaName, schemaName) == 0) 
      break;
  }  

  return schemaP;
}
