#ifndef _SCHEMA_H
#define _SCHEMA_H
#include "schema.h"
#endif

#ifndef _SELECT_FROM_H
#define _SELECT_FROM_H
#include "selectFrom.h"
#endif

#ifndef _LOCK_MODE_H
#define _LOCK_MODE_H
#include "lockMode.h"
#endif

#ifndef _LOG_INFO_H
#define _LOG_INFO_H
#include "logInfo.h"
#endif

#ifndef _TRANS_INFO_H
#define _TRANS_INFO_H
#include "transInfo.h"
#endif

#ifndef _SIMSEQ_H
#define _SIMSEQ_H
#include "simseq.h"
#endif


extern int getAttridForUpdateOrAppend(const char attrName[], const SCHEMA *pSchema);
extern SCHEMA *getSchemaForInsertOrUpdateOrAppend(const char schemaName[]);
extern void *allocBufferPool(SCHEMA *pSchema, const int allocSize);

extern void allocSchema(const char schemaName[]);
extern void makeHashDataStructure(INDEX *pIndex, SCHEMA *pSchema); /* In this file! */
extern void execCreateBtree(INDEX *pIndex, SCHEMA *pSchema);


//extern void recovery(void);
extern void *newThreadForWriteBack(void *arg);
extern int createConnection(const int port);
extern void initTransMgr(void);
extern void initMutexForLogFile(void);
extern void truncateLogFile(void);
extern void initTailLogInfoFile(void);
extern void initMonitorMgr(void);

extern ANSWER execCartesianProduct(SCHEMA_LIST headSchemaList);
extern TUPLE selectAllOfTuple(ANSWER answer);
extern FROM_SCHEMA getFromSchema(const char query[]);
extern TUPLE releaseTrashTupleForSelectOrDeleteOrUpdateOrAppend(ANSWER answer);
extern void wrlockAnswerTuple(const TUPLE headTuple);
extern void unlockAnswerTuple(const TUPLE headTuple);


extern void releaseOffset(OFFSET *pHeadOffset);
extern void wrlockAnswerTuple(const TUPLE headTuple);
extern void unlockAnswerTuple(const TUPLE headTuple);


extern double *setSequenceInDatabase(const SENSOR *pSensor, const int numOfElem);


extern void Pthread_rwlock_init(pthread_rwlock_t *mutex, void *ptr);

extern void *allocBufferPool(SCHEMA *pSchema, const int allocSize);
extern int connectCli(const int port, const char hostname[]);

extern void abortMyTransaction(void);
extern void *allocBufferPool(SCHEMA *pSchema, const int allocSize);
extern void makeHashDataStructure(INDEX *pIndex, SCHEMA *pSchema);                               
extern void makeBtreeDataStructure(INDEX *pIndex, SCHEMA *pSchema);
extern void releaseOffset(OFFSET *pHeadOffset);
extern void releaseSchema(SCHEMA *pSchema);
extern void rollbackMyTransaction(TYPE_OF_ANSWER typeOfRollback);
extern void Pthread_rwlock_init(pthread_rwlock_t *mutex, void *ptr);
extern void prepareBtree(INDEX *pIndex, SCHEMA *pSchema);


extern ANSWER selectFrom(const char query[]);
extern void sendMessage(const int acptfd, TYPE_OF_ANSWER typeOfAnswer);
extern void sendAnswerListToClient(int acptfd, ANSWER answer);
extern void releaseAnswerForServer(ANSWER answer);
extern void persistCandidate(void);
extern int thisIsNumber(const char c);



extern void appendIdToPriorityList(const pthread_t id, const struct timeval deadline);
extern void releaseIdFromPriorityList(const pthread_t id);
extern void sendMessage(const int acptfd, TYPE_OF_ANSWER typeOfAnswer);



extern void persistCandidate(void);
extern void releaseMyTransaction(void);
extern void sendAnswerListToClient(int acptfd, ANSWER answer);
extern void sendSchema(const int acptfd, const char query[]);
extern void sendMonitor(const int acptfd, const char query[]);
extern void runMonitor(const int cliendfd, const char query[]);
extern void releaseAnswerForServer(ANSWER answer);
extern void releasePersistentCandidate(void);
extern void rollbackVolatileObject(void);
extern void releaseBufferPool(void);
extern void rollbackMyTransaction(TYPE_OF_ANSWER typeOfRollback);
extern BOOLEAN createIndex(const char buff[]);
extern PARSE_MSG createMonitor(const char query[]);

extern void execPersistCandidateForInsert(const PERSISTENT_INSERT_OBJ insert);
extern void execPersistCandidateForAppend(const PERSISTENT_APPEND_OBJ append);
extern void releasePersistentCandidate(void);
extern void rollbackVolatileObject(void);
extern void releaseBufferPool(void);
extern void releaseMyTransaction(void);
extern void   releaseCondition(CONDITION headCondition);
extern void   sendAnswerListToClient(int acptfd, ANSWER answer);
extern void   rdlockAnswerTuple(const TUPLE headTuple);
extern void   rdlockSchemaList(const SCHEMA_LIST headSchemaList);
extern void   wrlockSchemaList(const SCHEMA_LIST headSchemaList);
extern void   unlockSchemaList(SCHEMA_LIST headSchemaList);
extern void   unlockAnswerTuple(TUPLE headTuple);
extern TUPLE  sortAnswerTupleByOrder(ANSWER answer, const ORDER_INFO orderInfo);
extern void releaseSensorSegmentAttrList(SENSOR_SEGMENT_ATTR_LIST *pHeadSSAL);

extern void execPersistCandidateForInsert(const PERSISTENT_INSERT_OBJ insert);
extern void execPersistCandidateForAppend(const PERSISTENT_APPEND_OBJ append);


extern CONDITION getCondition(const char query[]);
extern TUPLE makeListForDeleteOrUpdate(CONDITION headCondition, const char schemaName[]);
extern void releaseTempTuple(TUPLE headTuple);
extern void releaseCondition(CONDITION headCondition);
extern void wrlockAnswerTuple(const TUPLE headTuple);
extern void unlockAnswerTuple(const TUPLE headTuple);

extern void *newThreadForCheckPointServer(void *arg);
extern void atomicPersistCandidate(void);

extern void error(const char file[], const int line, const char func[]);
extern void setAttrInSchema(const char schemaName[], SCHEMA *pSchema);
extern void *DKalloc(const int numOfObj, const int sizeOfObj);
extern void *RKalloc(const int numOfObj, const int sizeOfObj);
extern void initBufferPool(int size);
extern void diskWriteThisLogRecord(LOG_RECORD *pLogRecord);
extern void swapoutSchemaOnDBServer(void);
extern void releaseBaseTupleForServer(TUPLE headTuple, const ATTR attr[], const int numOfAttr);
extern void createCheckPointerThread(void);
extern void initLockOfThisSchema(SCHEMA *pSchema);
extern void execCopyRelease(const int line, const char func[]);
