#ifdef DEBUG
#define C(val)  do {fprintf(stderr, "%d %16s %4d %24s %32s: (%c)\n", (size_t)pthread_self(), __FILE__, __LINE__, __func__, #val, val); fflush(stderr);} while (0)
#define D(val)  do {fprintf(stderr, "%d %16s %4d %24s %32s: (%d)\n", (size_t)pthread_self(), __FILE__, __LINE__, __func__, #val, val); fflush(stderr);} while (0)
#define P(val)  do {fprintf(stderr, "%d %16s %4d %24s %32s: (%p)\n", (size_t)pthread_self(), __FILE__, __LINE__, __func__, #val, val); fflush(stderr);} while (0)
#define L(val)  do {fprintf(stderr, "%d %16s %4d %24s %32s: (%ld)\n", (size_t)pthread_self(), __FILE__, __LINE__, __func__, #val, val); fflush(stderr);} while (0)
#define LL(val) do {fprintf(stderr, "%d %16s %4d %24s %32s: (%lld)\n", (size_t)pthread_self(), __FILE__, __LINE__, __func__, #val, val); fflush(stderr);} while (0)
#define S(val)  do {fprintf(stderr, "%d %16s %4d %24s %32s: (%s)\n", (size_t)pthread_self(), __FILE__, __LINE__, __func__, #val, val); fflush(stderr);} while (0)
#define F(val)  do {fprintf(stderr, "%d %16s %4d %24s %32s: (%f)\n", (size_t)pthread_self(), __FILE__, __LINE__, __func__, #val, val); fflush(stderr);} while (0)
#define N       do {fprintf(stderr, "%d %16s %4d %24s\n", (size_t)pthread_self(), __FILE__, __LINE__, __func__); fflush(stderr);} while (0)
#define ERR     do {perror("ERROR"); N; exit(1);} while (0)
#define ERR2    do {perror("ERROR"); N; pthread_exit(NULL);} while (0)
#else
#define C(val)   do {} while (0)
#define D(val)   do {} while (0)
#define P(val)   do {} while (0)
#define L(val)   do {} while (0)
#define LL(val)  do {} while (0)
#define S(val)   do {} while (0)
#define F(val)   do {} while (0)
#define N        do {} while (0)
#define ERR      do {} while (0)
#endif
