#include "common.h"
#include "buffsize.h"
#include "libWrapper.h"
#include "schema.h"
#include "selectFrom.h"
#include "ipc.h"

typedef enum {INSERT, APPEND} TYPE;

/***************************************************************
 *
 * Declaration
 *
 ***************************************************************/
extern void sendQuery(const char query[], const int sockfd);
extern TYPE_OF_ANSWER recvTypeOfAnswer(const int sockfd);
extern ANSWER recvAnswer(const int sockfd);
extern void printResultForRelation(ANSWER answer);
extern void printResultForSchema(const int sockfd);
extern void printResultOfOperation(const TYPE_OF_ANSWER typeOfAnswer);
extern int connectKraftByClient(void);
extern int connectKraftBySensor(void);
extern void sendExitAndCloseSockfd(const int sockfd);

/***************************************************************
 *
 * Private Function
 *
 ***************************************************************/
static void
getResultOfAdhocQuery(const int sockfd)
{
  TYPE_OF_ANSWER typeOfAnswer;
  ANSWER answer;

  typeOfAnswer = recvTypeOfAnswer(sockfd);
  switch (typeOfAnswer) {

  case ANSWER_RELATION:    
    answer = recvAnswer(sockfd);
    printResultForRelation(answer); 
    break;

  case ANSWER_SHOW_MONITOR: 
    printResultForSchema(sockfd);   
    break;

  case ANSWER_SHOW_WINDOW: 
    printResultForSchema(sockfd);   
    break;

  case ANSWER_SHOW_SCHEMA:  
    printResultForSchema(sockfd);   
    break;

  default:
    printResultOfOperation(typeOfAnswer);            
    break;
  }
}

static void
issueAppend(const int id, const int nbq, const int sza)
{
  int kraftfd, i, j, fd;
  int v;
  char query[QUERY_BUFFSIZE];
  char buff[BUFSIZ];
  struct timeval t;

  kraftfd = connectKraftBySensor();
  for (i = 0; i < nbq; i ++) {
    bzero(query, QUERY_BUFFSIZE);
    sprintf(query, "append into r1.0 values (");
    for (j = 0; j < sza; j++) {
      gettimeofday(&t, NULL);
      v = (int)(t.tv_usec % 100);
      bzero(buff, BUFSIZ);
      sprintf(buff, "%d", v);
      strcat(query, buff);
      if (j != sza - 1)
        strcat(query, ", ");
    }
    strcat(query, ") where id = ");

    bzero(buff, BUFSIZ);
    sprintf(buff, "%d", id);
    strcat(query, buff);

    sendQuery(query, kraftfd);
    getResultOfAdhocQuery(kraftfd);
  }
  sendExitAndCloseSockfd(kraftfd);

  if ((fd = open("file", LOCK_EX|O_APPEND)) == -1) ERR;
  if (write(fd, &id, sizeof(int)) == -1) ERR;
  if (close(fd) == -1) ERR;

  exit(0);
}

static void
exeAppend(const int nbq, const int nbc, const int sza)
{
  int i, pid, fd, n;
  
  if ((fd = open("file", O_CREAT|O_TRUNC, 0644)) == -1) ERR;
  if (close(fd) == -1) ERR;
  
  for (i = 0; i < nbc; i ++) {
    if ((pid = fork()) == 0) 
      issueAppend(i, nbq, sza);
  }

  if ((fd = open("file", O_RDONLY)) == -1) ERR;  
  while (1) {
    flock(fd, LOCK_SH);
    n = lseek(fd, 0, SEEK_END);
    flock(fd, LOCK_UN);
    if (n == nbc * (int)sizeof(int)) {
      if (close(fd) == -1) ERR;
      break;
    }
    usleep(100);
  }
}

static void
issueInsert(const int nbq)
{
  int sockfd, i;
  char query[QUERY_BUFFSIZE];

  sockfd = connectKraftByClient();
  for (i = 0; i < nbq; i ++) {
    bzero(query, QUERY_BUFFSIZE);
    sprintf(query, "insert into r1 values (%d, null)", i);
    sendQuery(query, sockfd);
    getResultOfAdhocQuery(sockfd);
  }
  sendExitAndCloseSockfd(sockfd);
}

static void
exeInsert(const int nbq)
{
  issueInsert(nbq);
}

static TYPE
getType(char c)
{
  if (c == 'i') 
    return INSERT;
  else if (c == 'a') 
    return APPEND;

  ERR;
}

static void
printUsage(void)
{
  printf("Usage:\n");
  printf("\tINSERT: program i #Query\n");
  printf("\tAPPEND: program a #Query #Clients #Array\n");
  exit(1);
}

/***************************************************************
 *
 * Public Function
 *
 ***************************************************************/
extern int 
main(const int argc, char *argv[])
{
  int nbc; /* # clients */
  int nbq; /* # queries */
  int sza; /* size of array */

  TYPE type;

  if (argc < 3 || argc > 6)
    printUsage();

  type = getType(argv[1][0]);
  nbq = atoi(argv[2]);
  
  switch(type) {
  case INSERT:
    exeInsert(nbq);
    break;
  case APPEND:
    nbc = atoi(argv[3]);
    sza = atoi(argv[4]);
    exeAppend(nbq, nbc, sza);
    break;
  }
    
  return 0;
}
