#if defined(K_USING_SSA_OPT)
#define USE_OPT_PEEPHOLE
static int merge(knh_opline_t *op1, knh_opline_t *op2)
{
	if(op1->opcode == OPCODE_iADDn) {
		klr_iADDn_t *opN = (klr_iADDn_t*)op1;
		if(opN->a == opN->c && opN->n == 1) {
			op1->opcode = OPCODE_iINC;
		}
		return 0;
	}
	if(op1->opcode == OPCODE_iSUBn) {
		klr_iSUBn_t *opN = (klr_iSUBn_t*)op1;
		if(opN->a == opN->c && opN->n == 1) {
			op1->opcode = OPCODE_iDEC;
		}
		return 0;
	}
#if defined(OPCODE_sfMOVx)
	if(op2->opcode == OPCODE_fMOVx) {
		if(op1->opcode == OPCODE_fMOVx) {
			klr_sfMOVx_t *op_ = (klr_sfMOVx_t *)op1;
			op_->c   = ((klr_fMOVx_t*) op2)->a;
			op_->d.i = ((klr_fMOVx_t*) op2)->b.i;
			op_->d.n = ((klr_fMOVx_t*) op2)->b.n;
			op1->opcode = OPCODE_sfMOVx;
			return 1;
		}
		if(op1->opcode == OPCODE_OMOVx) &&
				(((klr_OMOV_t *)opP)->a == ((klr_fMOVx_t *)op)->b.i) {
			klr_fMOVxx_t *op_ = (klr_fMOVxx_t *)op1;
			op_->c.i = op_->b.i;
			op_->c.n = op_->b.n;
			op_->b.i = ((klr_fMOVx_t*)op1)->b.i;
			op_->b.n = ((klr_fMOVx_t*)op1)->b.n;
			op_->a   = ((klr_fMOVx_t*)op1)->a;
			opP->opcode = OPCODE_fMOVxx;
			return 1;
		}
	}
#endif
	return 0;
}

static void opt_peephole(Ctx *ctx, knh_BasicBlock_t *__bb, knh_Array_t *vertex, int mask)
{
	int i, vsize = knh_Array_size(vertex);
	BEGIN_LOCAL(ctx, lsfp, 1);
	LOCAL_NEW(ctx, lsfp, 0, knh_Array_t *, data, new_Array(ctx, CLASS_Int, 0));
	for (i = 0; i < vsize; i++) {
		knh_BasicBlock_t *bb = VERTEX(i);
		int j, size = DP(bb)->size;
		knh_opline_t *opP;
#ifdef USE_OPT_SIMPLE_CONSTANT_FOLDING
		__constant_fold(ctx, bb, data);
#endif
		L_HEAD:;
		opP = DP(bb)->opbuf;
		for (j = 1; j < size; j++) {
			knh_opline_t *op = DP(bb)->opbuf + j;
			if (op->opcode == OPCODE_NOP) continue;
			if (merge(opP, op)) {
				DBG_P("redo");
				goto L_HEAD;
			}
			//fprintf(stderr, "/////////// %2d:%2d {\n", i, j);
			//knh_opcode_dump(ctx, opP, KNH_STDERR, NULL);
			//knh_opcode_dump(ctx, op,  KNH_STDERR, NULL);
			//fprintf(stderr, "}///////////\n");
			opP = op;
		}
	}
	END_LOCAL(ctx, lsfp);
}
#endif /* K_USING_SSA_OPT */
