/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER
 *
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation
 * All rights reserved.
 *
 * You may choose one of the following two licenses when you use konoha.
 * See www.konohaware.org/license.html for further information.
 *
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

/* ************************************************************************ */

#include"commons.h"

/* ************************************************************************ */

#ifdef __cplusplus
extern "C" {
#endif


/* ======================================================================== */
/* [method] */

Object* new_String_parseOf(Ctx *ctx, String *p)
{
	return UP(p);
}

static knh_parser_drvapi_t PARSER__String = {
	KNH_DRVAPI_TYPE__PARSER, "_",
	TYPE_String,
	new_String_parseOf
};

/* ------------------------------------------------------------------------ */

KNHAPI(void) konoha_addParserDriver(Ctx *ctx, char *alias, knh_parser_drvapi_t *d)
{
	if(alias != NULL) {
		konoha_addDriverAPI(ctx, alias, (knh_drvapi_t*)d);
	}
	else {
		konoha_addDriverAPI(ctx, d->name, (knh_drvapi_t*)d);
	}
}

/* ------------------------------------------------------------------------ */

static
knh_parser_drvapi_t *knh_System_getParserDriver(Ctx *ctx, knh_bytes_t name)
{
	knh_drvapi_t *d = konoha_getDriverAPI(ctx, KNH_DRVAPI_TYPE__PARSER, name);
	if(d == NULL) {
		return &(PARSER__String);
	}
	KNH_ASSERT(d->type == KNH_DRVAPI_TYPE__PARSER);
	return (knh_parser_drvapi_t*)d;
}

/* ======================================================================== */
/* [method] */

knh_type_t	knh_ObjectParser_typing(Ctx *ctx, knh_bytes_t t)
{
	knh_index_t loc = knh_bytes_index(t, ':');
	if(loc <= 0) {
		return NNTYPE_String;
	}
	if(loc > 2 && t.buf[loc-2] == '!' && t.buf[loc-1] == '!') {
		return NNTYPE_Exception;
	}
	knh_parser_drvapi_t *d = knh_System_getParserDriver(ctx, knh_bytes_first(t, loc));
	return d->rtype;
}

/* ------------------------------------------------------------------------ */

Object *new_Object_parseOf(Ctx *ctx, String *s)
{
	knh_bytes_t t = knh_String_tobytes(s);
	knh_index_t loc = knh_bytes_index(t, ':');
	if(loc <= 0) {
		return UP(s);
	}
	if(loc > 2 && t.buf[loc-2] == '!' && t.buf[loc-1] == '!') {
		return UP(new_Exception(ctx, s));
	}
	knh_parser_drvapi_t *d = knh_System_getParserDriver(ctx, knh_bytes_first(t, loc));
	return d->parser(ctx, s);
}

/* ------------------------------------------------------------------------ */
/* ------------------------------------------------------------------------ */

#ifdef __cplusplus
}
#endif
