/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER
 *
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation
 * All rights reserved.
 *
 * You may choose one of the following two licenses when you use konoha.
 * See www.konohaware.org/license.html for further information.
 *
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

/* ************************************************************************ */

#include"commons.h"


/* ************************************************************************ */

#ifdef __cplusplus
extern "C" {
#endif

/* ======================================================================== */
/* [argc] */

// stackf (Ctx *ctx, Object **sf)
// this.func(a, b..)
// ebp
// sf[-1]  sf[0]  sf[1]  sf[2]
// sf[-1]  sf[0]  sf[1]  varg[0] varg[1]
// method  this   a      b
// method  this   a      b       b
//                               ebp
// return
// ebp

/* ------------------------------------------------------------------------ */

int knh_sfp_argc(Ctx *ctx, knh_sfp_t *varg)
{
	return (((Context*)ctx)->ebp - varg);
}

///* ------------------------------------------------------------------------ */
//
//Array *knh_sfp_toArray(Ctx *ctx, knh_sfp_t *varg)
//{
//	Array *a = new_Array(ctx, CLASS_Any, knh_sfp_argc(ctx, varg));
//	knh_sfp_t *p = varg;
//	while(p <= ((Context*)ctx)->ebp) {
//		knh_Array_add(ctx, a, p[0].o);
//		p++;
//	}
//	return a;
//}

/* ------------------------------------------------------------------------ */

KNHAPI_(void) knh_sfp_boxing(Ctx *ctx, knh_sfp_t *sfp)
{
	knh_class_t bcid = (sfp[0].o)->h.bcid;
	if(CLASS_Boolean <= bcid && bcid <= CLASS_Float
			&& sfp[0].data != (sfp[0].i)->n.data) {
		KNH_MOV(ctx, sfp[0].o, knh_boxing(ctx, sfp, knh_Object_cid(sfp[0].o)));
	}
}

/* ------------------------------------------------------------------------ */

KNHAPI_(void) knh_sfp_unboxing(Ctx *ctx, knh_sfp_t *sfp)
{
	sfp[0].data = (sfp[0].i)->n.ivalue;
}

///* ------------------------------------------------------------------------ */
//
//INLINE
//Method *knh_stackf_getMethod(Ctx *ctx, Object **sf)
//{
//	KNH_ASSERT(IS_Method(sf[-1]));
//	return (Method*)sf[-1];
//}

/* ======================================================================== */
/* [delta] */

//INLINE
//Struct *knh_stackf_structDelta(Ctx *ctx, Object **sf)
//{
//	KNH_ASSERT(IS_Method(sf[-1]));
//	return (Struct*)(&(KNH_FIELDn(sf[0], ((Method*)sf[-1])->delta)));
//}

/* ======================================================================== */
/* [call] */

void knh_dynamiccall(Ctx *ctx, knh_sfp_t *mbp)
{
//	Method *mtd = mbp[0].mtd;
//	knh_sfp_t *sfp = mbp + 1, *argv = mbp + 2;
//	knh_code_t *pc = (knh_code_t*)sfp[-1].op;
//	sfp[-1].op = 0;
//
//	KNH_ASSERT(IS_Method(mbp[0].mtd));
//
//	while(knh_sfp_argc(ctx, argv) < knh_Method_psize(mtd)) {
//		KNH_LPUSH(ctx, KNH_NULL);
//	}
//
//	{
//		size_t i;
//		for(i = 0; i < knh_Method_psize(mtd); i++) {
//			knh_mfield_t f = knh_Method_pfields(mtd, i);
//			knh_type_t t = knh_pmztype_totype(ctx, f.type, mbp[1].o->h.cid);
//			VM_TYPECHK(ctx, t, argv[i].o);
//		}
//
//		if(knh_Method_isVarArgs(mtd)) {
//			knh_mfield_t f = knh_Method_lastfield(mtd);
//			knh_type_t t = knh_pmztype_totype(ctx, f.type, mbp[1].o->h.cid);
//			for(i = knh_Method_psize(mtd); i < knh_sfp_argc(ctx, argv); i++) {
//				VM_TYPECHK(ctx, t, argv[i].o);
//			}
//		}
//	}
//	sfp[-1].op = (knh_stackop_t)pc;
	TODO();
}

/* ======================================================================== */
/* [movabletext] */

void knh_sfp_dump(Ctx *ctx, knh_sfp_t *sfp)
{
	fprintf(stderr, "\n** ** ** ** ** ** ** ** **\n");
	int i;
	if(sfp-1 > ctx->stack && IS_Method(sfp[-1].mtd)) {
		char buf[CLASSNAME_BUFSIZ];
		knh_format_cmethodn(ctx, buf, sizeof(buf), DP(sfp[-1].mtd)->cid, DP(sfp[-1].mtd)->mn);
		fprintf(stderr, "sfp[-1] %s op=%d\n", buf, (int)sfp[-1].op);
	}
	for(i = 0; sfp + i < ctx->ebp; i++) {
		fprintf(stderr, "sfp[%2d] %s op=%d\n", i, CLASSN(sfp[i].o->h.cid), (int)sfp[i].op);
	}
	for(i = 0; i < 2; i++) {
		fprintf(stderr, "ebp[%2d] %s op=%d\n", i, CLASSN(ctx->ebp[i].o->h.cid), (int)sfp[i].op);
	}
	fprintf(stderr, "** ** ** ** ** ** ** ** **\n");
}


/* ------------------------------------------------------------------------ */
/* ------------------------------------------------------------------------ */

KNHAPI(void) knh_sfp_sformat(Ctx *ctx, knh_sfp_t *sfp, Method *mtd, OutputStream *w, Any *m)
{
	KNH_ASSERT(IS_Method(mtd)); /*if(IS_NULL(mtd)) return ; */
	Object *o = (Object*)sfp[0].o;
	if(knh_Object_isCyclic(o) && knh_Object_isFormatted(o)) {
		knh_write_dots(ctx, w);
		return;
	}
	KNH_SWAP(ctx, sfp, 2, 0);  // it would be faster than move
	KNH_MOV(ctx, sfp[3].o, w);
	KNH_MOV(ctx, sfp[4].o, m);
	if(knh_Object_isCyclic(o)) {
		knh_Object_setFormatted(o, 1);
		KNH_SCALL(ctx, sfp, 1, mtd, /*args*/2);
		knh_Object_setFormatted(o, 0);
	}
	else {
		KNH_SCALL(ctx, sfp, 1, mtd, /*args*/2);
	}
	KNH_SWAP(ctx, sfp, 0, 2);  // for careful treatment
}

/* ------------------------------------------------------------------------ */

KNHAPI(void) knh_sfp_format(Ctx *ctx, knh_sfp_t *sfp, knh_methodn_t mn, OutputStream *w, Any *m)
{
	knh_sfp_sformat(ctx, sfp, knh_tMethod_findMT(ctx, knh_Object_cid(sfp[0].o), mn), w, m);
}

/* ------------------------------------------------------------------------ */

/* ======================================================================== */
/* [macros] */

#define _KNH_THROW(ctx, e) knh_throw(ctx, UP(e), KNH_SAFEFILE(__FILE__), __LINE__)

#define _KNH_THROWs(ctx, s) \
	knh_throwException(ctx, new_Exception__b(ctx, B(s)), KNH_SAFEFILE(__FILE__), __LINE__); \

#define _KNH_THROWf(ctx, fmt, ...) \
	char throwbuf_[256]; \
	knh_snprintf(throwbuf_, sizeof(throwbuf_), fmt, ## __VA_ARGS__); \
	knh_throwException(ctx, new_Exception__b(ctx, B(throwbuf_)), KNH_SAFEFILE(__FILE__), __LINE__); \

#define DEBUG_THROWf(ctx, fmt, ...) \
	fprintf(stderr, "THROW?[%s:%d]: ", __FUNCTION__, __LINE__); \
	fprintf(stderr, fmt, ## __VA_ARGS__); \
	fprintf(stderr, "\n"); \

#define _TODO_THROW(ctx) knh_throw_TODO(ctx, (char*)__FILE__, __LINE__, (char*)__FUNCTION__)

/* ======================================================================== */
/* [throw] */

KNHAPI(void) knh_throw_TODO(Ctx *ctx, char *file, int line, char *func)
{
	fprintf(stderr, "**************************************************************************\n");
	fprintf(stderr, "         THIS FUNCTION IS FULLY (OR PARTIALLY) NOT IMPLEMENTED.\n\n");
	fprintf(stderr, "   function: %s\n", func);
	fprintf(stderr, "   file='%s', line=%d\n\n", file, line);
	fprintf(stderr, "We will appliciate if you help us implementing this function. Thank you\n");
	fprintf(stderr, "for your cooperation.\n");
	fprintf(stderr, "**************************************************************************\n");
	knh_throwException(ctx, new_Exception__b(ctx, STEXT("UnsupportedOperation!!")), KNH_SAFEFILE(file), line);
}

/* ======================================================================== */
/* [throw] */

static
void knh_Exception_addStackTrace(Ctx *ctx, Exception *o, String *msg)
{
	KNH_ASSERT(IS_Exception(o));
	if(IS_NOTNULL(msg)) {
		if(IS_NULL(DP(o)->traces)) {
			KNH_SETv(ctx, DP(o)->traces, new_Array(ctx, CLASS_String, 16));
		}
		knh_Array_add(ctx, DP(o)->traces, UP(msg));
	}
}

/* ------------------------------------------------------------------------ */

static
String *knh_stackf_getStackTraceMsg(Ctx *ctx, knh_sfp_t *sfp)
{
	char *fn = "-";
	int  line = 0;
	if(sfp[-1].op != 0) {
		knh_sfp_t *prev_sfp = sfp;
		while(ctx->stack <= prev_sfp) {
			if(IS_Method(prev_sfp[0].o) && prev_sfp[0].op != 0) {
				fn = knh_Method_file(ctx, prev_sfp[0].mtd);
				line = knh_Method_pctoline(prev_sfp[0].mtd, (knh_code_t*)sfp[-1].op);
				break;
			}
			prev_sfp--;
		}
	}
	char bufm[CLASSNAME_BUFSIZ];
	char bufn[CLASSNAME_BUFSIZ*2];
	knh_snprintf(bufn, sizeof(bufn), "%s.%s:(%s:%d)",
		CLASSN(knh_Object_cid(sfp[0].o)), knh_format_methodn(ctx, bufm, sizeof(bufm), DP(sfp[-1].mtd)->mn), fn, line);
	return new_String(ctx, B(bufn), NULL);
}

/* ------------------------------------------------------------------------ */
/* @method void Context.%s(OutputStream w, String m) */

void knh_Context__s(Ctx *ctx, Context *o, OutputStream *w, String *m)
{
	char *fn = NULL;
	int  line = 0;
	knh_sfp_t *mtd_sfp = NULL, *prev_sfp = o->ebp;
	while(o->stack <= prev_sfp) {
		if(IS_Method(prev_sfp[0].o) && prev_sfp[0].op != 0) {
			if(mtd_sfp != NULL) {
				fn = knh_Method_file(ctx, prev_sfp[0].mtd);
				line = knh_Method_pctoline(prev_sfp[0].mtd, (knh_code_t*)mtd_sfp[-1].op);
				break;
			}
			mtd_sfp = prev_sfp;
		}
		prev_sfp--;
	}
	knh_putc(ctx, w, '[');
	if(o->doing == NULL) {
		knh_write__s(ctx, w, KONOHA_NAME);
	}
	else {
		knh_write__s(ctx, w, o->doing);
	}
	knh_putc(ctx, w, ']');
	if(fn != NULL) {
		knh_putc(ctx, w, '(');
		knh_write__s(ctx, w, KNH_SAFEFILE(fn));
		knh_putc(ctx, w, ':');
		knh_write__i(ctx, w, (knh_int_t)line);
		knh_putc(ctx, w, ')');
	}
}

/* ------------------------------------------------------------------------ */

KNHAPI(char*) konoha_doing(Ctx *ctx, char *msg)
{
	char *oldmsg = ctx->doing;
	((Context*)ctx)->doing = msg;
	return oldmsg;
}

/* ------------------------------------------------------------------------ */

KNHAPI(void) knh_throwException(Ctx *ctx, Exception *e, char *file, int line)
{
	Context *o = (Context*)ctx;
	KNH_ASSERT(IS_Exception(e));
	if(file != NULL) {
		DP(e)->file = file;
		DP(e)->line = line;
	}
	if(ctx == NULL) {
		goto L_ERROR;
	}
	((Context*)ctx)->doing = NULL; /* reset */
	while(o->stack <= o->ebp) {
		//DBG2_P("stack[%d]\t %s\n", (o->ebp - o->stack), CLASSNo(o->ebp[0].o));
		if(IS_ExceptionHandler(o->ebp[0].hdr) && knh_ExceptionHandler_isCatching(o->ebp[0].hdr)) {
			knh_ExceptionHandler_setCatching(o->ebp[0].hdr, 0);
			knh_ExceptionHandler_longjmp(ctx, o->ebp[0].hdr, e);
		}
		else if(IS_Method(o->ebp[0].o)) {
			//DBG2_P("pc = %p", (void*)o->ebp[0].op);
			if(o->ebp[0].op != 0) {
				knh_Exception_addStackTrace(ctx, e, knh_stackf_getStackTraceMsg(ctx, o->ebp+1));
			}
		}
		o->ebp--;
	}

	L_ERROR:;
	fprintf(stderr, "********** USE STACKTRACE IN YOUR C/C++ DEBUGGER ************\n");
	fprintf(stderr, "Uncaught Exception: %s\n", knh_String_tochar(DP(e)->message));
	fprintf(stderr, "*************************************************************\n");
	abort();
}

/* ------------------------------------------------------------------------ */

KNHAPI(void) knh_throw(Ctx *ctx, Object *e, char *file, int line)
{
	if(IS_NULL(e)) {
		knh_throwException(ctx, new_Exception__Nue(ctx, e), file, line);
	}else if(IS_Exception(e)) {
		knh_throwException(ctx, (Exception*)e, file, line);
	}else if(IS_bString(e)) {
		knh_throwException(ctx, new_Exception(ctx, (String*)e), file, line);
	}else {
		DBG2_P("Cannot throw %s", CLASSN(knh_Object_cid(e)));
		knh_throwException(ctx, new_Exception__b(ctx, STEXT("Type!!")), file, line);
	}
}

/* ------------------------------------------------------------------------ */

#ifdef __cplusplus
}
#endif
