/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER
 *
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation
 * All rights reserved.
 *
 * You may choose one of the following two licenses when you use konoha.
 * See www.konohaware.org/license.html for further information.
 *
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

/* ************************************************************************ */

#include"commons.h"

/* ************************************************************************ */

#ifdef __cplusplus
extern "C" {
#endif


/* ======================================================================== */
/* [func] */

static
MAPPER knh_fmapper_method(Ctx *ctx, knh_sfp_t *sfp)
{
	Method *mtd = (Method*)DP(sfp[1].mpr)->mapdata;
	KNH_ASSERT(IS_Method(mtd));
	KNH_SWAP(ctx, sfp, 1, 0);
	KNH_SCALL(ctx, sfp, 0, mtd, /*args */0);
}

/* ------------------------------------------------------------------------ */

static
knh_fmapper knh_tMapper_findFunc(Ctx *ctx, Object *mapdata, knh_class_t scid, knh_class_t tcid)
{
	if(IS_Method(mapdata)) return knh_fmapper_method;
	return knh_fmapper_null;
}

/* ======================================================================== */
/* [constructors] */

Mapper* new_Mapper(Ctx *ctx, knh_flag_t flag, knh_class_t scid, knh_class_t tcid, knh_fmapper fmap, Object *mapdata)
{
	knh_Mapper_t* o = (Mapper*)new_Object_bcid(ctx, CLASS_Mapper, 0);
	DP(o)->size = 0;
	DP(o)->flag = flag;
	DP(o)->scid = scid;
	DP(o)->tcid = tcid;
	if(fmap == NULL) {
		DP(o)->fmap = knh_tMapper_findFunc(ctx, mapdata, scid, tcid);
		KNH_ASSERT(fmap != NULL);
	}else {
		DP(o)->fmap = fmap;
	}
	KNH_SETv(ctx, DP(o)->mapdata, mapdata);
	o->fmap_1 = DP(o)->fmap;
	return o;
}

/* ======================================================================== */
/* [MapMap] */

static
MAPPER knh_fmapper_mapmap(Ctx *ctx, knh_sfp_t *sfp)
{
	Mapper *mpr = sfp[1].mpr;
	Mapper *m1 = DP(mpr)->m1, *m2 = DP(mpr)->m2;
	KNH_ASSERT(knh_Mapper_isMapMap(mpr));
	KNH_ASSERT(IS_Mapper(m1));
	KNH_MOV(ctx, sfp[1].o, m1);
	(m1)->fmap_1(ctx, sfp);
	if(IS_NULL(sfp[0].o)) return ;
	KNH_ASSERT(IS_Mapper(m2));
	KNH_MOV(ctx, sfp[1].o, m2);
	(m2)->fmap_1(ctx, sfp);
}

/* ------------------------------------------------------------------------ */

Mapper* new_MapMap(Ctx *ctx, Mapper *m1, Mapper *m2)
{
	knh_Mapper_t* o = (Mapper*)new_hObject(ctx, FLAG_Mapper, CLASS_Mapper, CLASS_Mapper);
	DP(o)->size = 0;
	DP(o)->flag = DP(m1)->flag | DP(m2)->flag;
	DP(o)->scid = DP(m1)->scid;
	DP(o)->tcid = DP(m2)->tcid;
	KNH_INITv(DP(o)->m1, m1);
	KNH_INITv(DP(o)->m2, m2);
	o->fmap_1 = knh_fmapper_mapmap;
	knh_Mapper_setMapMap(o, 1);
	return o;
}

/* ======================================================================== */
/* [methods] */

//INLINE
//Object *knh_Mapper_execMap(Ctx *ctx, Mapper *o, Object *sub)
//{
//	KNH_ASSERT(IS_Mapper(o));
//	return o->fmap_1(ctx, sub, o);
//}

/* ======================================================================== */
/* [movabletext] */
/* @method void Mapper.%k(OutputStream w, String m) */

void knh_Mapper__k(Ctx *ctx, Mapper *o, OutputStream *w, String *m)
{
	knh_write__type(ctx, w, DP(o)->scid);
	if(knh_Mapper_isTotal(o)) {
		knh_write(ctx, w, STEXT("==>"));
	}else{
		knh_write(ctx, w, STEXT("-->"));
	}
	knh_write__type(ctx, w, DP(o)->tcid);
	knh_putc(ctx, w, ':');
	knh_write__flag(ctx, w, DP(o)->flag);
}

/* ------------------------------------------------------------------------ */


#ifdef __cplusplus
}
#endif
