/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER
 *
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation
 * All rights reserved.
 *
 * You may choose one of the following two licenses when you use konoha.
 * See www.konohaware.org/license.html for further information.
 *
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

/* ************************************************************************ */

#define KNH_TOBJECT_C  1

#include"commons.h"

/* ************************************************************************ */

#ifdef __cplusplus
extern "C" {
#endif

#define KNH_STATMODE0   -1  /* @property */

/* ======================================================================== */
/* [malloc] */

/* ------------------------------------------------------------------------ */

void *knh_malloc(Ctx *ctx, size_t size)
{
#ifdef KONOHA_OS__TB
	if(size == 0) size=4;
#endif
	void *block = malloc(size);
	if (unlikely(block == NULL)) {
		KNH_EXIT("OutOfMemory!!: %d bytes used", (int)ctx->share->statUsedMemorySize);
		//KNH_THROWs(ctx, "OutOfMemory!!");
	}
#ifdef KNH_STATMODE0
	ctx->share->statUsedMemorySize += size;
#endif
	return block;
}

/* ------------------------------------------------------------------------ */

void knh_free(Ctx *ctx, void *block, size_t size)
{
#ifdef KNH_STATMODE0
	ctx->share->statUsedMemorySize -= size;
#endif
	free(block);
}

/* ------------------------------------------------------------------------ */

void *DBG2_malloc(Ctx *ctx, size_t size, char *func)
{
	size_t *block = (size_t*)malloc(size + sizeof(size_t));
	//if(size >32) { fprintf(stdout, "%p: M(%s, size=%d)\n", block, func, (int)size); };
	if (unlikely(block == NULL)) {
		KNH_EXIT("OutOfMemory!!: %d bytes used", (int)ctx->share->statUsedMemorySize);
		//KNH_THROWs(ctx, "OutOfMemory!!");
	}
#ifdef KNH_STATMODE0
	ctx->share->statUsedMemorySize += size;
#endif
	block[0] = size;
	void *p = (void*)(block + 1);
//	knh_bzero(p, size);
	return p;
}

/* ------------------------------------------------------------------------ */

void DBG2_free(Ctx *ctx, void *p, size_t size, char *func)
{
	size_t *block = ((size_t*)p) - 1;
#ifdef KNH_STATMODE0
	ctx->share->statUsedMemorySize -= size;
#endif
	if(size != block[0]) {
		fprintf(stderr, "%s: ptr = %p, block.size = %d, free.size=%d", func, p, (int)block[0], (int)size);
		KNH_ASSERT(size == block[0]);
	}
	block[0]=0;
	//if(size > 32) { fprintf(stdout, "%p: F(%s, size=%d)\n", block, func, (int)size); };
	free(block);
}

/* ======================================================================== */
/* [tObject] */

#define KNH_OBJECT_REUSE(ctx, used) { \
		used->ref = ctx->unusedObject;\
		((knh_Context_t*)ctx)->unusedObject = used;\
		((knh_Context_t*)ctx)->unusedObjectSize += 1;\
	}\

/* ------------------------------------------------------------------------ */

#ifdef KNH_USING_DRCGC
static size_t knh_CollectCount = 0;
#endif

/* ------------------------------------------------------------------------ */

int konoha_RCcollect(Ctx *ctx)
{
	int c = 0;
#ifdef KNH_USING_DRCGC
	int i, j;
	//fprintf(stderr, "GC starting collector for %d objects\n", (int)(knh_tObjectTableSize * KNH_TOBJECT_SIZE));
	for(j = 0; j < 	knh_tObjectTableSize; j++) {
		knh_Object_t *t = knh_tObjectTable[j];
		for(i = 0; i < KNH_TOBJECT_SIZE; i++) {
			if(t[i].h.magic != KNH_OBJECT_MAGIC) continue;
			if(t[i].h.refc == 0) {
				knh_Object_free(ctx, t+i);
				c++;
			}
		}
	}
	//fprintf(stderr, "GC collected %d objects\n", c);
	knh_CollectCount++;
#endif
	return c;
}

/* ------------------------------------------------------------------------ */

static
knh_Object_t *new_UnusedObject(Ctx *ctx)
{
	DBG2_P("********** new page %p ***************", ctx);
	KNH_LOCK(ctx, ctx->objectLock);
	knh_ContextShare_t *ctxshr = ctx->share;
	if(unlikely(!(ctxshr->tObjectTableSize < ctxshr->maxObjectTableSize))) {
		KNH_UNLOCK(ctx, ctx->objectLock);
		KNH_EXIT("Enlarge osize %d x 4096", ctxshr->maxObjectTableSize);
		return NULL;
	}
	knh_Object_t *t = (knh_Object_t*)KNH_MALLOC(ctx, SIZEOF_TOBJECT);
	ctx->tObjectTable[ctxshr->tObjectTableSize] = t;
	int i;
	for(i = 0; i < KNH_TOBJECT_SIZE - 1; i++) {
		t[i].h.magic = 0;
		t[i].ref = &(t[i+1]);
	}
	t[KNH_TOBJECT_SIZE - 1].ref = ctx->unusedObject;
	((Context*)ctx)->unusedObjectSize += KNH_TOBJECT_SIZE;
	ctxshr->tObjectTableSize += 1;
	KNH_UNLOCK(ctx, ctx->objectLock);
	return t;
}

/* ------------------------------------------------------------------------ */

//static
//knh_Object_t *new_UnusedObjectDRC(Ctx *ctx)
//{
//	DBG2_P("********** new page %p ***************", ctx);
//	knh_Object_t *t;
//	int i = konoha_RCcollect(ctx);
//	if(i > KNH_TOBJECT_SIZE / 2) {
//		if(ctx == NULL) {
//			KNH_ASSERT(knh_UnusedObject != NULL);
//			return knh_UnusedObject;
//		}
//		else {
//			KNH_ASSERT(ctx->unusedObject != NULL);
//			return ctx->unusedObject;
//		}
//	}
//	KNH_SLOCK();
//	if(unlikely(!(ctx->share->tObjectTableSize < KNH_TOBJECTLIST_SIZE))) {
//		KNH_EXIT("Enlarge KNH_TOBJECTLIST_SIZE %d x %d",
//				KNH_TOBJECTLIST_SIZE, KNH_TOBJECT_SIZE);
//		return NULL;
//	}
//	t = (knh_Object_t*)KNH_MALLOC(ctx, SIZEOF_TOBJECT);
//	ctx->tObjectTable[ctx->share->tObjectTableSize] = t;
//	for(i = 0; i < KNH_TOBJECT_SIZE - 1; i++) {
//		t[i].h.magic = 0;
//		t[i].ref = &(t[i+1]);
//	}
//	if(unlikely(ctx == NULL)) {
//		t[KNH_TOBJECT_SIZE - 1].ref = knh_UnusedObject;
//		knh_UnusedObjectSize += KNH_TOBJECT_SIZE;
//	}
//	else {
//		t[KNH_TOBJECT_SIZE - 1].ref = ctx->unusedObject;
//		((Context*)ctx)->unusedObjectSize += KNH_TOBJECT_SIZE;
//	}
//	ctx->share->tObjectTableSize++;
//	KNH_UNSLOCK();
//	return t;
//}

/* ------------------------------------------------------------------------ */
/* [fastmalloc] */

void *knh_fastmalloc(Ctx *ctx, size_t size)
{
	if(size <= KNH_FASTMALLOC_SIZE) {
		if(unlikely(ctx->unusedObject == NULL)) {
			KNH_ASSERT(ctx->unusedObjectSize == 0);
			((knh_Context_t*)ctx)->unusedObject = new_UnusedObject(ctx);
		}
		knh_Object_t *o = ctx->unusedObject;
		((knh_Context_t*)ctx)->unusedObject = (knh_Object_t*)o->ref;
		((knh_Context_t*)ctx)->unusedObjectSize -= 1;
		o->h.magic = KNH_FASTMALLOC_MAGIC;
		void **p = (void**)o;
		return (void*)(p+1);
	}
	void *block = malloc(size);
	if (unlikely(block == NULL)) {
		KNH_EXIT("OutOfMemory!!: %d bytes used", (int)ctx->share->statUsedMemorySize);
		//KNH_THROWs(ctx, "OutOfMemory!!");
	}
#ifdef KNH_STATMODE0
	ctx->share->statUsedMemorySize += size;
#endif
	return block;
}

/* ------------------------------------------------------------------------ */

void knh_fastfree(Ctx *ctx, void *block, size_t size)
{
	if(size <= KNH_FASTMALLOC_SIZE) {
		knh_Object_t *o = (knh_Object_t*)(((knh_int_t*)block)-1);
		assert(o->h.magic == KNH_FASTMALLOC_MAGIC);
		o->h.magic = 0;
		o->ref = ctx->unusedObject;
		((knh_Context_t*)ctx)->unusedObject = o;
		((knh_Context_t*)ctx)->unusedObjectSize += 1;
		return;
	}
#ifdef KNH_STATMODE0
	ctx->share->statUsedMemorySize -= size;
#endif
	free(block);
}

/* ------------------------------------------------------------------------ */
/* [hObject] */

knh_Object_t *new_hObject(Ctx *ctx, knh_flag_t flag, knh_class_t bcid, knh_class_t cid)
{
	KNH_ASSERT(bcid != CLASS_Context);
	KNH_ASSERT(bcid < KNH_TSTRUCT_SIZE);
	KNH_ASSERT(ctx != NULL);
	if(unlikely(ctx->unusedObject == NULL)) {
		KNH_ASSERT(ctx->unusedObjectSize == 0);
		((knh_Context_t*)ctx)->unusedObject = new_UnusedObject(ctx);
	}
	{
		knh_Object_t *o = ctx->unusedObject;
		((knh_Context_t*)ctx)->unusedObject = (knh_Object_t*)o->ref;
		((knh_Context_t*)ctx)->unusedObjectSize -= 1;
#ifdef KNH_STATMODE0
		ctx->share->statUsedObjectSize += 1;
#endif
		o->h.magic = KNH_OBJECT_MAGIC;
#ifdef KNH_HOBJECT_REFC
		o->h.refc = KNH_RCGC_INIT;
#endif
		o->h.flag = flag;
		o->h.bcid = bcid;
		o->h.cid  = cid;
		DBG2_({o->ref = NULL;});
		return o;
	}
}

/* ------------------------------------------------------------------------ */

knh_Object_t *new_Object_bcid(Ctx *ctx, knh_class_t bcid, int init)
{
	KNH_ASSERT(bcid != CLASS_Context);
	KNH_ASSERT(bcid < KNH_TSTRUCT_SIZE);
	if(unlikely(ctx->unusedObject == NULL)) {
		KNH_ASSERT(ctx->unusedObjectSize == 0);
		((knh_Context_t*)ctx)->unusedObject = new_UnusedObject(ctx);
	}
	{
		knh_Object_t *o = ctx->unusedObject;
		((knh_Context_t*)ctx)->unusedObject = (knh_Object_t*)o->ref;
		((knh_Context_t*)ctx)->unusedObjectSize -= 1;

#ifdef KNH_STATMODE0
		ctx->share->statUsedObjectSize += 1;
#endif
		o->h.magic = KNH_OBJECT_MAGIC;
#ifdef KNH_HOBJECT_REFC
		o->h.refc = KNH_RCGC_INIT;
#endif
		o->h.flag = ctx->tStruct[bcid].flag;
		o->h.bcid = bcid;
		o->h.cid  = bcid;
		size_t size = ctx->tStruct[bcid].size;
		//DBG2_P("cid=%d,%s,size=%d", bcid, STRUCTN(bcid), size);
		if(size > 0) {
			o->ref = KNH_MALLOC(ctx, size);
		}
		else {
			o->ref = NULL;
		}
		ctx->tStruct[bcid].finit(ctx, o, init);
		return o;
	}
}

/* ------------------------------------------------------------------------ */

knh_Object_t *new_Object_init(Ctx *ctx, knh_flag_t flag, knh_class_t cid, int init)
{
	KNH_ASSERT(cid != CLASS_Context);
	if(ctx->unusedObject == NULL) {
		KNH_ASSERT(ctx->unusedObjectSize == 0);
		((knh_Context_t*)ctx)->unusedObject = new_UnusedObject(ctx);
	}
	{
		knh_Object_t *o = ctx->unusedObject;
		((knh_Context_t*)ctx)->unusedObject = (knh_Object_t*)o->ref;
		((knh_Context_t*)ctx)->unusedObjectSize -= 1;

#ifdef KNH_STATMODE0
		ctx->share->statUsedObjectSize += 1;
#endif
		o->h.magic = KNH_OBJECT_MAGIC;
#ifdef KNH_HOBJECT_REFC
		o->h.refc = KNH_RCGC_INIT;
#endif
		KNH_ASSERT_cid(cid);
		knh_class_t bcid = ctx->tClass[cid].bcid;
		o->h.bcid = bcid;
		o->h.flag = ctx->tClass[cid].oflag | flag;
		o->h.cid  = cid;
		size_t size = ctx->tClass[cid].size;
		if(size > 0) {
			o->ref = KNH_MALLOC(ctx, size);
		}
		else {
			o->ref = NULL;
		}
		ctx->tStruct[bcid].finit(ctx, o, init);
		return o;
	}
}


/* ------------------------------------------------------------------------ */

void knh_Object_free(Ctx *ctx, knh_Object_t *o)
{
	KNH_ASSERT(knh_Object_isRC0(o));
//	DBG2_P("o=%p, sid=%d,%s", o, o->h.bcid, STRUCTN(o->h.bcid));
//	DBG2_ABORT();
	if(unlikely(o->h.magic == 0)) return;
	o->h.magic = 0;
	ctx->tStruct[o->h.bcid].ftraverse(ctx, o, knh_Object_sweep);
	size_t size = ctx->tClass[o->h.cid].size;
	if(size > 0) {
		KNH_FREE(ctx, o->ref, size);
	}
#ifdef KNH_FLAG_OF_METADATA
	if((o->h.flag & KNH_FLAG_OF_METADATA) == KNH_FLAG_OF_METADATA && ctx != NULL) {
		TODO();
//		knh_metadata_clear(ctx, o);
	}
#endif

	if(o->h.bcid == CLASS_Context) return;
	KNH_OBJECT_REUSE(ctx, o);
#ifdef KNH_STATMODE0
	ctx->share->statUsedObjectSize -= 1;
#endif
}

/* ------------------------------------------------------------------------ */

void knh_Object_traverse(Ctx *ctx, knh_Object_t *o, knh_ftraverse ftr)
{
	if(IS_SWEEP(ftr)) {
		knh_Object_free(ctx, o);
		return;
	}
	ctx->tStruct[o->h.bcid].ftraverse(ctx, o, ftr);
}

/* ------------------------------------------------------------------------ */

KNHAPI_(Object*) knh_boxing(Ctx *ctx, knh_sfp_t *sfp, knh_class_t cid)
{
	KNH_ASSERT(ctx != NULL);
	if(unlikely(ctx->unusedObject == NULL)) {
		KNH_ASSERT(ctx->unusedObjectSize == 0);
		((knh_Context_t*)ctx)->unusedObject = new_UnusedObject(ctx);
	}
	{
		knh_Object_t *o = ctx->unusedObject;
		((knh_Context_t*)ctx)->unusedObject = (knh_Object_t*)o->ref;
		((knh_Context_t*)ctx)->unusedObjectSize -= 1;

#ifdef KNH_STATMODE1
		knh_statUsedObjectSize++;
#endif
		o->h.magic = KNH_OBJECT_MAGIC;
#ifdef KNH_HOBJECT_REFC
		o->h.refc = KNH_RCGC_INIT;
#endif
		o->h.flag = FLAG_Float;
		o->h.bcid = ctx->tClass[cid].bcid;
		o->h.cid  = cid;
		knh_Float_t *v = (knh_Float_t*)o;
		v->n.data = sfp[0].data;
		//DBG2_P("cid=%s, ivalue=%lld, fvalue=%f", CLASSN(cid), v->n.ivalue, v->n.fvalue);
		return o;
	}
}

/* ========================================================================= */

//void knh_fgchook_sync(Ctx *ctx)
//{
//	ctx->recentCreatedObject = NULL;
//}

/* ------------------------------------------------------------------------ */

void knh_fgchook_nop(Ctx *ctx)
{

}

/* ------------------------------------------------------------------------ */

void knh_fgchook_collect(Ctx *ctx)
{

}

/* ========================================================================= */

void knh_Object_mark0(Ctx *ctx, Object *o)
{
	if(knh_Object_isGCMarked(o)) {
		knh_Object_setGCMarked(o, 0);
		knh_Object_traverse(ctx, o, knh_Object_mark0);
	}
}

/* ------------------------------------------------------------------------ */

void knh_Object_sweep0(Ctx *ctx, Object *o)
{
	if(!knh_Object_isGCMarked(o)) {
		knh_Object_traverse(ctx, o, knh_Object_sweep0);
	}
}

/* ------------------------------------------------------------------------ */

void knh_Object_mark1(Ctx *ctx, Object *o)
{
	if(!knh_Object_isGCMarked(o)) {
		knh_Object_setGCMarked(o, 1);
		knh_Object_traverse(ctx, o, knh_Object_mark1);
	}
}

/* ------------------------------------------------------------------------ */

void knh_Object_sweep1(Ctx *ctx, Object *o)
{
	if(knh_Object_isGCMarked(o)) {
		knh_Object_traverse(ctx, o, knh_Object_sweep1);
	}
}

/* ------------------------------------------------------------------------ */

void knh_Object_RCsweep(Ctx *ctx, Object *o)
{
	knh_Object_RCdec(o);
	if(knh_Object_isRC0(o)) {
		knh_Object_free(ctx, o);
	}
}

/* ------------------------------------------------------------------------ */

knh_ftraverse konoha_getDefaultSweepFunction()
{
	return knh_Object_RCsweep;
}

///* ------------------------------------------------------------------------ */
//
//#define P11 ((knh_uint32_t)3)
//#define P10 ((knh_uint32_t)2)
//#define P01 ((knh_uint32_t)1)
//
//static const knh_uint32_t mask11[] = {
//	P11 << 30, P11 << 28, P11 << 26, P11 << 24,
//	P11 << 22, P11 << 20, P11 << 18, P11 << 16,
//	p11 << 14, P11 << 12, P11 << 10, P11 << 8,
//	P11 << 6,  P11 << 4,  P11 << 2,  P11 << 0
//};
//
///* ------------------------------------------------------------------------ */
//
//void bitmap_unused(knh_uint32_t bitmap[256], size_t n)
//{
//	knh_uint32_t b = bitmap[n / 16];
//	bitmap[n / 16] = ~mask11[n % 16];
//}


#ifdef __cplusplus
}
#endif
