/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER
 *
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation
 * All rights reserved.
 *
 * You may choose one of the following two licenses when you use konoha.
 * See www.konohaware.org/license.html for further information.
 *
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

/* ************************************************************************ */

#include"commons.h"

/* ************************************************************************ */

#ifdef __cplusplus
extern "C" {
#endif

/* ------------------------------------------------------------------------ */
/* [macros] */


#define _knh_Method_mn(mtd)    DP(mtd)->mn
#define _knh_Method_mf(mtd)    DP(mtd)->mf

METHOD knh_fmethod_abstract(Ctx *ctx, knh_sfp_t *sfp);

/* ======================================================================== */
/* [MethodField] */

MethodField* new_MethodField(Ctx *ctx, size_t size)
{
	return (knh_MethodField_t*)new_Object_init(ctx, FLAG_MethodField, CLASS_MethodField, size);
}

/* ======================================================================== */
/* [param] */

#define _knh_MethodField_rsize(mf)    ((mf)->rsize)
#define _knh_MethodField_rztype(mf)   ((mf)->params[0].type)
#define _knh_MethodField_psize(mf)    ((mf)->size - (mf)->rsize)

#define _knh_Method_rsize(mtd)       ((DP(mtd)->mf)->rsize)
#define _knh_Method_rztype(mtd)      ((DP(mtd)->mf)->params[0].type)
#define _knh_Method_psize(mtd)       ((DP(mtd)->mf)->size - (DP(mtd)->mf)->rsize)
#define _knh_Method_pztype(mtd,n)    knh_MethodField_pztype(DP(mtd)->mf,n)

#define _KONOHA_LASTPARAM     256

/* ------------------------------------------------------------------------ */

knh_type_t knh_MethodField_pztype(MethodField *o, size_t n)
{
	if(n + o->rsize < o->size) {
		return o->params[n + o->rsize].type;
	}
	DBG2_ASSERT(o->size-1 >= 0);
	return o->params[o->size - 1].type;
}

/* ------------------------------------------------------------------------ */

knh_mfield_t knh_MethodField_pfield(MethodField *o, size_t n)
{
	if(n + o->rsize < o->size) {
		return o->params[n + o->rsize];
	}
	DBG2_ASSERT(o->size-1 >= 0);
	return o->params[o->size - 1];
}

/* ------------------------------------------------------------------------ */

knh_type_t knh_Method_rtype(Ctx *ctx, knh_class_t cid, Method *mtd)
{
	return knh_pmztype_totype(ctx, DP(mtd)->mf->params[0].type, cid);
}

/* ------------------------------------------------------------------------ */

knh_type_t knh_Method_ptype(Ctx *ctx, knh_class_t cid, Method *o, size_t n)
{
	return knh_pmztype_totype(ctx, knh_MethodField_pztype(DP(o)->mf, n), cid);
}

/* ------------------------------------------------------------------------ */

knh_mfield_t knh_Method_pfield(Method *o, size_t n)
{
	return knh_MethodField_pfield(DP(o)->mf, n);
}

/* ------------------------------------------------------------------------ */
/* [Type] */

int knh_MethodField_equalsType(MethodField *o, MethodField *o2)
{
	size_t i;
	if(o->size != o2->size || o->rsize != o2->rsize) return 0;
	for(i = 0; i < o->size; i++) {
		if(o->params[i].type != o2->params[i].type) return 0;
	}
	return 1;
}

/* ------------------------------------------------------------------------ */

///* ------------------------------------------------------------------------ */
//
//knh_mfield_t knh_MethodField_lastfield(MethodField *o)
//{
//	return DP(o)->params[DP(o)->size-1];
//}
//
//#define _knh_Method_lastfield(mtd)   knh_MethodField_lastfield(knh_Method_mf(mtd))
//
//
///* ======================================================================== */
///* [hcode] */
//
//static
//knh_hcode_t knh_methodfield_hcode(knh_type_t r, knh_type_t a0, knh_type_t a1)
//{
//	return (r + a0) + (a1 << 4);
//}
//
///* ------------------------------------------------------------------------ */
//
//knh_hcode_t knh_MethodField_hcode(MethodField *o)
//{
//	switch(DP(o)->size) {
//		case 0: return knh_methodfield_hcode(0, 0, 0);
//		case 1: return knh_methodfield_hcode(DP(o)->params[0].type, 0, 0);
//		case 2: return knh_methodfield_hcode(DP(o)->params[0].type, DP(o)->params[1].type, 0);
//	}
//	return knh_methodfield_hcode(DP(o)->params[0].type, DP(o)->params[1].type, DP(o)->params[2].type);
//}
//
//
///* ======================================================================== */
///* [flag] */
//
//void knh_MethodField_setVarArgs(MethodField *o)
//{
//#ifdef MF_VARARGS
//	DP(o)->flag |= MF_VARARGS;
//#endif
//}
//
///* ------------------------------------------------------------------------ */
//
//knh_bool_t knh_MethodField_isVarArgs(MethodField *o)
//{
//#ifdef MF_VARARGS
//	return ((DP(o)->flag & MF_VARARGS) == MF_VARARGS);
//#endif
//	return 0;
//}


/* ======================================================================== */
/* [AbstractMethod] */

METHOD knh_fmethod_abstract(Ctx *ctx, knh_sfp_t *sfp)
{
	Method *mtd = sfp[-1].mtd;
	knh_cwb_t cb = new_cwb(ctx);
	knh_printf(ctx, cb.w, "AbstractMethod!!: %C.%M", knh_Object_cid(sfp[0].o), DP(mtd)->mn);
	String *s = new_String__cwb(ctx, cb);
	KNH_THROW(ctx, s);
}

/* ------------------------------------------------------------------------ */
/* @method Boolean! Method.isAbstract() */

knh_bool_t knh_Method_isAbstract(Method *o)
{
	return (DP(o)->fproceed == knh_fmethod_abstract);
}

/* ------------------------------------------------------------------------ */

void knh_Method_toAbstract(Ctx *ctx, Method *o)
{
	if(knh_Method_isObjectCode(o)) {
		KNH_FINALv(ctx, DP(o)->code);
		knh_Method_setObjectCode(o, 0);
	}
	knh_Method_syncfunc(o, knh_fmethod_abstract);
	o->pc_start  = NULL;
}

/* ======================================================================== */
/* [Method] */

void knh_Method_syncfunc(Method *o, knh_fmethod f)
{
	DP(o)->fproceed = f;
	(o)->fcall_1 = f;
}

/* ------------------------------------------------------------------------ */

Method* new_Method(Ctx *ctx, knh_flag_t flag, knh_class_t cid, knh_methodn_t mn, knh_fmethod func)
{
	Method* o = (Method*)new_Object_bcid(ctx, CLASS_Method, 0);
	DP(o)->flag  = flag;
	DP(o)->cid    = cid;
	DP(o)->mn     = mn;
	if(METHODN_IS_MOVTEXT(DP(o)->mn)) {
		KNH_SETv(ctx, DP(o)->mf, MF_void_OutputStream_Any);
	}
	func = (func == NULL) ? knh_fmethod_abstract : func;
	knh_Method_syncfunc(o, func);
	DP(o)->code  = NULL;
	o->pc_start  = NULL;
	return o;
}

///* ------------------------------------------------------------------------ */
//
//knh_hcode_t knh_Method_hashCode(Ctx *ctx, Method *o)
//{
//	knh_hcode_u u;
//	u.value2.u1 = DP(o)->cid;
//	u.value2.u1 = DP(o)->mn;
//	return u.hcode;
//}
//
///* ------------------------------------------------------------------------ */
//
//int knh_Method_compareTo(Ctx *ctx, Method *o, Method *o2)
//{
//	char buf[CLASSNAME_BUFSIZ], buf2[CLASSNAME_BUFSIZ];
//	return knh_strcmp(
//		knh_format_cmethodn(buf, sizeof(buf), DP(o)->cid, DP(o)->mn),
//		knh_format_cmethodn(buf2, sizeof(buf2), DP(o)->cid, DP(o2)->mn));
//}

/* ======================================================================== */
/* [NoSuchMethod] */

static
METHOD knh_fmethod_NoSuchMethod(Ctx *ctx, knh_sfp_t *sfp)
{
	Method *mtd = sfp[-1].mtd;
	char bufcm[CLASSNAME_BUFSIZ];
	knh_format_cmethodn(ctx, bufcm, sizeof(bufcm), knh_Object_cid(sfp[0].o), DP(mtd)->mn);
	String *s = new_String(ctx, B(bufcm), NULL);
	KNH_THROW(ctx, s);
}

/* ------------------------------------------------------------------------ */

knh_bool_t knh_Method_isNoSuchMethod(Method *o)
{
	return (DP(o)->fproceed == knh_fmethod_NoSuchMethod);
}

/* ------------------------------------------------------------------------ */

Method* new_Method__NoSuchMethod(Ctx *ctx, knh_class_t cid, knh_methodn_t mn)
{
	Method *mtd = new_Method(ctx, 0, cid, mn, knh_fmethod_NoSuchMethod);
	return mtd;
}

/* ======================================================================== */
/* [method type] */

int knh_methodn_isNew(Ctx *ctx, knh_methodn_t mn)
{
	if(mn == METHODN_new) return 1;
	if(METHODN_IS_MOVTEXT(mn) || METHODN_IS_GETTER(mn) || METHODN_IS_SETTER(mn)) {
		return 0;
	}
	char *n = FIELDN(METHODN_TOFIELDN(mn));
	if(n[0] == 'n' && n[1] == 'e' && n[2] == 'w' && n[3] == ':') {
		return 1;
	}
	return 0;
}

/* ------------------------------------------------------------------------ */

int knh_Method_isNew(Ctx *ctx, Method *o)
{
	knh_class_t rtype = CLASS_type(knh_Method_rztype(o));
	if(rtype != DP(o)->cid) {
		return 0;
	}
	return knh_methodn_isNew(ctx, DP(o)->mn);
}

/* ------------------------------------------------------------------------ */

int knh_methodn_isOp(Ctx *ctx, knh_methodn_t mn)
{
	if(METHODN_IS_MOVTEXT(mn) || METHODN_IS_GETTER(mn) || METHODN_IS_SETTER(mn)) {
		return 0;
	}
	char *n = FIELDN(METHODN_TOFIELDN(mn));
	if(n[0] == 'o' && n[1] == 'p' && isupper(n[2])) {
		return 1;
	}
	return 0;
}

/* ======================================================================== */
/* [methods] */

/* ------------------------------------------------------------------------ */
/* @method String! Method.getName() */

INLINE
String* knh_Method_getName(Ctx *ctx, Method *o)
{
	char buf[CLASSNAME_BUFSIZ];
	knh_format_methodn(ctx, buf, sizeof(buf), DP(o)->mn);
	return new_String(ctx, B(buf), NULL);
}

/* ------------------------------------------------------------------------ */
/* @method String! Method.getURN() */

String* knh_Method_getURN(Ctx *ctx, Method *o)
{
	char buf[CLASSNAME_BUFSIZ];
	char buf2[CLASSNAME_BUFSIZ];
	knh_format_methodn(ctx, buf2, sizeof(buf2), DP(o)->mn);
	knh_snprintf(buf, sizeof(buf), "%s.%s", CLASSN(DP(o)->cid), buf2);
	return new_String(ctx, B(buf), NULL);
}

/* ======================================================================== */
/* [Weaving] */

int knh_Method_isWoven(Method *mtd)
{
	return (mtd->fcall_1 != DP(mtd)->fproceed);
}

/* ------------------------------------------------------------------------ */

int knh_Method_canWeave(Ctx *ctx, Method *mtd, Method *aspect)
{
	if(knh_Method_isGenerator(mtd) || knh_Method_isAspect(mtd)) {
		TODO();
		return 0;
	}
	if(!IS_Method(aspect)) return 1; /* remove aspect */
	if(knh_Method_isWoven(aspect)) {
		KNH_WARNING(ctx, "nested aspect is not supported");
		return 0;
	}
	if(knh_Method_isAspect(aspect)) return 1;
	if(knh_Method_isVarArgs(mtd)) {
		KNH_WARNING(ctx, "variable length method can be woven");
		return 0;
	}
	if(knh_MethodField_equalsType(DP(mtd)->mf, DP(aspect)->mf)) {
		return 1;
	}
	return 0;
}

/* ------------------------------------------------------------------------ */

void knh_Method_weave(Ctx *ctx, Method *aspect, Method *mtd)
{
	if(IS_Method(aspect)) {
		mtd->fcall_1 = aspect->fcall_1;
		mtd->pc_start = aspect->pc_start;
	}
	else { /* remove aspect */
		mtd->fcall_1 = DP(mtd)->fproceed;
		mtd->pc_start = knh_Method_pcstartNULL(mtd);
	}
}

/* ------------------------------------------------------------------------ */

#ifdef __cplusplus
}
#endif
