/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER
 *
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation
 * All rights reserved.
 *
 * You may choose one of the following two licenses when you use konoha.
 * See www.konohaware.org/license.html for further information.
 *
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

/* ************************************************************************ */

#include"commons.h"


/* ************************************************************************ */

#ifdef __cplusplus
extern "C" {
#endif


/* ======================================================================== */
/* [argc] */

// stackf (Ctx *ctx, Object **sf)
// this.func(a, b..)
// ebp
// sf[-1]  sf[0]  sf[1]  sf[2]
// sf[-1]  sf[0]  sf[1]  varg[0] varg[1]
// method  this   a      b
// method  this   a      b       b
//                               ebp
// return
// ebp

/* ------------------------------------------------------------------------ */

knh_vargc_t knh_sfp_argc(Ctx *ctx, knh_sfp_t *varg)
{
	return (((Context*)ctx)->ebp - varg);
}

///* ------------------------------------------------------------------------ */
//
//Array *knh_sfp_toArray(Ctx *ctx, knh_sfp_t *varg)
//{
//	Array *a = new_Array(ctx, CLASS_Any, knh_sfp_argc(ctx, varg));
//	knh_sfp_t *p = varg;
//	while(p <= ((Context*)ctx)->ebp) {
//		knh_Array_add(ctx, a, p[0].o);
//		p++;
//	}
//	return a;
//}

/* ------------------------------------------------------------------------ */

KNHAPI_(void) knh_sfp_boxing(Ctx *ctx, knh_sfp_t *sfp)
{
	knh_class_t bcid = (sfp[0].o)->h.bcid;
	if(CLASS_Boolean <= bcid && bcid <= CLASS_Float
			&& sfp[0].data != (sfp[0].i)->n.data) {
		KNH_MOV(ctx, sfp[0].o, knh_boxing(ctx, sfp, knh_Object_cid(sfp[0].o)));
	}
}

/* ------------------------------------------------------------------------ */

KNHAPI_(void) knh_sfp_unboxing(Ctx *ctx, knh_sfp_t *sfp)
{
	sfp[0].data = (sfp[0].i)->n.ivalue;
}

///* ------------------------------------------------------------------------ */
//
//INLINE
//Method *knh_stackf_getMethod(Ctx *ctx, Object **sf)
//{
//	KNH_ASSERT(IS_Method(sf[-1]));
//	return (Method*)sf[-1];
//}

/* ======================================================================== */
/* [delta] */

//INLINE
//Struct *knh_stackf_structDelta(Ctx *ctx, Object **sf)
//{
//	KNH_ASSERT(IS_Method(sf[-1]));
//	return (Struct*)(&(KNH_FIELDn(sf[0], ((Method*)sf[-1])->delta)));
//}

/* ======================================================================== */
/* [call] */

void knh_dynamiccall(Ctx *ctx, knh_sfp_t *mbp)
{
//	Method *mtd = mbp[0].mtd;
//	knh_sfp_t *sfp = mbp + 1, *argv = mbp + 2;
//	knh_code_t *pc = (knh_code_t*)sfp[-1].op;
//	sfp[-1].op = 0;
//
//	KNH_ASSERT(IS_Method(mbp[0].mtd));
//
//	while(knh_sfp_argc(ctx, argv) < knh_Method_psize(mtd)) {
//		KNH_LPUSH(ctx, KNH_NULL);
//	}
//
//	{
//		size_t i;
//		for(i = 0; i < knh_Method_psize(mtd); i++) {
//			knh_mfield_t f = knh_Method_pfields(mtd, i);
//			knh_type_t t = knh_pmztype_totype(ctx, f.type, mbp[1].o->h.cid);
//			VM_TYPECHK(ctx, t, argv[i].o);
//		}
//
//		if(knh_Method_isVarArgs(mtd)) {
//			knh_mfield_t f = knh_Method_lastfield(mtd);
//			knh_type_t t = knh_pmztype_totype(ctx, f.type, mbp[1].o->h.cid);
//			for(i = knh_Method_psize(mtd); i < knh_sfp_argc(ctx, argv); i++) {
//				VM_TYPECHK(ctx, t, argv[i].o);
//			}
//		}
//	}
//	sfp[-1].op = (knh_stackop_t)pc;
	TODO();
}

/* ======================================================================== */
/* [movabletext] */

void knh_sfp_dump(Ctx *ctx, knh_sfp_t *sfp)
{
	fprintf(stderr, "\n** ** ** ** ** ** ** ** **\n");
	int i;
	if(sfp-1 > ctx->stack && IS_Method(sfp[-1].mtd)) {
		char buf[CLASSNAME_BUFSIZ];
		knh_format_cmethodn(buf, sizeof(buf), DP(sfp[-1].mtd)->cid, DP(sfp[-1].mtd)->mn);
		fprintf(stderr, "sfp[-1] %s op=%d\n", buf, (int)sfp[-1].op);
	}
	for(i = 0; sfp + i < ctx->ebp; i++) {
		fprintf(stderr, "sfp[%2d] %s op=%d\n", i, CLASSN(sfp[i].o->h.cid), (int)sfp[i].op);
	}
	for(i = 0; i < 2; i++) {
		fprintf(stderr, "ebp[%2d] %s op=%d\n", i, CLASSN(ctx->ebp[i].o->h.cid), (int)sfp[i].op);
	}
	fprintf(stderr, "** ** ** ** ** ** ** ** **\n");
}

/* ------------------------------------------------------------------------ */
/* ------------------------------------------------------------------------ */

KNHAPI(void) knh_sfp_sformat(Ctx *ctx, knh_sfp_t *sfp, Method *mtd, OutputStream *w, Any *m)
{
	KNH_ASSERT(IS_Method(mtd)); /*if(IS_NULL(mtd)) return ; */
	Object *o = (Object*)sfp[0].o;
	if(knh_Object_isCyclic(o) && knh_Object_isFormatted(o)) {
		knh_write_dots(ctx, w);
		return;
	}
	KNH_SWAP(ctx, sfp, 2, 0);  // it would be faster than move
	KNH_MOV(ctx, sfp[3].o, w);
	KNH_MOV(ctx, sfp[4].o, m);
	if(knh_Object_isCyclic(o)) {
		knh_Object_setFormatted(o, 1);
		KNH_SCALL(ctx, sfp, 1, mtd, /*args*/2);
		knh_Object_setFormatted(o, 0);
	}
	else {
		KNH_SCALL(ctx, sfp, 1, mtd, /*args*/2);
	}
	KNH_SWAP(ctx, sfp, 0, 2);  // for careful treatment
}

/* ------------------------------------------------------------------------ */

KNHAPI(void) knh_sfp_format(Ctx *ctx, knh_sfp_t *sfp, knh_methodn_t mn, OutputStream *w, Any *m)
{
	knh_sfp_sformat(ctx, sfp, knh_tMethod_findMT(ctx, knh_Object_cid(sfp[0].o), mn), w, m);
}

/* ------------------------------------------------------------------------ */

#ifdef __cplusplus
}
#endif
