/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER  
 * 
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation  
 * All rights reserved.
 * 
 * You may choose one of the following two licenses when you use konoha. 
 * See www.konohaware.org/license.html for further information.
 * 
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER 
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *  
 ****************************************************************************/

#ifndef KONOHA_MESSAGE__H
#define KONOHA_MESSAGE__H

#include<konoha/konoha_t.h>


#ifdef __cplusplus 
extern "C" {
#endif

/* ======================================================================== */
#define KONOHA_LANG                     "en"
#define KONOHA_LANG__en                 0
#define KONOHA_LANG__ja                 1
#define KONOHA_LANG__debug              2
#define KONOHA_LANG_MAXSIZ              3

/* ------------------------------------------------------------------------ */
#define KMSG_NAME                       0
#define KMSG_LANG                       1
#define KMSG_CLASS                      2
#define KMSG_CONST                      3
#define KMSG_OPERATOR                   4
#define KMSG_METHOD                     5
#define KMSG_FORMATTER                  6
#define KMSG_MAPPING                    7
#define KMSG_ERRATA                     8
#define KMSG_ETIME                      9
#define KMSG_TYPEINF                    10
#define KMSG_ERROR                      11
#define KMSG_WARNING                    12
#define KMSG_INFO                       13
#define KMSG_ESYNTAX                    14
#define KMSG_EFUTURE                    15
#define KMSG_EABORT                     16
#define KMSG_EFORGET_PARENTHESIS        17
#define KMSG_EMISMATCH                  18
#define KMSG_WUNCLOSED                  19
#define KMSG_WASCII                     20
#define KMSG_WEOF                       21
#define KMSG_WINDENT                    22
#define KMSG_WSEMICOLON                 23
#define KMSG_IGSTMT                     24
#define KMSG_ETOKEN                     25
#define KMSG_ELENGTH                    26
#define KMSG_WCLASSN                    27
#define KMSG_WCONSTN                    28
#define KMSG_WCMETHODN                  29
#define KMSG_WNAME                      30
#define KMSG_WIGNORED                   31
#define KMSG_TEXPTN                     32
#define KMSG_TNSNAME                    33
#define KMSG_TFURN                      34
#define KMSG_TCURN                      35
#define KMSG_TNSCLASSN                  36
#define KMSG_TTYPEN                     37
#define KMSG_TMETHODN                   38
#define KMSG_TCLASSTN                   39
#define KMSG_TSTR                       40
#define KMSG_TVARN                      41
#define KMSG_TCLASSN                    42
#define KMSG_TARGS                      43
#define KMSG_TNAME                      44
#define KMSG_TCMETHODN                  45
#define KMSG_TMT                        46
#define KMSG_TANY                       47
#define KMSG_TSTMT1                     48
#define KMSG_TPEXPR                     49
#define KMSG_TCATCHPARAM                50
#define KMSG_ELVALUE                    51
#define KMSG_WTYPEINF                   52
#define KMSG_NOTHERECONST               53
#define KMSG_NOTHERECLASSCONST          54
#define KMSG_NNCONST                    55
#define KMSG_DUPCONST                   56
#define KMSG_ENEXTPREV                  57
#define KMSG_EBUILTINFUNC               58
#define KMSG_EPSTMT3                    59
#define KMSG_EPEACH                     60
#define KMSG_WLET                       61
#define KMSG_WEMPTY                     62
#define KMSG_WTRUEFALSE                 63
#define KMSG_USCRIPT                    64
#define KMSG_UUOPTION                   65
#define KMSG_UURN                       66
#define KMSG_UPACKAGE                   67
#define KMSG_UCONSTN                    68
#define KMSG_UVARN                      69
#define KMSG_USYSTEMVARN                70
#define KMSG_UCLASSN                    71
#define KMSG_UTAG                       72
#define KMSG_UTYPEN                     73
#define KMSG_UMETHODN                   74
#define KMSG_UFUNCN                     75
#define KMSG_ULABEL                     76
#define KMSG_UOP                        77
#define KMSG_UOP1                       78
#define KMSG_UOP2                       79
#define KMSG_WOPCMP                     80
#define KMSG_UNEW                       81
#define KMSG_UMAP                       82
#define KMSG_INTOVERFLOW                83
#define KMSG_FLOATOVERFLOW              84
#define KMSG_ETOOFEWPARAMS              85
#define KMSG_WTOOMANYPARAMS             86
#define KMSG_ENULLPARAM                 87
#define KMSG_WNULLPARAM                 88
#define KMSG_ETYPEPARAM                 89
#define KMSG_ENULLRETURN                90
#define KMSG_WNULLRETURN                91
#define KMSG_ETYPERETURN                92
#define KMSG_ENULLLET                   93
#define KMSG_ENULL                      94
#define KMSG_WNULLLET                   95
#define KMSG_WNULL                      96
#define KMSG_ETYPELET                   97
#define KMSG_ETYPE                      98
#define KMSG_ETYPEBOOL                  99
#define KMSG_WDUPFUNCNAME               100
#define KMSG_USCLASSFUNC                101
#define KMSG_IGNNTYPE                   102
#define KMSG_EEXTENDS                   103
#define KMSG_EIMPLEMENTS                104
#define KMSG_DIFFDECL                   105
#define KMSG_ENESTEDTRY                 106
#define KMSG_DIFFENAME                  107
#define KMSG_DIFFCLASSN                 108
#define KMSG_DIFFNEWTYPE                109
#define KMSG_DIFFRTYPE                  110
#define KMSG_DIFFPSIZE                  111
#define KMSG_DIFFPTYPE                  112
#define KMSG_DIFFPNAME                  113
#define KMSG_TOOMANYVARS                114
#define KMSG_EOUTERLOOP                 115
#define KMSG_IGFIELDVALUE               116
#define KMSG_IGSCRIPTNAME               117
#define KMSG_IGFIELDNAME                118
#define KMSG_NORETURN                   119
#define KMSG_NORETURNVALUE              120
#define KMSG_IGRETURN                   121
#define KMSG_AHISTORIC                  122
#define KMSG_AOVERRIDE                  123
#define KMSG_EOVERRIDE                  124
#define KMSG_TOABSTRACT                 125
#define KMSG_MAXSIZ                     126

/* ------------------------------------------------------------------------ */

/* ======================================================================== */
int knh_system_langid(char *lang);
void knh_Asm_setLang(char *lang);
int knh_message_type(int e);
char *knh_message_text(int e);
char *knh_message_tochar(int e);

#ifdef __cplusplus
}
#endif

/* ======================================================================== */

#endif/*KONOHA_MESSAGE__H*/
