/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER
 *
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation
 * All rights reserved.
 *
 * You may choose one of the following two licenses when you use konoha.
 * See www.konohaware.org/license.html for further information.
 *
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

/* ************************************************************************ */

#include"commons.h"

/* ************************************************************************ */

#ifdef __cplusplus
extern "C" {
#endif

/* ======================================================================== */
/* [tConst] */

knh_bool_t knh_tConst_exists(Ctx *ctx, knh_bytes_t name)
{
	DictMap *tcmap = DP(knh_rootSystem)->tConstDictMap;
	return (knh_DictMap_index__b(tcmap, name) != -1);
}

/* ------------------------------------------------------------------------ */

Object *knh_tConst_value(Ctx *ctx, knh_bytes_t name)
{
	DictMap *tcmap = DP(knh_rootSystem)->tConstDictMap;
	return knh_DictMap_get__b(tcmap, name);
}

/* ------------------------------------------------------------------------ */

knh_bool_t
knh_tConst_addClassConst(Ctx *ctx, knh_class_t cid, knh_bytes_t name, Object *value)
{
	if(cid == CLASS_unknown) {
		return 0;
	}
	else {
		DictMap *tcmap = DP(knh_rootSystem)->tConstDictMap;
		char bufcn[CLASSNAME_BUFSIZ*2];
		size_t i;
		knh_snprintf(bufcn, sizeof(bufcn), "%s.%s", CLASSN(cid), (char*)name.buf);
		name = B(bufcn);
		if(knh_DictMap_index__b(tcmap, name) != -1) {
			return 0;
		}
		knh_DictMap_append(ctx, tcmap, new_String(ctx, name, NULL), value);

		knh_snprintf(bufcn, sizeof(bufcn), "%s_%s", knh_String_tochar(knh_tClass[cid].sname), (char*)name.buf);
		name = B(bufcn);
		for(i = 0; i < name.len; i++) {
			bufcn[i] = toupper(bufcn[i]);
		}
		if(knh_DictMap_index__b(tcmap, name) == -1) {
			knh_DictMap_append(ctx, tcmap, new_String(ctx, name, NULL), value);
		}
	}
	return 1;
}

/* ------------------------------------------------------------------------ */

void KNH_TCONST(Ctx *ctx, String *name, Object *value)
{
	DictMap *tcmap = DP(knh_rootSystem)->tConstDictMap;
	knh_DictMap_append(ctx, tcmap, name, (Object*)value);
}

/* ------------------------------------------------------------------------ */

void KNH_TCONST__T(Ctx *ctx, char *name, Object *value)
{
	DictMap *tcmap = DP(knh_rootSystem)->tConstDictMap;
	knh_DictMap_append(ctx, tcmap, new_String__T(ctx, name), (Object*)value);
}

/* ------------------------------------------------------------------------ */

knh_bool_t knh_tConst_addGlobalConst(Ctx *ctx, String *name, Object *value)
{
	DictMap *tcmap = DP(knh_rootSystem)->tConstDictMap;
	if(knh_DictMap_index__b(tcmap, knh_String_tobytes(name)) != -1) {
		return 0;
	}
	knh_DictMap_append(ctx, tcmap, name, value);
	return 1;
}

/* ------------------------------------------------------------------------ */

void knh_tConst__man(Ctx *ctx, knh_class_t cid, OutputStream *w)
{
	DictMap *tcmap = DP(knh_rootSystem)->tConstDictMap;
	KNH_ASSERT_cid(cid);
	knh_bytes_t n = knh_String_tobytes(knh_tClass[cid].lname);
	size_t i, size = knh_DictMap_size(tcmap);
	int hasCaption = 0;
	for(i = 0; i < size; i++) {
		knh_bytes_t cn = knh_String_tobytes(knh_DictMap_keyAt(tcmap, i));
		if(knh_bytes_startsWith(cn, n) && cn.buf[n.len] == '.') {
			if(!hasCaption) {
				knh_printf(ctx, w, "%s\n", knh_message_text(KMSG_CONST));
				hasCaption = 1;
			}
			knh_printf(ctx, w, "\t%B: %O\n", knh_bytes_last(cn, knh_bytes_index(cn, '.')+1), knh_DictMap_valueAt(tcmap, i));
		}
	}
}

/* ======================================================================== */

#define _KNH_SYS(ctx, n)    knh_tConst_systemValue(ctx, n)
#define _KNH_SYS_CTX    0
#define _KNH_SYS_STDIN  1
#define _KNH_SYS_STDOUT 2
#define _KNH_SYS_STDERR 3
#define _KNH_SYS_OS     4
#define _KNH_SYS_SCRIPT 5

Object *knh_tConst_systemValue(Ctx *ctx, int n)
{
	switch(n) {
		case _KNH_SYS_CTX:     return (Object*)ctx;
		case _KNH_SYS_STDIN:   return (Object*)((ctx)->in);
		case _KNH_SYS_STDOUT:  return (Object*)((ctx)->out);
		case _KNH_SYS_STDERR:  return (Object*)((ctx)->err);
		case _KNH_SYS_OS:      return (Object*)knh_tClass_defaultValueNN(ctx, CLASS_System);
		case _KNH_SYS_SCRIPT:  return (Object*)knh_NameSpace_getScript(ctx, (ctx)->ns);
	}
	DBG_P("unknown system const n=%d", n);
	return KNH_NULL;
}

/* ======================================================================== */


#ifdef __cplusplus
}
#endif
