/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER
 *
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation
 * All rights reserved.
 *
 * You may choose one of the following two licenses when you use konoha.
 * See www.konohaware.org/license.html for further information.
 *
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

/* ************************************************************************ */

#include"commons.h"

/* ************************************************************************ */

#ifdef __cplusplus
extern "C" {
#endif


/* ======================================================================== */
/* [macros] */

#define _knh_Float_value(o)    (o)->value

/* ======================================================================== */
/* [constructors] */

/* ------------------------------------------------------------------------ */

Float* new_FloatX(Ctx *ctx, knh_class_t cid, knh_float_t value)
{
	KNH_ASSERT_cid(cid);
	{
		FloatUnit *o = (FloatUnit*)knh_tClass[cid].cspec;
		KNH_ASSERT(IS_FloatUnit(o));
		if(DP(o)->fchk(o, value)) {
			Float *f = new_Float__fast(ctx, value);
			f->h.cid = cid;
			return f;
		}
		else {
			char buf[CLASSNAME_BUFSIZ];
			knh_snprintf(buf, sizeof(buf), "Format!!: %s(" KNH_FLOAT_FMT ")", CLASSN(cid), value);
			DBG2_P("%s", buf);
			return (Float*)new_Nue__s(ctx, buf);
		}
	}
}

/* ------------------------------------------------------------------------ */

Float* new_FloatX0(Ctx *ctx, knh_class_t cid, knh_float_t value)
{
	Float *b = (Float*)new_PObject0(ctx, FLAG_Float, CLASS_Float, cid);
	b->n.fvalue = value;
	return b;
}

/* ------------------------------------------------------------------------ */

Object *knh_Float_cspec(Ctx *ctx)
{
	KNH_TCONST__T(ctx, "konoha.Float.MAX", (Object*)new_FloatX0(ctx, CLASS_Float, KNH_FLOAT_MAX));
	KNH_TCONST__T(ctx, "konoha.Float.MIN", (Object*)new_FloatX0(ctx, CLASS_Float, KNH_FLOAT_MIN));
	return (Object*)new_FloatUnit(ctx, 0, CLASS_Float, TS_EMPTY, KNH_FLOAT_MIN, KNH_FLOAT_MAX, 0.0, 0.0);
}

/* ------------------------------------------------------------------------ */

Object *knh_Float_fdefault(Ctx *ctx, knh_class_t cid)
{
	FloatUnit *o = (FloatUnit*)knh_tClass[cid].cspec;
	KNH_ASSERT(IS_FloatUnit(o));
	return DP(o)->spec.defvalue;
}

/* ------------------------------------------------------------------------ */

int knh_Float_compareTo(Float *o, Float *o2)
{
	if(o->h.cid == CLASS_Float || o2->h.cid == CLASS_Float) {
		return (int)(o->n.fvalue - o2->n.fvalue);
	}
	else {
		FloatUnit *fu = (FloatUnit*)knh_tClass[o->h.cid].cspec;
		KNH_ASSERT(IS_FloatUnit(fu));
		return DP(fu)->fcmp(fu, o->n.fvalue, o2->n.fvalue);
	}
}

/* ------------------------------------------------------------------------ */

char *knh_format_Float(char *buf, size_t bufsiz, Float *o)
{
	FloatUnit *fu = (FloatUnit*)knh_tClass[o->h.cid].cspec;
	KNH_ASSERT(IS_FloatUnit(fu));
	DP(fu)->ffmt(fu, buf, bufsiz, o->n.fvalue);
	return buf;
}

/* ------------------------------------------------------------------------ */

#ifdef __cplusplus
}
#endif
