/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER
 *
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation
 * All rights reserved.
 *
 * You may choose one of the following two licenses when you use konoha.
 * See www.konohaware.org/license.html for further information.
 *
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

#ifndef KONOHAC_T_H_
#define KONOHAC_T_H_

#include"konoha_t.h"

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */

/* ======================================================================== */
/* KCODE */
/* ======================================================================== */

int knh_Method_pctoline(Method *mtd, knh_code_t *pc);
#define _HERE_    knh_Method_file(sfp[-1].mtd), knh_Method_pctoline(sfp[-1].mtd, pc)

/* ------------------------------------------------------------------------ */

#define KLR_MOV__wogc(ctx, v1, v2) {\
		Object *v2_ = (Object*)v2;\
		knh_Object_RCinc(v2_); \
		knh_Object_RCdec(v1); \
		v1 = v2_; \
	}\

#ifdef KNH_USING_DRCGC
#define KLR_MOV(ctx, v1, v2)  KLR_MOV__wogc(ctx, v1, v2)

#else/*KNH_USING_DRCGC*/

#define KLR_MOV(ctx, v1, v2) {\
		Object *v2_ = (Object*)v2;\
		knh_Object_RCinc(v2_); \
		knh_Object_RCdec(v1); \
		if(knh_Object_isRC0(v1)) { \
			knh_Object_free(ctx, v1); \
		} \
		v1 = v2_; \
	}\

#endif/*KNH_USING_DRCGC*/

#define KNH_MOV(ctx, v1, v2)  KLR_MOV(ctx, v1, v2)
#define KNH_NGCMOV(ctx, v1, v2)  KLR_MOV__wogc(ctx, v1, v2)

#define KLR_SWAP(ctx, a, b) {\
		knh_sfp_t temp = sfp[(a)];\
		sfp[(a)] = sfp[(b)];\
		sfp[(b)] = temp;\
	}\

#define KNH_SWAP(ctx, sfp, n, n2) {\
		knh_sfp_t temp = sfp[(n)];\
		sfp[(n)] = sfp[(n2)];\
		sfp[(n2)] = temp;\
	}\

/* ======================================================================== */

#define KLR_HALT(ctx) KNH_THROWs(ctx, "Halt!!")
#define KLR_RET(ctx)  return

/* ------------------------------------------------------------------------ */
#define SFX(x)   KNH_FIELDn(sfp[x.i].o, x.n)

#define KLR_MOVn(ctx, a, b) sfp[a].data = sfp[b].data

#define KLR_MOVa(ctx, a, b) { \
		KLR_MOV(ctx, sfp[a].o, sfp[b].o);\
		sfp[a].data = sfp[b].data;\
	}\

#define KLR_MOVo(ctx, a, v) {\
		KLR_MOV(ctx, sfp[a].o, v);\
		sfp[a].data = ((Int*)v)->n.data;\
	}\

#define KLR_MOVx(ctx, a, b) {\
		Int *v_ = (Int*)SFX(b);\
		KLR_MOV(ctx, sfp[a].o, v_);\
		sfp[a].data = (v_)->n.data;\
	}\

#define KLR_MOVDEF(ctx, a, cid) {\
		Int *v_ = (Int*)KNH_DEF(ctx, cid);\
		KLR_MOV(ctx, sfp[a].o, v_);\
		sfp[a].data = (v_)->n.data;\
	}

#define KLR_MOVSYS(ctx, a, cid)  KLR_MOV(ctx, sfp[a].o, KNH_SYS(ctx, cid))

/* ------------------------------------------------------------------------ */

#define KLR_XMOVs(ctx, a, b) KLR_MOV(ctx, SFX(a), sfp[b].o)
#define KLR_XMOVo(ctx, a, b) KLR_MOV(ctx, SFX(a), b)
#define KLR_XMOVx(ctx, a, b) KLR_MOV(ctx, SFX(a), SFX(b))
#define KLR_XMOVDEF(ctx, a, cid)  KLR_MOV(ctx, SFX(a), KNH_DEF(ctx, cid))
#define KLR_XMOVSYS(ctx, a, cid)  KLR_MOV(ctx, SFX(a), KNH_SYS(ctx, cid))

/* ------------------------------------------------------------------------ */

#define KLR_INITCODE(ctx, n) { \
		knh_code_thread(ctx, pc, OPJUMP); \
		((knh_codejmp_t*)pc)->opcode = OPCODE_SETEBP;\
		return; \
	}\

#define KLR_SETEBP(ctx, n) \
	((Context*)ctx)->ebp = &(sfp[n]);\
	if(unlikely((ctx)->stacksize - ((ctx)->ebp - (ctx)->stack) < KNH_LOCALSIZE)) {\
		KNH_THROWs(ctx, "StackOverflow!!"); \
	}\

#define KLR_CHECKEBP(ctx, n) \
	if(unlikely((ctx)->stacksize - (&sfp[n] - (ctx)->stack) < KNH_LOCALSIZE)) {\
		KNH_THROWs(ctx, "StackOverflow!!"); \
	}\

#define KLR_PINIo(ctx, a, v) {\
		if(IS_NULL(sfp[a].o)) {\
			KLR_MOV(ctx, sfp[a].o, v);\
			sfp[a].data = ((Int*)v)->n.data;\
		}\
	}\

#define KLR_RETn(ctx, dummy, b) {\
		KLR_MOVn(ctx, -1, b);\
		KLR_RET(ctx);\
	}\

#define KLR_RETa(ctx, dummy, b) {\
		KLR_MOV__wogc(ctx, sfp[-1].o, sfp[b].o);\
		sfp[-1].data = sfp[b].data;\
		KLR_RET(ctx);\
	}\

#define KLR_RETo(ctx, dummy, v) {\
		KLR_MOV__wogc(ctx, sfp[-1].o, v);\
		sfp[-1].data = ((Int*)v)->n.data;\
		KLR_RET(ctx);\
	}\

#define KLR_RETx(ctx, dummy, b) {\
		Int *v_ = (Int*)SFX(b);\
		KLR_MOV__wogc(ctx, sfp[-1].o, v_);\
		sfp[-1].data = (v_)->n.data;\
		KLR_RET(ctx);\
	}\

/* ------------------------------------------------------------------------ */
/* ------------------------------------------------------------------------ */

#define KLR_BOX(ctx, n, cid) {\
		KLR_MOV(ctx, sfp[n].o, knh_boxing(ctx, &sfp[n], cid));\
	}\

#define KLR_BOXnc(ctx, cid, n) \
	if(IS_NOTNULL(sfp[n].o)){ \
		KLR_MOV(ctx, sfp[n].o, knh_boxing(ctx, &sfp[n], cid));\
	}\

#define KLR_NNBOX(ctx, n, cid) {\
		KLR_MOV(ctx, sfp[n].o, KNH_DEF(ctx, cid));\
	}\

#define KLR_NNBOXnc(ctx, cid, n) \
	if(knh_Object_cid(sfp[n].o) != cid){ \
		KLR_MOV(ctx, sfp[n].o, KNH_DEF(ctx, cid));\
	}\

#define KLR_UNBOX(ctx, a) {\
		sfp[a].data = (sfp[a].i)->n.data;\
	}\

/* ======================================================================== */

#define KLR_ISNULL(ctx, n) \
	if(unlikely(IS_NULL(sfp[n].o))) { \
		knh_throwException(ctx, new_Exception__Nue(ctx, sfp[n].o), _HERE_); \
	} \

#define KLR_ISNULLx(ctx, n) \
	if(unlikely(IS_NULL(SFX(n)))) { \
		knh_throwException(ctx, new_Exception__Nue(ctx, SFX(n)), _HERE_); \
	} \

#define KLR_ISTYPE(ctx, n, cid) \
	if(unlikely(!knh_Object_opTypeOf(ctx, sfp[n].o, cid))) { \
		knh_throwException(ctx, new_Exception__type(ctx, sfp[n].o, cid), _HERE_); \
	} \

#define KLR_ISNNTYPE(ctx, n, cid) {\
		KLR_ISTYPE(ctx, n, cid);\
		KLR_ISNULL(ctx, n);\
	}\

/* ======================================================================== */

#define KLR_SCALL(ctx, n, shift, m) { \
		KLR_MOV(ctx, sfp[n].o, m); \
		sfp[n].pc = pc; \
		((Context*)ctx)->ebp = &(sfp[n + shift]); \
		(sfp[n].mtd)->fcall_1(ctx, sfp + n + 1); \
		((Context*)ctx)->ebp = &(sfp[n]); \
	} \

#define KLR_FCALL(ctx, n, shift, self, m) { \
		int n1_ = n + 1;\
		KLR_MOVa(ctx, n1_, self); \
		KLR_MOV(ctx, sfp[n].o, m); \
		sfp[n].pc = pc; \
		((Context*)ctx)->ebp = &(sfp[n + shift]); \
		(sfp[n].mtd)->fcall_1(ctx, sfp + n1_); \
		((Context*)ctx)->ebp = &(sfp[n]); \
	} \


#define KLR_CALL(ctx, n, shift, mn) { \
		KLR_MOV(ctx, sfp[n].o, knh_Method_ufind(ctx, knh_Object_cid(sfp[n+1].o), mn)); \
		sfp[n].pc = pc; \
		((Context*)ctx)->ebp = &(sfp[n + shift]); \
		(sfp[n].mtd)->fcall_1(ctx, sfp + n + 1); \
		((Context*)ctx)->ebp = &(sfp[n]); \
	} \

#define KLR_ACALL(ctx, n, shift, mn, reqt) { \
		Method *mtd_ = knh_Method_ufind(ctx, knh_Object_cid(sfp[n+1].o), mn);\
		KLR_MOV(ctx, sfp[n].o, mtd_); \
		knh_dynamiccall(ctx, sfp + n); \
		sfp[n].pc = pc; \
		((Context*)ctx)->ebp = &(sfp[n + shift]); \
		(sfp[n].mtd)->fcall_1(ctx, sfp + n + 1); \
		((Context*)ctx)->ebp = &(sfp[n]); \
		TODO();\
	} \

#define KLR_NEW(ctx, n, flag, cid, shift, m) { \
		KLR_MOV(ctx, sfp[n].o, m); \
		KLR_MOV(ctx, sfp[n+1].o, new_Object__init(ctx, flag, cid)); \
		sfp[n].pc = pc; \
		((Context*)ctx)->ebp = &(sfp[n + shift]); \
		(sfp[n].mtd)->fcall_1(ctx, sfp + n + 1); \
		((Context*)ctx)->ebp = &(sfp[n]); \
	} \

/* ------------------------------------------------------------------------- */

#define KLR_TOSTRf(ctx, n, mn, fmt) { \
		KLR_SWAP(ctx, n, n+1); \
		knh_wbuf_t cwb = knh_Context_wbuf(ctx);\
		KLR_MOV(ctx, sfp[n+2].o, cwb.w);\
		KLR_MOV(ctx, sfp[n+3].o, fmt);\
		Method *mtd_ = knh_tMethod_findMT(ctx, knh_Object_cid(sfp[n+1].o), mn);\
		KLR_SCALL(ctx, n, 4, mtd_);\
		KLR_MOV(ctx, sfp[n].o, new_String__wbuf(ctx, cwb)); \
	}\

#define KLR_TOSTR(ctx, n, mn)  KLR_TOSTRf(ctx, n, mn, KNH_NULL)

/* ------------------------------------------------------------------------- */

#define KLR_SMAP(ctx, n, m)  { \
		KLR_MOV(ctx, sfp[n+1].o, m);\
		KNH_ASSERT(IS_Mapper(m)); \
		(sfp[n+1].mpr)->fmap_1(ctx, sfp + n); \
	} \

#define KLR_SMAPnc(ctx, n, m)  { \
		if(likely(IS_NOTNULL(sfp[n].o))) {\
			KLR_MOV(ctx, sfp[n+1].o, m);\
			KNH_ASSERT(IS_Mapper(m)); \
			(sfp[n+1].mpr)->fmap_1(ctx, sfp + n); \
		}\
	} \

#define KLR_MAP(ctx, n, tcid)  { \
		KLR_MOV(ctx, sfp[n+1].o, knh_tMapper_find(ctx, knh_Object_cid(sfp[n].o), tcid)); \
		(sfp[n+1].mpr)->fmap_1(ctx, sfp + n); \
	} \

#define KLR_MAPnc(ctx, n, tcid)  { \
		if(likely(IS_NOTNULL(sfp[n].o))) {\
			KLR_MOV(ctx, sfp[n+1].o, knh_tMapper_find(ctx, knh_Object_cid(sfp[n].o), tcid)); \
			(sfp[n+1].mpr)->fmap_1(ctx, sfp + n); \
		}\
	}\

#define KLR_AMAP(ctx, n, tcid)  { \
		knh_class_t scid = knh_Object_cid(sfp[n].o);\
		if(scid != tcid && !knh_class_instanceof(scid, tcid) && scid != CLASS_Nue) { \
			KLR_MOV(ctx, sfp[n+1].o, knh_tMapper_find(ctx, scid, tcid)); \
			(sfp[n+1].mpr)->fmap_1(ctx, sfp + n); \
		} \
	} \

#define KLR_NNMAP(ctx, a, tcid)  { \
		if(unlikely(IS_NULL(sfp[a].o))) {\
			Int *v_ = (Int*)KNH_DEF(ctx, tcid);\
			KLR_MOV(ctx, sfp[a].o, v_);\
			sfp[a].data = (v_)->n.data;\
		} \
	}\

/* ======================================================================== */

#define KLR_JMP(ctx, PC, JUMP) {\
		PC; \
		goto JUMP; \
	}\

#define KLR_SKIP(ctx, PC, JUMP) \
	if(!IS_DEBUG(ctx, sfp[0].o)) { \
		KLR_JMP(ctx, PC, JUMP); \
	} \

#define KLR_bJIFT(ctx, PC, JUMP, n) \
	if(sfp[n].bvalue) { \
		KLR_JMP(ctx, PC, JUMP); \
	} \

#define KLR_bJIFF(ctx, PC, JUMP, n) \
	if(!sfp[n].bvalue) { \
		KLR_JMP(ctx, PC, JUMP); \
	} \

#define KLR_bJIFF_LOOP(ctx, PC, JUMP, n) \
	if(unlikely(!sfp[n].bvalue)) { \
		KLR_JMP(ctx, PC, JUMP); \
	} \

#define KLR_JIFNUL(ctx, PC, JUMP, n) \
	if(IS_NULL(sfp[n].o)) { \
		KLR_JMP(ctx, PC, JUMP); \
	} \

#define KLR_JIFNN(ctx, PC, JUMP, n) \
	if(IS_NOTNULL(sfp[n].o)) { \
		KLR_JMP(ctx, PC, JUMP); \
	} \

/* ------------------------------------------------------------------------- */

#define KLR_NEXT(ctx, PC, JUMP, v, it) { \
		knh_Iterator_t *it_ = (knh_Iterator_t*)it; \
		KNH_ASSERT(IS_bIterator(it)); \
		KNH_SETv(ctx, v, (it_)->fnext_1(ctx, it_)); \
		if(IS_NULL(v)) { \
			KLR_JMP(ctx, PC, JUMP); \
		} \
	} \

#define KLR_SMAPNEXT(ctx, PC, JUMP, v, it, mpr)  { \
		knh_Mapper_t *mpr_ = (knh_Mapper_t*)mpr; \
		KLR_DEBUG_ASSERT(IS_Mapper(mpr)); \
		knh_Iterator_t *it_ = (knh_Iterator_t*)it; \
		KNH_ASSERT(IS_bIterator(it_)); \
		do { \
			KNH_SETv(ctx, ebp_(0), (it_)->fnext_1(ctx, it_)); \
			if(IS_NULL(ebp_(0))) { \
				KLR_JMP(ctx, PC, JUMP); \
			} \
			KNH_SETv(ctx, v, (mpr_)->fmap_1(ctx, ebp_(0), mpr_)); \
		}while(IS_NULL(v)); \
	} \

#define KLR_MAPNEXT(ctx, PC, JUMP, v, it, tcid)  { \
		knh_Iterator_t *it_ = (knh_Iterator_t*)it; \
		KNH_ASSERT(IS_bIterator(it_)); \
		do { \
			KNH_SETv(ctx, ebp_(0), (it_)->fnext_1(ctx, it_)); \
			if(IS_NULL(ebp_(0))) { \
				KLR_JMP(ctx, PC, JUMP); \
			} \
			knh_Mapper_t *mpr_ = knh_tMapper_find(ctx, knh_Object_cid(ebp_(0)), tcid); \
			KNH_SETv(ctx, v, (mpr_)->fmap_1(ctx, ebp_(0), mpr_)); \
		}while(IS_NULL(v)); \
	} \

/* ------------------------------------------------------------------------ */
/* ------------------------------------------------------------------------- */

#define KLR_TRY(ctx, PC, JUMP, hn)  {\
		ExceptionHandler* _hdr = (ExceptionHandler*)sfp[hn].o; \
		if(!IS_ExceptionHandler(_hdr)) { \
			_hdr = new_ExceptionHandler(ctx); \
			KLR_MOV(ctx, sfp[hn].o, _hdr); \
		} \
		if(!knh_ExceptionHandler_isJumpable(_hdr)) { \
			knh_ExceptionHandler_setJumpable(_hdr, 1); \
			int jump = KNH_SETJUMP(_hdr); \
			if(jump != 0) { \
				pc = DP(_hdr)->pc; \
				KLR_JMP(ctx, PC, JUMP); \
			} \
			DP(_hdr)->pc = pc; \
		} \
		knh_ExceptionHandler_setCatching(_hdr, 1); \
	} \

#define KLR_TRYEND(ctx, hn)  {\
		KNH_ASSERT(IS_ExceptionHandler(sfp[hn].o)); \
		knh_ExceptionHandler_setCatching(sfp[hn].hdr, 0); \
	} \

#define KLR_CATCH(ctx, PC, JUMP, hn, en, emsg) { \
		Exception* _e = DP(sfp[hn].hdr)->caught; \
		KNH_ASSERT(IS_Exception(_e)); \
		KNH_ASSERT(IS_String(emsg)); \
		if(!knh_Exception_isa(ctx, _e, (String*)emsg)) { \
			KLR_JMP(ctx, PC, JUMP); \
		} \
		else { \
			KLR_MOV(ctx, sfp[en].o, _e); \
		} \
	} \

#define KLR_THROW(ctx, n) \
	if(IS_bString((sfp[n].o))) { \
		knh_throwException(ctx, new_Exception(ctx, sfp[n].s), _HERE_); \
	}else { \
		KNH_ASSERT(IS_Exception(sfp[n].e)); \
		knh_throwException(ctx, sfp[n].e, _HERE_); \
	}\

#define KLR_THROWs(ctx, v) \
	if(IS_bString(v)) { \
		knh_throwException(ctx, new_Exception(ctx, (String*)v), _HERE_); \
	}else { \
		KNH_ASSERT(IS_Exception(v)); \
		knh_throwException(ctx, (Exception*)v, _HERE_); \
	}\

#define KLR_THROW_AGAIN(ctx, hn) { \
		KNH_ASSERT(IS_ExceptionHandler(sfp[hn].o)); \
		Exception *_e = DP(sfp[hn].hdr)->caught; \
		DBG2_P("THROW AGAIN .. %s", knh_String_tochar(DP(_e)->message)); \
		knh_throwException(ctx, _e, NULL, 0); \
	} \

/* ------------------------------------------------------------------------ */

#define KLR_P(ctx, flag, mn, n) \
	knh_stack_p(ctx, sfp, flag, mn, n)

#define KLR_PMSG(ctx, flag, v) \
	knh_stack_pmsg(ctx, sfp, flag, (String*)v)


/* ------------------------------------------------------------------------ */

#define SFb(x)   sfp[x].bvalue
#define SFi(x)   sfp[x].ivalue
#define SFf(x)   sfp[x].fvalue

#define KLR_iADD(ctx, c, a, b)  SFi(c) = (SFi(a) + SFi(b))
#define KLR_iADDn(ctx, c, a, n) SFi(c) = (SFi(a) + n)
#define KLR_iSUB(ctx, c, a, b)  SFi(c) = (SFi(a) - SFi(b))
#define KLR_iSUBn(ctx, c, a, n) SFi(c) = (SFi(a) - n)
#define KLR_iMUL(ctx, c, a, b)  SFi(c) = (SFi(a) * SFi(b))
#define KLR_iMULn(ctx, c, a, n) SFi(c) = (SFi(a) * n)
#define KLR_iDIV(ctx, c, a, b)  SFi(c) = (SFi(a) / SFi(b))
#define KLR_iDIVn(ctx, c, a, n)  SFi(c) = (SFi(a) / n)
#define KLR_iMOD(ctx, c, a, b)  SFi(c) = (SFi(a) % SFi(b))
#define KLR_iMODn(ctx, c, a, n)  SFi(c) = (SFi(a) % n)

#define KLR_iEQ(ctx, c, a, b)  SFi(c) = (SFi(a) == SFi(b))
#define KLR_iEQn(ctx, c, a, n)  SFi(c) = (SFi(a) == n)
#define KLR_iNEQ(ctx, c, a, b)  SFi(c) = (SFi(a) != SFi(b))
#define KLR_iNEQn(ctx, c, a, n)  SFi(c) = (SFi(a) != n)

#define KLR_iLT(ctx, c, a, b)  SFb(c) = (SFi(a) < SFi(b))
#define KLR_iLTn(ctx, c, a, n)  SFb(c) = (SFi(a) < n)
#define KLR_iLTE(ctx, c, a, b)  SFb(c) = (SFi(a) <= SFi(b))
#define KLR_iLTEn(ctx, c, a, n)  SFb(c) = (SFi(a) <= n)
#define KLR_iGT(ctx, c, a, b)  SFb(c) = (SFi(a) > SFi(b))
#define KLR_iGTn(ctx, c, a, n)  SFb(c) = (SFi(a) > n)
#define KLR_iGTE(ctx, c, a, b)  SFb(c) = (SFi(a) >= SFi(b))
#define KLR_iGTEn(ctx, c, a, n)  SFb(c) = (SFi(a) >= n)

/* ------------------------------------------------------------------------ */

#define KLR_NOP(ctx)

/* ------------------------------------------------------------------------ */
/* ------------------------------------------------------------------------ */


#define KNH_LOCAL(ctx)  ((Context*)ctx)->ebp
#define KNH_LOCALBACK(ctx, lsfp)  ((Context*)ctx)->ebp = lsfp

#define KNH_LPUSH(ctx, v)  {\
		KLR_MOV(ctx, ((Context*)ctx)->ebp[0].o, v); \
		((Context*)ctx)->ebp += 1;\
	}

#define KNH_SCALL(ctx, lsfp, n, mtd, args) { \
		KLR_MOV(ctx, lsfp[n].o, mtd); \
		((Context*)ctx)->ebp = &(lsfp[n+args+2]); \
		(lsfp[n].mtd)->fcall_1(ctx, lsfp + (n + 1)); \
		((Context*)ctx)->ebp = &(lsfp[n]); \
	} \

#define KNH_SMAP(ctx, lsfp, n, m)  { \
		KLR_MOV(ctx, lsfp[n+1].o, m);\
		KNH_ASSERT(IS_Mapper(m)); \
		(lsfp[n+1].mpr)->fmap_1(ctx, lsfp + n); \
	} \

#define NPC  /* for KNH_TRY */

#define KNH_TRY(ctx, JUMP, lsfp, hn)  {\
		ExceptionHandler* _hdr = lsfp[hn].hdr; \
		if(!knh_ExceptionHandler_isJumpable(_hdr)) { \
			knh_ExceptionHandler_setJumpable(_hdr, 1); \
			int jump = KNH_SETJUMP(_hdr); \
			if(jump != 0) { \
				((Context*)ctx)->ebp = &(lsfp[hn]); \
				KLR_JMP(ctx, NPC, JUMP); \
			} \
		} \
		knh_ExceptionHandler_setCatching(_hdr, 1); \
	} \

#define KNH_PRINT_STACKTRACE(ctx, lsfp, hn) {\
		KNH_ASSERT(IS_ExceptionHandler(lsfp[hn].hdr));\
		knh_format(ctx, KNH_STDERR, METHODN__dump, UP(DP(lsfp[hn].hdr)->caught), KNH_NULL);\
		KNH_LOCALBACK(ctx, lsfp);\
	}\

/* ------------------------------------------------------------------------ */


#define KNH_SECURE(ctx) \
	if(((ctx)->flag & KNH_FLAG_CTXF_ADMIN) != KNH_FLAG_CTXF_ADMIN) { \
		knh_throwException(ctx, new_Exception(ctx, TS_SecurityException), KNH_SAFEFILE(__FILE__), __LINE__); \
	} \

/* ------------------------------------------------------------------------ */


#ifdef __cplusplus
}
#endif

#endif /*KONOHA_T_H_*/
