/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER
 *
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation
 * All rights reserved.
 *
 * You may choose one of the following two licenses when you use konoha.
 * See www.konohaware.org/license.html for further information.
 *
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

/* ************************************************************************ */

#include<konoha.h>

#define KNH_PKGNAME "unix"

#ifdef KNH_USING_POSIX
#include <unistd.h>
#include <signal.h>
#include <dirent.h>
#endif


#ifdef __cplusplus
extern "C" {
#endif

#ifdef KNH_USING_POSIX

/* ======================================================================== */
/* [method] */

/* ------------------------------------------------------------------------ */
/* @method[CONST] Int! System.getpid() */

static
METHOD knh__System_getpid(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_RETURN_Int(ctx, sfp, getpid());
}

/* ------------------------------------------------------------------------ */
/* @method[CONST] Int! System.getppid() */

static
METHOD knh__System_getppid(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_RETURN_Int(ctx, sfp, getppid());
}

/* ------------------------------------------------------------------------ */
/* @method[CONST] void System.kill(Int! pid, Int! sig) */

static
METHOD knh__System_kill(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_SECURE(ctx);
	KNH_BESTRICT(ctx, kill(ARG_int(sfp[1]), ARG_int(sfp[2])), != -1);
	KNH_RETURN_void(ctx, sfp);
}

/* ------------------------------------------------------------------------ */
/* @method[CONST] void System.system(String! cmd) */

static
METHOD knh__System_system(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_SECURE(ctx);
	KNH_BESTRICT(ctx, system(ARG_char(sfp[1])), != -1);
	KNH_RETURN_void(ctx, sfp);
}

/* ------------------------------------------------------------------------ */
/* @method[CONST] String[] System.listdir(String dirname) */

static
METHOD knh__System_listdir(Ctx *ctx, knh_sfp_t *sfp)
{
	DIR *dirptr;
	struct dirent *direntp;
//	struct stat fstat;
	char *dirname = IS_NULL(sfp[1].s) ? "." : knh_String_tochar(sfp[1].s);
	Array *a = new_Array(ctx, CLASS_String, 0);
	
	if ((dirptr = opendir(dirname)) == NULL) {
			fprintf(stderr, "cannot opne %s \n", dirname);
	} else {
		while ((direntp = readdir(dirptr)) != NULL) {
			char *p = direntp->d_name;
			//stat(direntp->d_name, &fstat);
//			printf("%s %d %d %d\n", direntp->d_name, fstat.st_uid, fstat.st_gid, fstat.st_size);
			if(p[0] == '.' && (p[1] == 0 || p[1] == '.')) continue;
			knh_Array_add(ctx, a, new_String(ctx, B(p), NULL));
		}
		closedir(dirptr);
	}
	KNH_RETURN(ctx, sfp, a);
}
/* ------------------------------------------------------------------------ */
/* @method[CONST] String! System.getcwd() */

static
METHOD knh__System_getcwd(Ctx *ctx, knh_sfp_t *sfp)
{
	// TODO: when filename is longer than 1024
	// to escape this, if we use getcwd(NULL, 0), system malloc buf for filename.
	char *res = NULL;
	knh_uint_t bufsize = 1024;
	char tmpbuf[bufsize];
	res = getcwd(tmpbuf, bufsize);
	if (res == NULL) {
		// error has occured!
	}
	String *s = new_String(ctx, B(tmpbuf), NULL);
	KNH_RETURN(ctx, sfp, s);
}

/* ------------------------------------------------------------------------ */
/* @method[CONST] Int! System.chdir(String dirname) */
/*
static
METHOD knh__System_chdir(Ctx *ctx, knh_sfp_t *sfp)
{
	char* dirname = IS_NULL(sfp[1].s) ? "." : knh_String_tochar(sfp[1].s);
	int i = chdir(dirname);
	KNH_RETURN_Int(ctx, sfp,i);
}
*/
/* ======================================================================== */



#endif/*KNH_USING_POSIX*/

/* ======================================================================== */
/* [KNHAPI] */

int knhunix_init(Ctx *ctx)
{
#ifdef KNH_USING_POSIX
	KNH_NOTICE(ctx, "loading unix..");
	konoha_addMethod(ctx, "@Const Int! System.getpid()", knh__System_getpid);
	konoha_addMethod(ctx, "@Const Int! System.getppid()", knh__System_getppid);
	konoha_addMethod(ctx, "@Const void System.kill(Int! pid, Int! sig)", knh__System_kill);
	konoha_addIntConst(ctx, "SIG_KILL", SIGKILL);

	konoha_addMethod(ctx, "@Const void System.shell(String! cmd)", knh__System_system);
	konoha_addMethod(ctx, "@Const void System.system(String! cmd)", knh__System_system);
	konoha_addMethod(ctx, "@Const String[] System.listdir(String dirname)", knh__System_listdir);
	konoha_addMethod(ctx, "@Const String! System.getcwd()", knh__System_getcwd);
//	konoha_addMethod(ctx, "@Const Int! System.chdir(String dirname)", knh__System_chdir);
#else
	KNH_WARNING(ctx, "unsupported unix package..");
#endif
	return 1;
}

/* ------------------------------------------------------------------------ */

void knhunix_traverse(Ctx *ctx, knh_ftraverse ftr)
{
	if(konoha_issweep(ftr)) {

	}
}

/* ------------------------------------------------------------------------ */

static knh_pkgmeta_t PKGDATA = {
	KONOHA_BUILDID, /* Don't change this */
	KNH_PKGNAME,    /* package name (not NULL) */
	"1.0",  /* package version (not NULL) */
	NULL,   /* additional information */
	KONOHA_URLBASE "package.unix", /* URL */
	knhunix_init,
	knhunix_traverse,
	NULL
};

KNHAPI(knh_pkgmeta_t*) knhunix_load(Ctx *ctx)
{
	return &(PKGDATA);
}

/* ------------------------------------------------------------------------ */

#ifdef __cplusplus
}
#endif
