/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER
 *
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation
 * All rights reserved.
 *
 * You may choose one of the following two licenses when you use konoha.
 * See www.konohaware.org/license.html for further information.
 *
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

/* ************************************************************************ */

#include"commons.h"

/* ************************************************************************ */

#ifdef __cplusplus
extern "C" {
#endif

/* ======================================================================== */
/* [macros] */

#define _KNH_THROW(ctx, e) knh_throw(ctx, UP(e), KNH_SAFEFILE(__FILE__), __LINE__)

#define _KNH_THROWs(ctx, s) \
	knh_throwException(ctx, new_Exception__b(ctx, B(s)), KNH_SAFEFILE(__FILE__), __LINE__); \

#define _KNH_THROWf(ctx, fmt, ...) \
	char throwbuf_[256]; \
	knh_snprintf(throwbuf_, sizeof(throwbuf_), fmt, ## __VA_ARGS__); \
	knh_throwException(ctx, new_Exception__b(ctx, B(throwbuf_)), KNH_SAFEFILE(__FILE__), __LINE__); \

#define DEBUG_THROWf(ctx, fmt, ...) \
	fprintf(stderr, "THROW?[%s:%d]: ", __FUNCTION__, __LINE__); \
	fprintf(stderr, fmt, ## __VA_ARGS__); \
	fprintf(stderr, "\n"); \

#define _TODO_THROW(ctx) knh_throw_TODO(ctx, (char*)__FILE__, __LINE__, (char*)__FUNCTION__)

/* ======================================================================== */
/* [throw] */

KNHAPI(void) knh_throw_TODO(Ctx *ctx, char *file, int line, char *func)
{
	fprintf(stderr, "**************************************************************************\n");
	fprintf(stderr, "         THIS FUNCTION IS FULLY (OR PARTIALLY) NOT IMPLEMENTED.\n\n");
	fprintf(stderr, "   function: %s\n", func);
	fprintf(stderr, "   file='%s', line=%d\n\n", file, line);
	fprintf(stderr, "We will appliciate if you help us implementing this function. Thank you\n");
	fprintf(stderr, "for your cooperation.\n");
	fprintf(stderr, "**************************************************************************\n");
	knh_throwException(ctx, new_Exception__b(ctx, STEXT("UnsupportedOperation!!")), KNH_SAFEFILE(file), line);
}

/* ======================================================================== */
/* [throw] */

static
void knh_Exception_addStackTrace(Ctx *ctx, Exception *o, String *msg)
{
	KNH_ASSERT(IS_Exception(o));
	if(IS_NOTNULL(msg)) {
		if(IS_NULL(DP(o)->traces)) {
			KNH_SETv(ctx, DP(o)->traces, new_Array(ctx, CLASS_String, 16));
		}
		knh_Array_add(ctx, DP(o)->traces, UP(msg));
	}
}

/* ------------------------------------------------------------------------ */

static
String *knh_stackf_getStackTraceMsg(Ctx *ctx, knh_sfp_t *sfp)
{
	char *fn = "-";
	int  line = 0;
	if(sfp[-1].op != 0) {
		knh_sfp_t *prev_sfp = sfp;
		while(ctx->stack <= prev_sfp) {
			if(IS_Method(prev_sfp[0].o) && prev_sfp[0].op != 0) {
				fn = knh_Method_file(prev_sfp[0].mtd);
				line = knh_Method_pctoline(prev_sfp[0].mtd, (knhvmc_t*)sfp[-1].op);
				break;
			}
			prev_sfp--;
		}
	}
	char bufm[CLASSNAME_BUFSIZ];
	char bufn[CLASSNAME_BUFSIZ*2];
	knh_snprintf(bufn, sizeof(bufn), "%s.%s:(%s:%d)",
		CLASSN(knh_Object_cid(sfp[0].o)), knh_format_methodn(bufm, sizeof(bufm), DP(sfp[-1].mtd)->mn), fn, line);
	return new_String(ctx, B(bufn), NULL);
}

/* ------------------------------------------------------------------------ */
/* @method void Context.%s(OutputStream w, String m) */

void knh_Context__s(Ctx *ctx, Context *o, OutputStream *w, String *m)
{
	char *fn = NULL;
	int  line = 0;
	knh_sfp_t *mtd_sfp = NULL, *prev_sfp = o->ebp;
	while(o->stack <= prev_sfp) {
		if(IS_Method(prev_sfp[0].o) && prev_sfp[0].op != 0) {
			if(mtd_sfp != NULL) {
				fn = knh_Method_file(prev_sfp[0].mtd);
				line = knh_Method_pctoline(prev_sfp[0].mtd, (knhvmc_t*)mtd_sfp[-1].op);
				break;
			}
			mtd_sfp = prev_sfp;
		}
		prev_sfp--;
	}
	knh_putc(ctx, w, '[');
	if(o->doing == NULL) {
		knh_write__s(ctx, w, KONOHA_NAME);
	}
	else {
		knh_write__s(ctx, w, o->doing);
	}
	knh_putc(ctx, w, ']');
	if(fn != NULL) {
		knh_putc(ctx, w, '(');
		knh_write__s(ctx, w, KNH_SAFEFILE(fn));
		knh_putc(ctx, w, ':');
		knh_write__i(ctx, w, (knh_int_t)line);
		knh_putc(ctx, w, ')');
	}
}

/* ------------------------------------------------------------------------ */

KNHAPI(char*) konoha_doing(Ctx *ctx, char *msg)
{
	char *oldmsg = ctx->doing;
	((Context*)ctx)->doing = msg;
	return oldmsg;
}

/* ------------------------------------------------------------------------ */

KNHAPI(void) knh_throwException(Ctx *ctx, Exception *e, char *file, int line)
{
	Context *o = (Context*)ctx;
	KNH_ASSERT(IS_Exception(e));
	if(file != NULL) {
		DP(e)->file = file;
		DP(e)->line = line;
	}
	if(ctx == NULL) {
		goto L_ERROR;
	}
	((Context*)ctx)->doing = NULL; /* reset */
	while(o->stack <= o->ebp) {
		DBG2_P("stack[%d]\t %s\n", (o->ebp - o->stack), CLASSNo(o->ebp[0].o));
		if(IS_ExceptionHandler(o->ebp[0].hdr) && knh_ExceptionHandler_isCatching(o->ebp[0].hdr)) {
			knh_ExceptionHandler_setCatching(o->ebp[0].hdr, 0);
			knh_ExceptionHandler_longjmp(ctx, o->ebp[0].hdr, e);
		}
		else if(IS_Method(o->ebp[0].o)) {
			DBG2_P("pc = %p", (void*)o->ebp[0].op);
			if(o->ebp[0].op != 0) {
				knh_Exception_addStackTrace(ctx, e, knh_stackf_getStackTraceMsg(ctx, o->ebp+1));
			}
		}
		o->ebp--;
	}

	L_ERROR:;
	fprintf(stderr, "********** USE STACKTRACE IN YOUR C/C++ DEBUGGER ************\n");
	fprintf(stderr, "Uncaught Exception: %s\n", knh_String_tochar(DP(e)->message));
	fprintf(stderr, "*************************************************************\n");
	abort();
}

/* ------------------------------------------------------------------------ */

KNHAPI(void) knh_throw(Ctx *ctx, Object *e, char *file, int line)
{
	if(IS_NULL(e)) {
		knh_throwException(ctx, new_Exception__Nue(ctx, (Nue*)e), file, line);
	}else if(IS_Exception(e)) {
		knh_throwException(ctx, (Exception*)e, file, line);
	}else if(IS_bString(e)) {
		knh_throwException(ctx, new_Exception(ctx, (String*)e), file, line);
	}else {
		DBG2_P("Cannot throw %s", CLASSN(knh_Object_cid(e)));
		knh_throwException(ctx, new_Exception__b(ctx, STEXT("Type!!")), file, line);
	}
}


/* ------------------------------------------------------------------------ */

#ifdef __cplusplus
}
#endif
