#!/usr/bin/python
import os, os.path, sys

#########################################################

LDLIBS_MAP = {
	'macosx' : '-lm -lreadline -liconv',
	'unix' : '-lm -lreadline -liconv',
	'mingw' : 'lib/iconv.a -lm',
	'cygwin': '-lm -lreadline -liconv',
}


HASMAKERULES = ''

def osldlibs(data, OS):
	LDLIBS = '-m'
	if LDLIBS_MAP.has_key(OS):
		LDLIBS = LDLIBS_MAP[OS]
	return LDLIBS

#########################################################

def filebase(cpath):
	return cpath.split('/')[-1].replace('.c', '')

def write_makeobjs(f, data, c_options = ''):
	fbl = []
	for fn in data.CFILES:
		fb = filebase(fn)
		if fb == 'konoha': continue
		fbl.append(fb)
	
	f.write('''
objs = ''')
	for fb in fbl:
		f.write('''\\
\t%s''' % (fb + '.o'))

	for fn in data.CFILES:
		fb = filebase(fn) + '.o'
		f.write('''

%s : ../%s ../include/konoha/gen/konoha_class_.h
%s	$(CC) $(CFLAGS) %s -I"../include" -o%s -c "../%s" 
''' % (fb, fn, HASMAKERULES, c_options, fb, fn))


def write_dll(f, data, CC, CFLAGS, OS):
	PROG = 'konoha'
	DLL = 'libkonoha.so'
	if OS == 'macosx':
		DLL = DLL.replace('.so', '.dylib')
	if OS == 'mingw' or OS == 'cygwin' or OS == 'windows':
		PROG += '.exe'
		DLL = DLL.replace('.so', '.dll')

	f.write('''#Makefiile by gen_konoha.py
CC = %s
CFLAGS = %s
LDLIBS = %s

program = %s
library = %s

.PHONY: all
all: $(program) 

''' % (CC, CFLAGS, osldlibs(data, OS), PROG, DLL))

	LDLIBS = ''
	for l in data.OPTIONS:
		if l.startswith("-l"): LDLIBS += " " + l

	if OS == 'windows':
		write_nmakeobjs(f, data)
		f.write('''
$(program): $(library) konoha.obj
	$(CC) -o $(program) konoha.obj -L"." -lkonoha
''') 
	else:
		write_makeobjs(f, data)
		f.write('''
$(program): $(library) konoha.o
	$(CC) -o $(program) konoha.o -L"." -lkonoha
''') 
	
	if DLL.endswith('.dylib'):
		f.write('''
$(library) : $(objs)
	$(CC) -dynamiclib -o $(library) -L"./lib" -L"." $(objs) $(LDLIBS) %s
''' % (LDLIBS))
	elif DLL.endswith('.dll'):
		if OS == 'windows':
			f.write('''
$(library) : $(objs)
	$(CC) -shared -Wl -o $(library) -L"./lib" -L"." $(objs) $(LDLIBS) %s
''' % (LDLIBS))
		else:
			f.write('''
$(library) : $(objs)
	$(CC) -shared -Wl -o $(library) -L"./lib" -L"." $(objs) $(LDLIBS) %s
''' % (LDLIBS))
	else:
		f.write('''
$(library) : $(objs)
	$(CC) -shared -Wl,-soname,libkonoha.so -o $(library) -L"./lib" -L"." $(objs) $(LDLIBS) %s
''' % (LDLIBS))

def add_package(bdir, data):
	dir = bdir + '/package'
	fl = os.listdir(dir)
	for fn in fl:
		fpath =  dir + '/' + fn
		if not os.path.isdir(fpath): continue
		fl2 = os.listdir(fpath)
		for fn2 in fl2:
			if fn2.endswith('.c'):
				data.CFILES.append('package/' + fn + '/' + fn2)
				

def write_mono(f, data, CC, CFLAGS, OS):
	PROG = 'konoha'
	if OS == 'mingw' or OS == 'cygwin' or OS == 'windows':
		PROG += '.exe'
	if OS == 'tb':
		EXTRA = '''
include ../../etc/makerules
VPATH = "./ $(shell find ../ -type d) ./"
'''
		global HASMAKERULES
		HASMAKERULES = '#'
	else:
		EXTRA = ''

	f.write('''#Makefiile by gen_konoha.py
%sCC = %s
%s
CFLAGS += %s
%sLDLIBS = %s

program = %s
library =

.PHONY: all
all: $(program)

''' % (HASMAKERULES, CC, EXTRA, CFLAGS, HASMAKERULES, osldlibs(data,OS), PROG))
	
	write_makeobjs(f, data)
	
	LDLIBS = ''
	for l in data.OPTIONS:
		if l.startswith("-l"): LDLIBS += " " + l
	
	f.write('''
$(program): $(objs) konoha.o
%s	$(CC) -o $(program) $^ -L"./lib" -L"./libexec" $(LDLIBS) %s
%s	strip $(program)
''' % (HASMAKERULES, LDLIBS, HASMAKERULES))

### nmake ##################################################################

def write_nmakeobjs(f, data, c_options = ''):
	fbl = []
	for fn in data.CFILES:
		fb = filebase(fn)
		if fb == 'konoha': continue
		fbl.append(fb)
	
	f.write('''
LINK32DLL_OBJ = ''')
	for fb in fbl:
		f.write('''\\
\t$(OUTDIR)\\%s''' % (fb + '.obj'))

	for fn in data.CFILES:
		fb = filebase(fn) + '.obj'
		f.write('''

$(OUTDIR)\\%s : ..\\%s 
	cl /c $(CFLAGS) /I"..\\include" /o$(OUTDIR)\\%s "..\\%s" 
''' % (fb, fn.replace('/', '\\'), fb, fn.replace('/', '\\')))

def write_nmake(f, data, CC, CFLAGS, OS):
	f.write('''#Makefiile by gen_konoha.py
KONOHA=konoha
OUTDIR=.
BINDIR=.\\bin
LINK32=link.exe

ALL : $(BINDIR)\\$(KONOHA).exe

CLEAN :
	-@erase /Q $(BINDIR)\\*
	-@erase /Q $(OUTDIR)\\*.OBJ

$(BINDIR) :
	if not exist $(BINDIR)/$(NULL) mkdir $(BINDIR)

CFLAGS=\\
	/nologo\\
	/W4\\
	/Fo"$(OUTDIR)\\"\\
	/Fd"$(OUTDIR)\\"\\
	/c\\
	/Zi\\
	/D_WIN32_WINNT=0x0600\\
	/DUNICODE\\
	/D_UNICODE

LINK32DLL_FLAGS=kernel32.lib user32.lib\\
 /nologo /subsystem:windows /dll /incremental:no\\
 /pdb:"$(BINDIR)/$(KONOHA).pdb" /machine:I386 /out:"$(BINDIR)/$(KONOHA).dll"\\
 /implib:"$(BINDIR)/$(KONOHA).lib"

LINK32_FLAGS=konoha.lib\\
 /nologo /subsystem:console /incremental:no\\
 /out:"$(BINDIR)/$(KONOHA).exe"

''')
	
	write_nmakeobjs(f, data)
	
	f.write('''

$(BINDIR)\\$(KONOHA).dll : $(BINDIR) $(LINK32DLL_OBJS)
	$(LINK32) $(LINK32DLL_FLAGS) $(LINK32DLL_OBJS)

$(BINDIR)\\$(KONOHA).exe : $(BINDIR) $(LINK32DLL_OBJS) "$(OUTDIR)/konoha.obj"
	$(LINK32) $(LINK32_FLAGS) $(LINK32DLL_OBJS) "$(OUTDIR)/$(KONOHA).obj"

''') 


def gen_makefile(bdir, data):
	if 'tb' in data.OPTIONS:
		f = open(bdir + '/tbmx1/makefile', 'w')
	elif 'mingw' in data.OPTIONS:
		f = open(bdir + '/mingw/makefile', 'w')
	elif 'windows' in data.OPTIONS:
		f = open(bdir + '/windows/makefile', 'w')
	else:
		f = open(bdir + '/build/Makefile', 'w')
	
	CC = "gcc"
	CFLAGS = '-O2 -Wall -fmessage-length=0 -fPIC'
	OS = 'unix'
	
	for l in data.OPTIONS:
		if l.startswith("-O"): 
			CFLAGS = CFLAGS.replace('-O2', l)
		elif l.startswith("CC="):
			CC = l.replace("CC=", "")
		elif l == '-g':
			CFLAGS += ' -g -DKNH_DBGMODE'
		elif l.startswith('-mtune') or l.startswith('-mcpu'):
			CFLAGS += ' %s' % l
		elif l == 'macosx':
			OS = 'macosx'
			CFLAGS = CFLAGS.replace(" -fPIC", "")
			CFLAGS += ' -DKONOHA_OS__MACOSX'
		elif l == 'mingw':
			OS = 'mingw'
			CFLAGS = CFLAGS.replace(" -fPIC", '')
			CFLAGS += ' -I"include" -DKONOHA_OS__MINGW'
		elif l == 'cygwin':
			OS = 'cygwin'
			CFLAGS = CFLAGS.replace(" -fPIC", "")
			CFLAGS += ' -DKONOHA_OS__CYGWIN'
		elif l == 'windows':
			OS = 'windows'
			CFLAGS = '/O2'
		elif l == 'tb':
			OS = 'tb'
			HASMAKERULES = '#'
			CFLAGS += ' -I/usr/local/te/include -I"../include" -DKONOHA_OS__TB'
			data.OPTIONS.append("-mono")
	
	if '-liconv' in data.OPTIONS:
		CFLAGS += ' -DKNH_USING_ICONV'

	if '-mono' in data.OPTIONS :
		CFLAGS = CFLAGS.replace(" -fPIC", "")
		CFLAGS += ' -DKONOHA_MONOLITHIC'
		add_package(bdir, data)
		write_mono(f, data, CC, CFLAGS, OS)
	elif OS == 'windows':
		write_nmake(f, data, 'cl', CFLAGS, OS)
		f.close()
		return
	else:
		write_dll(f, data, CC, CFLAGS, OS)
		
	f.write('''

.PHONY: dist
dist:
	$(RM) -rf $(objs) konoha.o

.PHONY: clean
clean:
	$(RM) -rf $(objs) $(program) $(library) konoha.o 

''')
	f.close()

#############

if __name__ == '__main__':
	bdir = '..'
	from source import *
	data = read_data(bdir)
	gen_makefile(bdir, data)
