/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER
 *
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation
 * All rights reserved.
 *
 * You may choose one of the following two licenses when you use konoha.
 * See www.konohaware.org/license.html for further information.
 *
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

/* ************************************************************************ */

#include<konoha.h>

#define KNH_PKGNAME "unix"

#ifdef KNH_USING_POSIX
#include <unistd.h>
#include <signal.h>
#endif


#ifdef __cplusplus
extern "C" {
#endif

#ifdef KNH_USING_POSIX

/* ======================================================================== */
/* [method] */

/* ------------------------------------------------------------------------ */
/* @method[CONST] Int! System.getpid() */

static
METHOD knh__System_getpid(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_RETURN_Int(ctx, sfp, getpid());
}

/* ------------------------------------------------------------------------ */
/* @method[CONST] Int! System.getppid() */

static
METHOD knh__System_getppid(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_RETURN_Int(ctx, sfp, getppid());
}

/* ------------------------------------------------------------------------ */
/* @method[CONST] void System.kill(Int! pid, Int! sig) */

static
METHOD knh__System_kill(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_SECURE(ctx);
	KNH_BESTRICT(ctx, kill(ARG_int(sfp[1]), ARG_int(sfp[2])), != -1);
	KNH_RETURN_void(ctx, sfp);
}

/* ------------------------------------------------------------------------ */
/* @method[CONST] void System.system(String! cmd) */

static
METHOD knh__System_system(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_SECURE(ctx);
	KNH_BESTRICT(ctx, system(ARG_char(sfp[1])), != -1);
	KNH_RETURN_void(ctx, sfp);
}

/* ======================================================================== */

#endif/*KNH_USING_POSIX*/

/* ======================================================================== */
/* [KNHAPI] */

int knhunix_init(Ctx *ctx)
{
#ifdef KNH_USING_POSIX
	KNH_NOTICE(ctx, "loading unix..");
	konoha_addMethod(ctx, "@Const Int! System.getpid()", knh__System_getpid);
	konoha_addMethod(ctx, "@Const Int! System.getppid()", knh__System_getppid);
	konoha_addMethod(ctx, "@Const void System.kill(Int! pid, Int! sig)", knh__System_kill);
	konoha_addIntConst(ctx, "SIG_KILL", SIGKILL);

	konoha_addMethod(ctx, "@Const void System.shell(String! cmd)", knh__System_system);
	konoha_addMethod(ctx, "@Const void System.system(String! cmd)", knh__System_system);
#else
	KNH_WARNING(ctx, "unsupported unix package..");
#endif
	return 1;
}

/* ------------------------------------------------------------------------ */

void knhunix_traverse(Ctx *ctx, f_traverse ftr)
{
	if(konoha_issweep(ftr)) {

	}
}

/* ------------------------------------------------------------------------ */

static knh_pkgmeta_t PKGDATA = {
	KONOHA_BUILDID, /* Don't change this */
	KNH_PKGNAME,    /* package name (not NULL) */
	"1.0",  /* package version (not NULL) */
	NULL,   /* additional information */
	KONOHA_URLBASE "package.unix", /* URL */
	knhunix_init,
	knhunix_traverse,
	NULL
};

KNHAPI(knh_pkgmeta_t*) knhunix_load(Ctx *ctx)
{
	return &(PKGDATA);
}

/* ------------------------------------------------------------------------ */

#ifdef __cplusplus
}
#endif
