<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:ex="http://www.koiroha.org/xmlns/regex/org.koiroha.jive2ch.util.XSLTExtension">
<xsl:output method="html" encoding="UTF-8"/>
<!--
●変換パラメータ
  o font-size ... ユーザが選択したフォントサイズ
  o popup     ... ポップアップ表示用の変換時に長さ 1 以上の文字列
  o preview   ... プレビュー表示用の変換時に長さ 1 以上の文字列
  o export    ... エクスポート用の変換時に長さ 1 以上の文字列
  o thumb     ... サムネール表示が有効な場合に長さ 1 以上の文字列

●XPath 拡張関数
  名前空間 ... http://www.koiroha.org/xmlns/regex/org.koiroha.jive2ch.util.XSLTExtension
  contains([文字列], [正規表現]): boolean
-->
<xsl:param name="font-size">small</xsl:param>
<xsl:param name="popup"></xsl:param>
<xsl:param name="preview"></xsl:param>
<xsl:param name="export"></xsl:param>
<xsl:param name="thumb"></xsl:param>

<!--
●テンプレート: thread
  ページの基本 HTML を作成するためのテンプレート。<div id="content"> 要素の中にレスの HTML が挿入されます。
-->
<xsl:template match="thread">
<html>
<head>
<title><xsl:value-of select="@title"/></title>
<style type="text/css">
<xsl:choose>
<xsl:when test="$popup">
body {
	font-size: <xsl:value-of select="$font-size"/>;
	background-color: rgb(204,204,255);
	padding: 2px 2px 0px 2px;
	margin: 0px;
}
#content {
	font-size: 0.9em;
}
</xsl:when>
<xsl:otherwise>
body {
	font-size: <xsl:value-of select="$font-size"/>;
	background-color: white;
}
</xsl:otherwise>
</xsl:choose>
.meta {
	color: rgb(153,153,153);
	font-family: sans-serif;
}
.message {
	font-family: "ＭＳ Ｐゴシック", "Lucida Grande", "Osaka", sans-serif;
	margin: 0.8em 0em 1.2em 2em;
}
.message .aa {
	font-family: "ＭＳ Ｐゴシック", Mona, Osaka, "ヒラギノ角ゴ Pro W3", Arial, Helvetica, sans-serif;
	color: #202020;
}
.num {
	cursor: hand;
}
.name {
	color: rgb(0,158,0);
	font-weight: bold;
}
.mail {
	color: rgb(102,102,255);
	font-size: 0.9em;
}
.new {
	color: rgb(255,25,25);
	font-size: 0.9em;
}
.meta .id {
	color: rgb(153,153,153);
	cursor: hand;
}
.message .id {
	font-style: italic;
	cursor: hand;
}
a:link {
	text-decoration: underline;
}
a:hover {
	text-decoration: underline;
}
.be {
	font-size: 0.9em;
}
</style>
<script type="text/javascript">
function clear_all_new_mark(){
	var allelem = document.getElementsByTagName("*");
	var i;
	for(i=0; i&lt;allelem.length; i++){
		if(allelem[i].className == "new"){
			allelem[i].style.display = "none";
		}
	}
	return;
}
function page_search(){
	if(window.search){
		window.search();
	} else {
		alert("このブラウザではページ内検索がサポートされていません");
	}
	return;
}
function get_rectangle(elem){
	var x = 0;
	var y = 0;
	var width = elem.offsetWidth;
	var height = elem.offsetHeight;
	while(elem.offsetParent){
		x += elem.offsetLeft;
		y += elem.offsetTop;
		elem = elem.offsetParent;
	}
	return { x: x, y: y, width: width, height: height };
}
function get_viewport(elem){
	var top = document.documentElement.scrollTop || document.body.scrollTop;
	var left = document.documentElement.scrollLeft || document.body.scrollLeft;
	return { x: left, y: top };
}
function click(target, elem){
	if(jive2ch_callback){
		var v = get_viewport(elem);
		var r = get_rectangle(elem);
		jive2ch_callback("click", target, v.x, v.y, r.x, r.y, r.width, r.height);
	}
}
function mouseover(target, elem){
	if(jive2ch_callback){
		var v = get_viewport(elem);
		var r = get_rectangle(elem);
		jive2ch_callback("mouseover", target, v.x, v.y, r.x, r.y, r.width, r.height);
	}
}
function mouseexit(target){
	if(jive2ch_callback){
		jive2ch_callback("mouseexit", target);
	}
}
</script>
</head>
<body onload="jive2ch_callback('onload');">
<div id="content"><xsl:apply-templates/></div>
</body>
</html>
</xsl:template>

<!--
●テンプレート: response
  レスを表示するための HTML を作成します。
  o アンカー用の id="resNNN" 要素と <a name="resNNN"> 要素
-->
<xsl:template match="response[not(@ng)]">
<div class="res" id="num{number}">
<a name="num{number}"></a>
<div class="meta">
	<span class="num" onmousedown="click('num:{number}',this)"><xsl:value-of select="number"/></span>&#160;
	<span class="name"><b>
	<xsl:choose>
		<xsl:when test="number(name)">
			<span onmouseover="mouseover('>>{name}',this);" onmouseout="mouseexit('>>{name}');"><xsl:apply-templates select="name"/></span>
		</xsl:when>
		<xsl:otherwise><xsl:apply-templates select="name"/></xsl:otherwise>
	</xsl:choose>
	</b></span>&#160;
	<xsl:if test="string-length(mail)!=0">
		<span class="mail"><a href="mailto:{mail}"><xsl:value-of select="mail"/></a></span>&#160;
	</xsl:if>
	<xsl:if test="boolean(@new)"><span class="new">New!&#160;</span></xsl:if>
	<!--
	<xsl:if test="date"><xsl:value-of select="date"/>&#160;</xsl:if>
	<xsl:if test="id">ID:<xsl:value-of select="id"/>&#160;</xsl:if>
	<xsl:if test="be">BE:<xsl:value-of select="be"/>&#160;</xsl:if>
	--> 
	<xsl:apply-templates select="misc"/>
</div>
<div class="message">
<xsl:choose>
<xsl:when test="content/@aa"><span class="aa"><xsl:apply-templates select="content"/></span></xsl:when>
<xsl:otherwise><xsl:apply-templates select="content"/></xsl:otherwise>
</xsl:choose>

<!-- このレスのサムネールを表示 -->
<xsl:if test="$thumb">
<div>
<xsl:for-each select=".//a[ex:contains(@href,'(?i)\.(jpg|jpeg|gif|png|tif|tiff)')]">
<img src="{@href}" height="62" onmouseover="mouseover('{@href}',this);" onmouseout="mouseexit('{@href}');"/>
</xsl:for-each>
</div>
</xsl:if>
</div>
</div>
</xsl:template>

<!-- NG ワードを含むレス (通常あぼーん) -->
<xsl:template match="response[@ng='abone']">
<div class="res" id="num{number}">
<a name="num{number}"></a>
<div class="meta">
	<span class="num" onmousedown="click('num:{number}',this)"><xsl:value-of select="number"/></span>&#160;
	<span class="name" style="font-weight:normal; font-style:italic;">あぼーん</span>&#160;
	<xsl:if test="boolean(@new)"><span class="new">New!&#160;</span></xsl:if>
</div>
<div class="message">あぼーん</div>
</div>
</xsl:template>

<!-- NG ワードを含むレス (透明あぼーん) -->
<xsl:template match="response[@ng='transparent']"></xsl:template>


<xsl:template match="a">
<xsl:choose>
<xsl:when test="starts-with(@href,'#')">
	<a href="{substring(@href,5)}"><xsl:value-of select="."/></a>
</xsl:when>
<xsl:otherwise>
	<a href="{@href}" onclick="click('{@href}',this);" onmouseover="mouseover('{@href}',this);" onmouseout="mouseexit('{@href}');"><xsl:value-of select="."/></a>
</xsl:otherwise>
</xsl:choose>
</xsl:template>

<xsl:template match="pointer">
<a href="#num{@href}" onmouseover="mouseover('&gt;&gt;{@href}',this)" onmouseout="mouseexit('&gt;&gt;{@href}');" class="pointer"><xsl:value-of select="."/></a>
</xsl:template>

<xsl:template match="fusianasan"><span style="font-weight:normal;"><xsl:value-of select="."/></span></xsl:template>

<xsl:template match="id"><span onmouseover="mouseover('{.}',this);" onmouseout="mouseexit('{.}');" class="id"><xsl:value-of select="."/></span></xsl:template>
<xsl:template match="be"><span class="be"><xsl:value-of select="."/></span></xsl:template>
<xsl:template match="br"><br/></xsl:template>
<xsl:template match="img"><xsl:copy-of select="."/></xsl:template>
<xsl:template match="font"><xsl:copy-of select="."/></xsl:template>

</xsl:stylesheet>
