/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.xml.parser;

import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Position
implements Comparable<Position>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String USERDATA_NAME = "org.koiroha.xml.parser.position";
    private final int lineNumber;
    private final int columnNumber;

    public Position(int line, int col) {
        assert (line > 0 && col > 0) : "invalid position(" + line + "," + col + ")";
        this.lineNumber = line;
        this.columnNumber = col;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    @Override
    public int compareTo(Position other) {
        if (this.getLineNumber() > other.getLineNumber()) {
            return 1;
        }
        if (this.getLineNumber() < other.getLineNumber()) {
            return -1;
        }
        if (this.getColumnNumber() > other.getColumnNumber()) {
            return 1;
        }
        if (this.getColumnNumber() < other.getColumnNumber()) {
            return -1;
        }
        return 0;
    }

    public int hashCode() {
        return this.getLineNumber() << 16 | this.getColumnNumber();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Position)) {
            return false;
        }
        Position other = (Position)o;
        return this.getLineNumber() == other.getLineNumber() && this.getColumnNumber() == other.getColumnNumber();
    }

    public String toString() {
        return "(" + this.getLineNumber() + "," + this.getColumnNumber() + ")";
    }
}

