/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.xml.parser;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.koiroha.xml.Xml;
import org.koiroha.xml.parser.AbstractXMLReader;
import org.koiroha.xml.parser.BuilderLexicalHandler;
import org.koiroha.xml.parser.LocatorReader;
import org.koiroha.xml.parser.Markup;
import org.koiroha.xml.parser.Toolkit;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DefaultHandler2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LooseXMLReader
extends AbstractXMLReader {
    private static final Logger logger = Logger.getLogger(LooseXMLReader.class.getName());
    public static final String FEATURE_LOWERCASE_NAME = "http://www.koiroha.org/sax/futures/html/lowercasename";
    private ContentHandler contentHandler = null;
    private Markup currentMarkup = null;
    private static final Pattern ATTR_NAME = Pattern.compile("\\s*([^\\s=]+)\\s*");
    private static final Pattern[] ATTR_VALUE = new Pattern[]{Pattern.compile("=\\s*\"([^\"]*)\"\\s*"), Pattern.compile("=\\s*'([^']*)'\\s*"), Pattern.compile("=\\s*([^\\s]*)\\s*")};
    private static final Pattern EMPTY = Pattern.compile("\\s*/");

    public LooseXMLReader() {
        this(new HashMap<String, Boolean>(), new HashMap<String, Object>());
    }

    public LooseXMLReader(Map<String, Boolean> feature, Map<String, Object> property) {
        super(feature, property);
    }

    public boolean isLowerCaseName() {
        return this.getFeature(FEATURE_LOWERCASE_NAME, true);
    }

    @Override
    protected void handleDocument() throws IOException, SAXException {
        block10: {
            Short type;
            logger.finest("handleDocument(); lowercase=" + this.isLowerCaseName() + "," + "namespace=" + this.isNamespaceAware() + "," + "validation=" + this.isValidating());
            this.contentHandler = this.getContentHandler();
            if (this.contentHandler == null) {
                this.contentHandler = new DefaultHandler2();
            }
            block8: while (true) {
                this.in.markLocation();
                type = this.in.getNextType();
                if (type == null) break block10;
                switch (type) {
                    case 3: {
                        this.handleText();
                        continue block8;
                    }
                    case 4: {
                        this.handleCDATA();
                        continue block8;
                    }
                    case 8: {
                        this.handleComment();
                        continue block8;
                    }
                    case 7: {
                        this.handleProcessingInstruction();
                        continue block8;
                    }
                    case 1: {
                        this.handleElement();
                        continue block8;
                    }
                    case 10: {
                        this.handleDocumentType();
                        continue block8;
                    }
                }
                if (!$assertionsDisabled) break;
            }
            throw new AssertionError(type);
        }
    }

    private void handleElement() throws IOException, SAXException {
        logger.finest("handleElement()");
        Markup elem = this.readElement(this.currentMarkup);
        assert (elem != null);
        String uri = elem.getUri();
        String localName = elem.getLocalName();
        String qName = elem.getQName();
        if (elem.isEnd()) {
            this.contentHandler.endElement(uri, localName, qName);
        } else {
            this.contentHandler.startElement(uri, localName, qName, elem.getAttributes());
            if (elem.isEmpty()) {
                this.contentHandler.endElement(uri, localName, qName);
            } else if (this.isNotXmlSemantics(uri, localName, qName)) {
                logger.finest("recognize text or comment in element: " + elem);
                this.in.setTextModeEnd(qName);
            }
        }
        if (!elem.isEnd() && !elem.isEmpty()) {
            this.currentMarkup = elem;
        } else if (this.currentMarkup != null && elem.isEnd() && this.currentMarkup.getQName().equals(elem.getQName())) {
            this.currentMarkup = this.currentMarkup.getParent();
        }
    }

    private void handleText() throws IOException, SAXException {
        String text;
        if (this.in.isTextMode()) {
            int ch = this.in.read();
            if (ch == 60) {
                logger.finest("'<' detect in text mode");
                this.contentHandler.characters(new char[]{(char)ch}, 0, 1);
            } else {
                this.in.unread(ch);
            }
        }
        while ((text = this.read(1024, "<\ufffe", true)) != null) {
            char[] buffer = text.toCharArray();
            this.contentHandler.characters(buffer, 0, buffer.length);
        }
    }

    private void handleCDATA() throws IOException, SAXException {
        String text;
        String heading = "<![CDATA[";
        String trailing = "]]>";
        this.in.skipSequence(heading, true, true);
        this.getLexicalHandler().startCDATA();
        while ((text = this.read(1024, trailing, false)) != null) {
            char[] buffer = text.toCharArray();
            this.contentHandler.characters(buffer, 0, buffer.length);
        }
        this.getLexicalHandler().endCDATA();
        this.in.skipSequence(trailing, false);
    }

    private void handleComment() throws IOException, SAXException {
        String cmt;
        String heading = "<!--";
        String trailing = "-->";
        this.in.skipSequence(heading, true);
        if (this.getLexicalHandler() instanceof BuilderLexicalHandler) {
            ((BuilderLexicalHandler)this.getLexicalHandler()).startComment();
        }
        char[] buffer = new char[512];
        boolean warned = false;
        char pre = '\u0000';
        while ((cmt = this.read(512, trailing, false)) != null) {
            for (int offset = 0; offset < cmt.length(); offset += buffer.length) {
                int len = Math.min(buffer.length, cmt.length() - offset);
                cmt.getChars(offset, offset + len, buffer, 0);
                this.getLexicalHandler().comment(buffer, 0, len);
            }
            if (warned) continue;
            warned = this.checkDoubleHyphen(pre, cmt);
            pre = cmt.charAt(cmt.length() - 1);
        }
        if (!warned && pre == '-') {
            this.warn("C0001", new Object[0]);
        }
        if (this.getLexicalHandler() instanceof BuilderLexicalHandler) {
            ((BuilderLexicalHandler)this.getLexicalHandler()).endComment();
        }
        this.in.skipSequence(trailing, false);
    }

    private boolean checkDoubleHyphen(char pre, String cmt) throws SAXException {
        for (int i = 0; i < cmt.length(); ++i) {
            if (pre == '-' && cmt.charAt(i) == '-') {
                this.warn("C0001", new Object[0]);
                return true;
            }
            pre = cmt.charAt(i);
        }
        return false;
    }

    private void handleProcessingInstruction() throws IOException, SAXException {
        String heading = "<?";
        String trailing = "?>";
        this.in.skipSequence(heading, true);
        String target = this.read(Integer.MAX_VALUE, trailing, false);
        if (target == null) {
            target = "";
        }
        String data = "";
        for (int i = 0; i < target.length(); ++i) {
            if (!Xml.isWhitespace(target.charAt(i))) continue;
            int te = i;
            while (i + 1 < target.length() && Xml.isWhitespace(target.charAt(i + 1))) {
                ++i;
            }
            data = target.substring(i + 1);
            target = target.substring(0, te);
            break;
        }
        if (target.equalsIgnoreCase("xml")) {
            this.handleXMLDeclaration(data);
        } else {
            this.contentHandler.processingInstruction(target, data);
        }
        this.in.skipSequence(trailing, false);
    }

    private void handleXMLDeclaration(String data) throws SAXException {
        Map<String, String> attr = Toolkit.parseAttributesSimply(data);
        String version = attr.get("version");
        String encoding = attr.get("encoding");
        if (version == null) {
            version = "1.0";
        }
        this.in.setXmlVersion(version);
        this.in.setEncoding(encoding);
        this.setProperty("http://xml.org/sax/properties/document-xml-version", version);
        logger.finest("xml declaration detected: version=" + version + ", encoding=" + encoding);
        attr.remove("version");
        attr.remove("encoding");
        attr.remove("standalone");
        for (String name : attr.keySet()) {
            this.warn("X0001", name, Xml.escape(attr.get(name)));
        }
    }

    private void handleDocumentType() throws IOException, SAXException {
        String trailing = ">";
        this.in.skipSequence("<!DOCTYPE\u0000", true, true);
        String decl = this.read(Integer.MAX_VALUE, trailing, false);
        if (decl == null) {
            decl = "";
        }
        String name = null;
        String publicId = null;
        String systemId = null;
        String[] format = new String[]{"([^\\s]+)\\s+PUBLIC\\s+[\"']([^\"]*)[\"']\\s*[\"']([^\"]*)[\"']\\s*", "([^\\s]+)\\s+PUBLIC\\s+[\"']([^\"]*)[\"']()\\s*", "([^\\s]+)\\s+SYSTEM\\s+()[\"']([^\"]*)[\"']\\s*", "([^\\s]+)\\s*()()"};
        for (int i = 0; i < format.length; ++i) {
            Pattern pattern = Pattern.compile(format[i], 2);
            Matcher matcher = pattern.matcher(decl);
            if (!matcher.matches()) continue;
            name = matcher.group(1);
            publicId = matcher.group(2);
            systemId = matcher.group(3);
            break;
        }
        logger.finest("dtd: " + name + ",publicId=" + publicId + ",systemId=" + systemId);
        if (name == null) {
            this.warn("D0001", decl);
        } else if (this.getDTDHandler() != null) {
            if (this.isLowerCaseName()) {
                name = name.toLowerCase();
            }
            this.getDTDHandler().notationDecl(name, publicId, systemId);
        }
        this.in.skipSequence(trailing, false);
    }

    private String read(int capacity, String sequence, boolean resolveEntity) throws IOException, SAXException {
        return this.read(this.in, capacity, sequence, resolveEntity);
    }

    private String read(PushbackReader in, int capacity, String sequence, boolean resolveEntity) throws IOException, SAXException {
        int ch;
        StringBuilder buffer = new StringBuilder();
        while (!(sequence != null && Toolkit.streamStartsWith(in, sequence, false) || buffer.length() >= capacity || (ch = in.read()) < 0)) {
            if (ch == 65279) continue;
            if (ch == 13) {
                buffer.append('\n');
                ch = in.read();
                if (ch < 0) break;
                if (ch == 10) continue;
                in.unread(ch);
                continue;
            }
            if (ch == 38 && resolveEntity) {
                String c;
                if (in instanceof LocatorReader) {
                    in.unread(38);
                    ((LocatorReader)in).markLocation();
                    in.read();
                }
                if ((c = this.readEntityReference(in)) == null) {
                    buffer.append('&');
                    continue;
                }
                buffer.append(c);
                continue;
            }
            buffer.append((char)ch);
        }
        if (buffer.length() == 0) {
            return null;
        }
        return buffer.toString();
    }

    private Markup readElement(Markup parent) throws IOException, SAXException {
        return this.readElement(this.in, this.isLowerCaseName(), parent);
    }

    private Markup readElement(PushbackReader in, boolean lowerCase, Markup parent) throws IOException, SAXException {
        int leading = in.read();
        assert (leading == 60);
        StringBuilder buffer = new StringBuilder();
        while (true) {
            int ch;
            if ((ch = in.read()) < 0) {
                assert (buffer.length() > 0);
                break;
            }
            if (ch == 62) break;
            buffer.append((char)ch);
        }
        String body = buffer.toString();
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("(" + this.in.getLineNumber() + "," + this.in.getColumnNumber() + ") read element body: <" + body + ">");
        }
        boolean end = false;
        if (body.startsWith("/")) {
            end = true;
            body = body.substring(1);
        }
        String name = null;
        for (int i = 0; i < body.length(); ++i) {
            char ch = body.charAt(i);
            if (!Xml.isWhitespace(ch)) continue;
            name = body.substring(0, i);
            body = body.substring(i + 1).trim();
            break;
        }
        boolean empty = false;
        if (name == null) {
            name = body;
            body = "";
            if (name.endsWith("/")) {
                name = name.substring(0, name.length() - 1);
                empty = true;
            }
        }
        if (lowerCase) {
            name = name.toLowerCase();
        }
        HashMap<String, String> attribute = new HashMap<String, String>();
        if (body.length() > 0) {
            assert (!empty);
            empty = this.parseElementBody(body, lowerCase, attribute);
        }
        Markup elem = new Markup(this.isNamespaceAware(), parent, name, attribute, empty, end);
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("parse new element: " + elem);
        }
        if (elem.isEnd() && !elem.isEmpty() && elem.getAttributes().getLength() > 0) {
            this.warn("E0001", elem.getQName());
            elem.getAttributes().clear();
        }
        if (this.isNamespaceAware()) {
            for (int i = 0; i < elem.getAttributes().getLength(); ++i) {
                String qName = elem.getAttributes().getQName(i);
                int sep = qName.indexOf(58);
                if (sep < 0) continue;
                String prefix = qName.substring(0, sep);
                String ns = elem.getAttributes().getURI(i);
                if (!ns.equals("")) continue;
                this.warn("E0007", prefix);
            }
        }
        return elem;
    }

    private String parseEntityReference(String text) throws SAXException, IOException {
        String str;
        StringBuilder buffer = new StringBuilder(text.length());
        PushbackReader in = new PushbackReader(new StringReader(text), 64);
        while ((str = this.read(in, 1024, null, true)) != null) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private String readEntityReference(PushbackReader in) throws IOException, SAXException {
        int ch;
        StringBuilder buffer = new StringBuilder();
        while (buffer.length() < this.getMaxEntityReferenceName() && (ch = in.read()) >= 0) {
            if (ch == 59) {
                String uc = this.getEntityReference(buffer.toString());
                if (uc == null) {
                    this.warn("T0100", buffer);
                    buffer.append((char)ch);
                    in.unread(buffer.toString().toCharArray());
                    return null;
                }
                return uc;
            }
            buffer.append((char)ch);
        }
        this.warn("T0001", buffer);
        if (buffer.length() > 0) {
            in.unread(buffer.toString().toCharArray());
        }
        return null;
    }

    protected boolean isNotXmlSemantics(String uri, String localName, String qName) {
        return false;
    }

    private void warn(String msgid, Object ... args) throws SAXException {
        if (this.getErrorHandler() != null) {
            String message = msgid + ":" + Toolkit.format("warn." + msgid, args);
            logger.finest("warn(): " + message);
            SAXParseException ex = new SAXParseException(message, this.in.getPublicId(), this.in.getSystemId(), this.in.getLineNumber(), this.in.getColumnNumber());
            this.getErrorHandler().warning(ex);
        }
    }

    private boolean parseElementBody(String body, boolean lowerCase, Map<String, String> attribute) throws IOException, SAXException {
        logger.finest("parseElementBody(" + body + ")");
        while (body.length() > 0) {
            Matcher matcher = ATTR_NAME.matcher(body);
            if (!matcher.find()) {
                if (body.trim().length() <= 0) break;
                this.warn("E0009", body.trim());
                break;
            }
            String head = body.substring(0, matcher.start()).trim();
            if (head.length() > 0) {
                this.warn("E0009", head);
            }
            if (EMPTY.matcher(body.substring(matcher.start())).matches()) {
                return true;
            }
            body = body.substring(matcher.end());
            String name = matcher.group(1);
            if (lowerCase) {
                name = name.toLowerCase();
            }
            logger.finest("attribute name: " + name);
            String value = null;
            if (body.length() == 0 || body.charAt(0) != '=') {
                value = name;
            } else {
                assert (body.charAt(0) == '=');
                for (int i = 0; i < ATTR_VALUE.length; ++i) {
                    matcher = ATTR_VALUE[i].matcher(body);
                    if (!matcher.lookingAt()) continue;
                    value = matcher.group(1);
                    body = body.substring(matcher.end());
                    break;
                }
                assert (value != null) : body;
                value = this.parseEntityReference(value);
            }
            logger.finest("attribute value: " + value);
            logger.finest("remaining element body: \"" + body + "\"");
            if (attribute.containsKey(name)) {
                this.warn("E0010", name, attribute.get(name), value);
            }
            attribute.put(name, value);
        }
        return false;
    }
}

