/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.xml.parser;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import org.koiroha.xml.Xml;
import org.koiroha.xml.parser.LFReader;
import org.koiroha.xml.parser.Toolkit;
import org.xml.sax.ext.Locator2;

public class LocatorReader
extends PushbackReader
implements Locator2 {
    private final String publicId;
    private final String systemId;
    private String xmlVersion = null;
    private String encoding = null;
    private int currentLine = 1;
    private int currentColumn = 1;
    private int line = 1;
    private int column = 1;
    private String textModeEnd = null;

    LocatorReader(Reader in, String publicId, String systemId) {
        super(new LFReader(in), 64);
        this.publicId = publicId;
        this.systemId = systemId;
    }

    public void markLocation() {
        assert (this.currentLine > 0 && this.currentColumn > 0) : "(" + this.currentLine + "," + this.currentColumn + ")";
        this.line = this.currentLine;
        this.column = this.currentColumn;
    }

    public String getXMLVersion() {
        return this.xmlVersion;
    }

    public void setXmlVersion(String xmlVersion) {
        this.xmlVersion = xmlVersion;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public int getLineNumber() {
        return this.line;
    }

    public int getColumnNumber() {
        return this.column;
    }

    public int read() throws IOException {
        int ch = super.read();
        if (ch < 0) {
            return ch;
        }
        assert (ch != 13);
        if (ch == 10) {
            ++this.currentLine;
            this.currentColumn = 1;
            return 10;
        }
        ++this.currentColumn;
        return ch;
    }

    public int read(char[] cbuf) throws IOException {
        return this.read(cbuf, 0, cbuf.length);
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        int length = super.read(cbuf, off, len);
        for (int i = 0; i < length; ++i) {
            if (cbuf[i] == '\n') {
                ++this.currentLine;
                this.currentColumn = 1;
                continue;
            }
            ++this.currentColumn;
        }
        return length;
    }

    public void unread(int c) throws IOException {
        super.unread(c);
        if (c == 10) {
            --this.currentLine;
            this.currentColumn = 1;
        } else if (this.currentColumn > 1) {
            --this.currentColumn;
        }
    }

    public void unread(char[] cbuf) throws IOException {
        this.unread(cbuf, 0, cbuf.length);
    }

    public void unread(char[] cbuf, int off, int len) throws IOException {
        for (int i = len - 1; i >= 0; --i) {
            this.unread(cbuf[off + i]);
        }
    }

    public boolean isEOF() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            return true;
        }
        this.unread(ch);
        return false;
    }

    public Short getNextType() throws IOException {
        if (this.isEOF()) {
            return null;
        }
        if (!this.startsWith("<") || this.startsWith("<\uffff")) {
            return (short)3;
        }
        if (this.startsWith("<!--")) {
            return (short)8;
        }
        if (this.startsWith("<![CDATA[", true)) {
            return (short)4;
        }
        if (this.textModeEnd != null) {
            if (!this.startsWith("</" + this.textModeEnd + ">", true)) {
                return (short)3;
            }
            this.textModeEnd = null;
        }
        if (this.startsWith("<?")) {
            return (short)7;
        }
        if (this.startsWith("<!DOCTYPE\u0000", true)) {
            return (short)10;
        }
        return (short)1;
    }

    public void setTextModeEnd(String textModeEnd) {
        this.textModeEnd = textModeEnd;
    }

    public boolean isTextMode() {
        return this.textModeEnd != null;
    }

    public boolean startsWith(String sequence) throws IOException {
        return this.startsWith(sequence, false);
    }

    public boolean startsWith(String sequence, boolean ignoreCase) throws IOException {
        return Toolkit.streamStartsWith(this, sequence, ignoreCase);
    }

    public String skipSequence(String sequence, boolean validate) throws IOException {
        return this.skipSequence(sequence, validate, false);
    }

    public String skipSequence(String sequence, boolean validate, boolean ignoreCase) throws IOException {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < sequence.length(); ++i) {
            int ch = this.read();
            assert (!validate || Toolkit.matches(sequence.charAt(i), ch, ignoreCase)) : sequence + "[" + i + "] != " + (char)ch;
            buffer.append((char)ch);
        }
        return buffer.toString();
    }

    public void skipWhitespace() throws IOException {
        int ch;
        while ((ch = this.read()) >= 0) {
            if (Xml.isWhitespace(ch)) continue;
            this.unread(ch);
            break;
        }
    }
}

