/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.xml.parser;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;

class LFReader
extends FilterReader {
    private boolean skipLF = false;

    public LFReader(Reader in) {
        super(in);
    }

    public int read() throws IOException {
        int ch = super.read();
        if (ch == 10 && this.skipLF) {
            ch = super.read();
            this.skipLF = false;
        }
        if (ch == 13) {
            ch = 10;
            this.skipLF = true;
        } else {
            this.skipLF = false;
        }
        return ch;
    }

    public int read(char[] cbuf) throws IOException {
        return this.read(cbuf, 0, cbuf.length);
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        int dst = 0;
        do {
            int length;
            if ((length = super.read(cbuf, off, len)) < 0) {
                return length;
            }
            int src = 0;
            dst = 0;
            if (this.skipLF && cbuf[off] == '\n') {
                ++src;
            }
            this.skipLF = false;
            while (src + 1 < length) {
                if (cbuf[off + src] != '\r') {
                    cbuf[off + dst] = cbuf[off + src];
                    ++dst;
                } else if (cbuf[off + src + 1] != '\n') {
                    cbuf[off + dst] = 10;
                    ++dst;
                }
                ++src;
            }
            if (src >= length) continue;
            int last = cbuf[off + length - 1];
            if (last == 13) {
                last = 10;
                this.skipLF = true;
            }
            cbuf[off + dst] = last;
            ++dst;
        } while (dst == 0);
        return dst;
    }
}

