/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.xml.parser;

import java.nio.charset.Charset;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.SAXParser;
import org.koiroha.xml.Xml;
import org.koiroha.xml.parser.AbstractSAXParserFactory;
import org.koiroha.xml.parser.HTMLParser;
import org.koiroha.xml.parser.Toolkit;
import org.xml.sax.SAXException;

public class HTMLParserFactory
extends AbstractSAXParserFactory {
    private static final Logger logger = Logger.getLogger(HTMLParserFactory.class.getName());

    public HTMLParserFactory() {
        this.setLowerCaseName(true);
    }

    public void setLowerCaseName(boolean lowercase) {
        try {
            this.setFeature("http://www.koiroha.org/sax/futures/html/lowercasename", lowercase);
        }
        catch (SAXException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public boolean isLowerCaseName() {
        try {
            return this.getFeature("http://www.koiroha.org/sax/futures/html/lowercasename");
        }
        catch (SAXException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public SAXParser newSAXParser() {
        HTMLParser parser = new HTMLParser(this.feature, this.isXIncludeAware(), this.getSchema());
        return parser;
    }

    protected String guessEncodingFromPrereadSampling(String sample) {
        String encoding = super.guessEncodingFromPrereadSampling(sample);
        if (encoding != null) {
            return encoding;
        }
        Pattern pattern = Pattern.compile("<meta\\s+([^>]*)/?>", 34);
        Matcher matcher = pattern.matcher(sample);
        while (matcher.find()) {
            Charset charset;
            String meta = matcher.group(1);
            Map<String, String> attr = Toolkit.parseAttributesSimply(meta);
            String httpEquiv = attr.get("http-equiv");
            String content = attr.get("content");
            if (httpEquiv == null || !httpEquiv.toLowerCase().equals("content-type") || content == null || (charset = Xml.getCharset(content)) == null) continue;
            return charset.name();
        }
        logger.finest("meta element with http-quiv=\"content-type\" is not specified, or charset attribute unrecognized");
        return null;
    }
}

