/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.xml.parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.Schema;
import org.koiroha.xml.parser.HTMLDocumentBuilder;
import org.koiroha.xml.parser.HTMLParserFactory;
import org.xml.sax.InputSource;

public class HTMLDocumentBuilderFactory
extends DocumentBuilderFactory {
    private static final Logger logger = Logger.getLogger(HTMLDocumentBuilderFactory.class.getName());
    public static final String FEATURE_HTML_OPTIMIZE = "http://www.koiroha.org/sax/features/htmloptimize";
    static final String FEATURE_LOWERCASE_NAME = "http://www.koiroha.org/sax/futures/html/lowercasename";
    static final String FEATURE_COALESCING = "http://www.koiroha.org/sax/features/coalescing";
    static final String FEATURE_IGNORE_COMMENT = "http://www.koiroha.org/sax/features/ignorecomment";
    private final Map<String, Boolean> feature = new HashMap<String, Boolean>();
    private final DocumentBuilderFactory factory;

    public HTMLDocumentBuilderFactory() {
        this(DocumentBuilderFactory.newInstance());
    }

    public HTMLDocumentBuilderFactory(DocumentBuilderFactory factory) {
        this.factory = factory;
        this.setLowerCaseName(true);
        this.setHtmlOptimize(false);
    }

    public Object getAttribute(String name) throws IllegalArgumentException {
        return this.factory.getAttribute(name);
    }

    public void setAttribute(String name, Object value) throws IllegalArgumentException {
        this.factory.setAttribute(name, value);
    }

    public boolean getFeature(String name) {
        Boolean value = this.feature.get(name);
        if (value == null) {
            return false;
        }
        return value;
    }

    public void setFeature(String name, boolean value) {
        logger.finest("setFeature(" + name + "," + value + ")");
        this.feature.put(name, value);
    }

    public void setLowerCaseName(boolean lowerCase) {
        this.setFeature(FEATURE_LOWERCASE_NAME, lowerCase);
    }

    public boolean isLowerCaseName() {
        return this.getFeature(FEATURE_LOWERCASE_NAME);
    }

    public void setHtmlOptimize(boolean html) {
        this.setFeature(FEATURE_HTML_OPTIMIZE, html);
    }

    public boolean isHtmlOptimize() {
        return this.getFeature(FEATURE_HTML_OPTIMIZE);
    }

    public void setCoalescing(boolean coalescing) {
        this.setFeature(FEATURE_COALESCING, coalescing);
        this.factory.setCoalescing(coalescing);
    }

    public boolean isCoalescing() {
        return this.factory.isCoalescing();
    }

    public void setExpandEntityReferences(boolean expandEntityRef) {
        this.factory.setExpandEntityReferences(expandEntityRef);
    }

    public boolean isExpandEntityReferences() {
        return this.factory.isExpandEntityReferences();
    }

    public void setIgnoringComments(boolean ignoreComments) {
        this.setFeature(FEATURE_IGNORE_COMMENT, ignoreComments);
        this.factory.setIgnoringComments(ignoreComments);
    }

    public boolean isIgnoringComments() {
        return this.factory.isIgnoringComments();
    }

    public void setIgnoringElementContentWhitespace(boolean whitespace) {
        this.factory.setIgnoringElementContentWhitespace(whitespace);
    }

    public boolean isIgnoringElementContentWhitespace() {
        return this.factory.isIgnoringElementContentWhitespace();
    }

    public void setNamespaceAware(boolean awareness) {
        this.setFeature("http://xml.org/sax/features/namespaces", awareness);
        this.factory.setNamespaceAware(awareness);
    }

    public boolean isNamespaceAware() {
        return this.factory.isNamespaceAware();
    }

    public void setSchema(Schema schema) {
        this.factory.setSchema(schema);
    }

    public Schema getSchema() {
        return this.factory.getSchema();
    }

    public void setValidating(boolean validating) {
        this.setFeature("http://xml.org/sax/features/validation", validating);
        this.factory.setValidating(validating);
    }

    public boolean isValidating() {
        return this.factory.isValidating();
    }

    public void setXIncludeAware(boolean state) {
        this.factory.setXIncludeAware(state);
    }

    public boolean isXIncludeAware() {
        return this.factory.isXIncludeAware();
    }

    public DocumentBuilder newDocumentBuilder() throws ParserConfigurationException {
        return new HTMLDocumentBuilder(this.factory.newDocumentBuilder(), this.feature);
    }

    public InputSource guessInpuSource(InputStream in, String charset, int maxLength) throws IOException {
        return new HTMLParserFactory().guessInpuSource(in, charset, maxLength);
    }
}

