/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.xml.parser;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import org.koiroha.xml.Xml;
import org.koiroha.xml.parser.BuilderLexicalHandler;
import org.koiroha.xml.parser.HTMLInvocationHandler;
import org.koiroha.xml.parser.Position;
import org.koiroha.xml.parser.Toolkit;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.ext.Locator2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HTMLBuilder
extends DefaultHandler2
implements BuilderLexicalHandler {
    private static final Logger logger = Logger.getLogger(HTMLBuilder.class.getName());
    private final Map<String, Boolean> feature = new HashMap<String, Boolean>();
    private final DocumentBuilder builder;
    private final ErrorHandler errorHandler;
    private Document doc = null;
    private Element current = null;
    private StringBuilder cdata = null;
    private StringBuilder comment = null;
    private Locator2 locator = null;
    private StringBuilder epilogue = null;

    public HTMLBuilder(DocumentBuilder builder, EntityResolver entityResolver, ErrorHandler errorHandler, Map<String, Boolean> feature) {
        this.builder = builder;
        this.errorHandler = errorHandler;
        this.feature.putAll(feature);
    }

    public boolean getFeature(String name) {
        Boolean value = this.feature.get(name);
        if (value == null) {
            return false;
        }
        return value;
    }

    private boolean isHtmlOptimize() {
        return this.getFeature("http://www.koiroha.org/sax/features/htmloptimize");
    }

    private boolean isCoalescing() {
        return this.getFeature("http://www.koiroha.org/sax/features/coalescing");
    }

    private boolean isIgnoringComments() {
        return this.getFeature("http://www.koiroha.org/sax/features/ignorecomment");
    }

    private boolean isNamespaceAware() {
        return this.getFeature("http://xml.org/sax/features/namespaces");
    }

    public Document getDocument() {
        return this.doc;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = (Locator2)locator;
    }

    @Override
    public void startDocument() {
        logger.finest("startDocument(); namespace=" + this.isNamespaceAware() + "," + "xinclude=" + this.builder.isXIncludeAware() + "," + "validation=" + this.builder.isValidating());
        this.doc = this.builder.newDocument();
    }

    @Override
    public void endDocument() {
        String version;
        logger.finest("endDocument()");
        assert (this.cdata == null) : this.cdata;
        assert (this.comment == null) : this.comment;
        if (this.epilogue != null && this.epilogue.length() > 0) {
            assert (this.doc.getDocumentElement() != null);
            String text = this.epilogue.toString();
            text = HTMLBuilder.trimRight(text);
            this.doc.getDocumentElement().appendChild(this.doc.createTextNode(text));
        }
        if ((version = this.locator.getXMLVersion()) != null) {
            this.doc.setXmlVersion(version);
        }
        HTMLInvocationHandler handler = new HTMLInvocationHandler(this.doc);
        handler.setInputEncoding(this.locator.getEncoding());
        this.doc = (Document)Proxy.newProxyInstance(HTMLBuilder.class.getClassLoader(), new Class[]{Document.class}, (InvocationHandler)handler);
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attrs) throws SAXException {
        logger.finest("startElement(" + uri + "," + localName + "," + name + ",attrs)");
        Element elem = null;
        try {
            elem = this.isNamespaceAware() ? this.doc.createElementNS(uri, name) : this.doc.createElement(name);
        }
        catch (DOMException ex) {
            logger.finest(ex.toString());
            if (ex.code == 5) {
                this.warn("E0005", name);
            } else {
                this.warn("E9999", ex.getMessage());
            }
            return;
        }
        for (int i = 0; i < attrs.getLength(); ++i) {
            String auri = attrs.getURI(i);
            String aname = attrs.getQName(i);
            String avalue = attrs.getValue(i);
            logger.finest("setAttributeNS(" + auri + "," + aname + "," + avalue + ")");
            try {
                if (this.isNamespaceAware()) {
                    elem.setAttributeNS(auri, aname, avalue);
                    continue;
                }
                elem.setAttribute(aname, avalue);
                continue;
            }
            catch (DOMException ex) {
                logger.finest(ex.toString());
                if (ex.code == 5) {
                    this.warn("E0006", aname, Xml.escape(avalue));
                    continue;
                }
                this.warn("E9999", ex.getMessage());
            }
        }
        if (localName.equalsIgnoreCase("html")) {
            if (this.doc.getDocumentElement() == null) {
                this.doc.appendChild(elem);
                logger.finest("html element detected");
            } else {
                Element root = this.doc.getDocumentElement();
                while (root.getFirstChild() != null) {
                    Node node = root.removeChild(root.getFirstChild());
                    elem.appendChild(node);
                }
                this.doc.removeChild(root);
                this.doc.appendChild(elem);
                logger.finest("replace html element");
            }
        } else {
            if (this.current != null && this.isHtmlOptimize()) {
                Element mover = this.current;
                Element parent = Toolkit.getPreferredParent(this.current, elem);
                if (mover != parent) {
                    this.warn("E0008", mover.getTagName());
                    do {
                        Position pos = (Position)mover.getUserData("org.koiroha.xml.parser.position");
                        this.warn(pos, "E0004", mover.getTagName());
                    } while ((mover = (Element)mover.getParentNode()) != parent);
                }
                this.current = parent;
            }
            this.appendNode(elem);
        }
        if (!Toolkit.isEmptyElement(uri, localName, name)) {
            this.current = elem;
            logger.finest("current element pointer set to <" + name + ">");
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        logger.finest("endElement(" + uri + "," + localName + "," + name + ")");
        if (Toolkit.isEmptyElement(uri, localName, name)) {
            logger.finest("ignore end of empty element");
            this.checkEmptyElementEnd(uri, localName, name);
            return;
        }
        Element target = this.search(name);
        if (target == null) {
            this.warn("E0002", name);
            return;
        }
        for (Element mover = this.current; mover != target; mover = (Element)mover.getParentNode()) {
            Position pos = (Position)mover.getUserData("org.koiroha.xml.parser.position");
            this.warn(pos, "E0004", mover.getTagName());
        }
        if (target.getParentNode() instanceof Element) {
            this.current = (Element)target.getParentNode();
            logger.finest("move current elemnt to <" + this.current.getTagName() + ">");
        } else {
            this.current = null;
            this.epilogue = new StringBuilder();
            logger.finest("end document element, start epilogue");
        }
    }

    private void checkEmptyElementEnd(String uri, String localName, String name) throws SAXException {
        if (this.current == null) {
            this.warn("E0002", name);
            return;
        }
        Node last = this.current.getLastChild();
        while (last instanceof Text && ((Text)last).getData().trim().length() == 0) {
            last = last.getPreviousSibling();
        }
        if (!(last instanceof Element)) {
            this.warn("E0002", name);
            return;
        }
        Element elem = (Element)last;
        if (this.isNamespaceAware()) {
            if (!elem.getLocalName().equals(localName)) {
                this.warn("E0002", name);
            }
        } else if (!elem.getTagName().equals(name)) {
            this.warn("E0002", name);
        }
    }

    @Override
    public void startCDATA() {
        logger.finest("startCDATA()");
        if (!this.isCoalescing()) {
            this.cdata = new StringBuilder();
        }
    }

    @Override
    public void endCDATA() {
        logger.finest("endCDATA(): <![CDATA[" + this.cdata + "]]>");
        CDATASection cdata = this.doc.createCDATASection(this.cdata.toString());
        this.appendNode(cdata);
        this.cdata = null;
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        logger.finest("characters(ch," + start + "," + length + ")");
        if (this.cdata != null) {
            this.cdata.append(ch, start, length);
            return;
        }
        Text text = this.doc.createTextNode(new String(ch, start, length));
        this.appendNode(text);
    }

    @Override
    public void startComment() throws SAXException {
        if (!this.isIgnoringComments()) {
            this.comment = new StringBuilder();
        }
    }

    @Override
    public void endComment() throws SAXException {
        logger.finest("endComment(): <!--" + this.comment + "-->");
        if (!this.isIgnoringComments()) {
            Comment cmt = this.doc.createComment(this.comment.toString());
            this.appendNode(cmt);
            this.comment = null;
        }
    }

    @Override
    public void comment(char[] ch, int start, int length) {
        if (!this.isCoalescing()) {
            this.comment.append(ch, start, length);
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        logger.finest("processingInstruction(" + target + "," + data + ")");
        try {
            ProcessingInstruction pi = this.doc.createProcessingInstruction(target, data);
            this.appendNode(pi);
        }
        catch (DOMException ex) {
            logger.fine(ex.toString());
            this.warn("P0001", target);
        }
    }

    @Override
    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
        logger.finest("notationDecl(" + name + "," + publicId + "," + systemId + ")");
        DOMImplementation domImpl = this.doc.getImplementation();
        DocumentType docType = domImpl.createDocumentType(name, publicId, systemId);
        if (this.doc.getDoctype() != null) {
            this.warn("D0002", name, publicId, systemId);
            return;
        }
        this.doc.insertBefore(docType, this.doc.getFirstChild());
    }

    private void appendNode(Node node) {
        Position pos = new Position(this.locator.getLineNumber(), this.locator.getColumnNumber());
        node.setUserData("org.koiroha.xml.parser.position", pos, null);
        if (this.current != null) {
            this.current.appendChild(node);
            return;
        }
        if (node instanceof ProcessingInstruction || node instanceof Comment || node instanceof DocumentType) {
            logger.finest("append node to document directlly");
            this.doc.appendChild(node);
            return;
        }
        if (this.doc.getDocumentElement() == null) {
            if (node.getNodeType() == 3) {
                String text = ((Text)node).getData();
                if ((text = HTMLBuilder.trimLeft(text)).length() == 0) {
                    logger.finest("fully whitespace characters in prologue is ignored");
                    return;
                }
                node = this.doc.createTextNode(text);
                logger.finest("text in prologue: \"" + text + "\"");
            }
            Element root = this.doc.createElementNS("", "html");
            this.doc.appendChild(root);
            root.appendChild(node);
            this.current = root;
            logger.finest("create html element implicitly because appearance of node for element");
            assert (root.getLocalName() != null) : root;
            return;
        }
        logger.finest("evaluating epilogue node...");
        assert (this.epilogue != null);
        Element root = this.doc.getDocumentElement();
        if (node.getNodeType() == 3) {
            String text = ((Text)node).getData();
            this.epilogue.append(text);
            return;
        }
        if (this.epilogue.length() > 0) {
            root.appendChild(this.doc.createTextNode(this.epilogue.toString()));
            this.epilogue.setLength(0);
        }
        root.appendChild(node);
    }

    private Element search(String qName) {
        if (this.current == null) {
            return null;
        }
        Element mover = this.current;
        while (true) {
            if (mover.getTagName().equals(qName)) {
                return mover;
            }
            if (!(mover.getParentNode() instanceof Element)) break;
            mover = (Element)mover.getParentNode();
        }
        return null;
    }

    private static String trimLeft(String text) {
        for (int i = 0; i < text.length(); ++i) {
            if (Xml.isWhitespace(text.charAt(i))) continue;
            return text.substring(i);
        }
        return "";
    }

    private static String trimRight(String text) {
        for (int i = text.length() - 1; i >= 0; --i) {
            if (Xml.isWhitespace(text.charAt(i))) continue;
            return text.substring(0, i + 1);
        }
        return "";
    }

    private void warn(String msgid, Object ... args) throws SAXException {
        this.warn(null, msgid, args);
    }

    private void warn(Position pos, String msgid, Object ... args) throws SAXException {
        if (this.errorHandler != null) {
            if (pos == null) {
                pos = new Position(this.locator.getLineNumber(), this.locator.getColumnNumber());
            }
            String message = msgid + ":" + Toolkit.format("warn." + msgid, args);
            SAXParseException ex = new SAXParseException(message, this.locator.getPublicId(), this.locator.getSystemId(), pos.getLineNumber(), pos.getColumnNumber());
            this.errorHandler.warning(ex);
        }
    }
}

