/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.xml.parser;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AttributeOrderKeeper
implements InvocationHandler,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Method GET_ATTRIBUTES;
    private static final Method SET_ATTRIBUTE;
    private static final Method SET_ATTRIBUTE_NS;
    private static final Method SET_ATTRIBUTE_NODE;
    private static final Method SET_ATTRIBUTE_NODE_NS;
    private static final Method REMOVE_ATTRIBUTE;
    private static final Method REMOVE_ATTRIBUTE_NS;
    private static final Method REMOVE_ATTRIBUTE_NODE;
    private static final Method ITEM;
    private final Element elem;
    private final NamedNodeMap attr;
    private final List<String> names;

    public AttributeOrderKeeper(Element elem) {
        this.elem = elem;
        this.attr = null;
        this.names = new ArrayList<String>();
    }

    public AttributeOrderKeeper(NamedNodeMap attr, List<String> names) {
        this.elem = null;
        this.attr = attr;
        this.names = names;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (proxy instanceof Element) {
            return this.invokeElement(proxy, method, args);
        }
        return this.invokeNamedNodeMap(proxy, method, args);
    }

    private Object invokeElement(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.equals(GET_ATTRIBUTES)) {
            NamedNodeMap attr = this.elem.getAttributes();
            return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{NamedNodeMap.class, Serializable.class}, (InvocationHandler)new AttributeOrderKeeper(attr, this.names));
        }
        if (method.equals(SET_ATTRIBUTE)) {
            String name = (String)args[0];
            if (!this.names.contains(name)) {
                this.names.add(name);
            }
            return method.invoke((Object)this.elem, args);
        }
        if (method.equals(SET_ATTRIBUTE_NS)) {
            String uri = (String)args[0];
            String name = (String)args[1];
            name = uri + '\u0000' + name;
            if (!this.names.contains(name)) {
                this.names.add(name);
            }
            return method.invoke((Object)this.elem, args);
        }
        if (method.equals(SET_ATTRIBUTE_NODE)) {
            Attr attr = (Attr)args[0];
            String name = attr.getName();
            if (!this.names.contains(name)) {
                this.names.add(name);
            }
            return method.invoke((Object)this.elem, args);
        }
        if (method.equals(SET_ATTRIBUTE_NODE_NS)) {
            Attr attr = (Attr)args[0];
            String uri = attr.getNamespaceURI();
            String name = attr.getLocalName();
            name = uri + '\u0000' + name;
            if (!this.names.contains(name)) {
                this.names.add(name);
            }
            return method.invoke((Object)this.elem, args);
        }
        if (method.equals(REMOVE_ATTRIBUTE)) {
            String name = (String)args[0];
            this.names.remove(name);
            return method.invoke((Object)this.elem, args);
        }
        if (method.equals(REMOVE_ATTRIBUTE_NS)) {
            String uri = (String)args[0];
            String name = (String)args[1];
            name = uri + '\u0000' + name;
            this.names.remove(name);
            return method.invoke((Object)this.elem, args);
        }
        if (method.equals(REMOVE_ATTRIBUTE_NODE)) {
            Attr attr = (Attr)args[0];
            String name = attr.getName();
            if (attr.getNamespaceURI() != null) {
                name = attr.getNamespaceURI() + '\u0000' + attr.getLocalName();
            }
            this.names.remove(name);
            return method.invoke((Object)this.elem, args);
        }
        return method.invoke((Object)this.elem, args);
    }

    private Object invokeNamedNodeMap(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.equals(ITEM)) {
            int index = (Integer)args[0];
            String name = this.names.get(index);
            int sep = name.indexOf(0);
            if (sep < 0) {
                return this.attr.getNamedItem(name);
            }
            String uri = name.substring(0, sep);
            name = name.substring(sep + 1);
            return this.attr.getNamedItemNS(uri, name);
        }
        return method.invoke((Object)this.attr, args);
    }

    static {
        try {
            GET_ATTRIBUTES = Node.class.getDeclaredMethod("getAttributes", new Class[0]);
            SET_ATTRIBUTE = Element.class.getDeclaredMethod("setAttribute", String.class, String.class);
            SET_ATTRIBUTE_NS = Element.class.getDeclaredMethod("setAttributeNS", String.class, String.class, String.class);
            SET_ATTRIBUTE_NODE = Element.class.getDeclaredMethod("setAttributeNode", Attr.class);
            SET_ATTRIBUTE_NODE_NS = Element.class.getDeclaredMethod("setAttributeNodeNS", Attr.class);
            REMOVE_ATTRIBUTE = Element.class.getDeclaredMethod("removeAttribute", String.class);
            REMOVE_ATTRIBUTE_NS = Element.class.getDeclaredMethod("removeAttributeNS", String.class, String.class);
            REMOVE_ATTRIBUTE_NODE = Element.class.getDeclaredMethod("removeAttributeNode", Attr.class);
            ITEM = NamedNodeMap.class.getDeclaredMethod("item", Integer.TYPE);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }
}

