/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.xml.parser;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.SequenceInputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.Schema;
import org.koiroha.xml.parser.Toolkit;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public abstract class AbstractSAXParserFactory
extends SAXParserFactory {
    private static final Logger logger = Logger.getLogger(AbstractSAXParserFactory.class.getName());
    protected final Map<String, Boolean> feature = new HashMap<String, Boolean>();
    private boolean xincludeAware = false;
    private Schema schema = null;

    protected AbstractSAXParserFactory() {
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException {
        Boolean value = this.feature.get(name);
        if (value == null) {
            return false;
        }
        return value;
    }

    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        logger.finest("setFuture(" + name + "," + value + ")");
        this.feature.put(name, value);
    }

    public boolean isNamespaceAware() {
        try {
            return this.getFeature("http://xml.org/sax/features/namespaces");
        }
        catch (SAXException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public void setNamespaceAware(boolean awareness) {
        try {
            this.setFeature("http://xml.org/sax/features/namespaces", awareness);
        }
        catch (SAXException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public boolean isValidating() {
        try {
            return this.getFeature("http://xml.org/sax/features/validation");
        }
        catch (SAXException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public void setValidating(boolean awareness) {
        try {
            this.setFeature("http://xml.org/sax/features/validation", awareness);
        }
        catch (SAXException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public void setXIncludeAware(boolean state) {
        this.xincludeAware = state;
    }

    public boolean isXIncludeAware() {
        return this.xincludeAware;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public InputSource guessInpuSource(InputStream in, String charset, int maxLength) throws IOException {
        int len;
        logger.finest("reading " + maxLength + " bytes stream heading to determine stream encoding...");
        byte[] preread = new byte[maxLength];
        int length = 0;
        while (preread.length - length > 0 && (len = in.read(preread, length, preread.length - length)) >= 0) {
            length += len;
        }
        in = new SequenceInputStream(new ByteArrayInputStream(preread, 0, length), in);
        String encoding = this.guessEncodingFromPrereadSampling(preread, length);
        if (encoding == null || !Charset.isSupported(encoding)) {
            logger.finest("encoding is not specified in stream or not supported: " + encoding + ", apply " + charset);
            encoding = charset;
            if (!Charset.isSupported(encoding)) {
                logger.warning("specified encoding is not supported in this environment: " + encoding);
                throw new UnsupportedEncodingException(encoding);
            }
        }
        logger.finest("creating text reader: " + encoding);
        InputStreamReader r = new InputStreamReader(in, encoding);
        InputSource is = new InputSource(r);
        is.setEncoding(encoding);
        return is;
    }

    protected String guessEncodingFromPrereadSampling(byte[] binary, int length) {
        if (length >= 2 && ((binary[0] & 0xFF) == 254 && (binary[1] & 0xFF) == 255 || (binary[0] & 0xFF) == 255 && (binary[1] & 0xFF) == 254)) {
            logger.finest("byte order mark detected");
            return "UTF-16";
        }
        Charset usascii = Charset.forName("us-ascii");
        try {
            String sample = new String(binary, 0, length, usascii.name());
            return this.guessEncodingFromPrereadSampling(sample);
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException(ex);
        }
    }

    protected String guessEncodingFromPrereadSampling(String sample) {
        Pattern pattern = Pattern.compile("<\\?xml\\s+(.*)\\?>", 32);
        Matcher matcher = pattern.matcher(sample);
        if (matcher.find()) {
            String meta = matcher.group(1);
            Map<String, String> attr = Toolkit.parseAttributesSimply(meta);
            String encoding = attr.get("encoding");
            if (encoding == null) {
                encoding = "UTF-8";
            }
            return encoding;
        }
        return null;
    }
}

