/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.xml;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Xml {
    private static final Logger logger = Logger.getLogger(Xml.class.getName());
    private static final String FEATURE_PREFIX = "http://xml.org/sax/features/";
    public static final String FEATURE_NAMESPACES = "http://xml.org/sax/features/namespaces";
    public static final String FEATURE_VALIDATION = "http://xml.org/sax/features/validation";
    private static final String PROPERTY_PREFIX = "http://xml.org/sax/properties/";
    public static final String PROPERTY_DOCUMENT_XML_VERSION = "http://xml.org/sax/properties/document-xml-version";
    public static final String PROPERTY_LEXICAL_HANDLER = "http://xml.org/sax/properties/lexical-handler";
    private static final Pattern CHARSET_ATTRIBUTE = Pattern.compile(";\\s*charset\\s*=\\s*[\"']?([^\"'\\s;]*)[\"']?", 2);

    private Xml() {
    }

    public static boolean isWhitespace(int ch) {
        return ch == 32 || ch == 9 || ch == 13 || ch == 10;
    }

    public static String escape(CharSequence text) {
        StringBuilder buffer = new StringBuilder(text.length());
        try {
            Xml.escape(buffer, text);
        }
        catch (IOException ex) {
            throw new IllegalStateException("StringBuilder thrown IOException!", ex);
        }
        return buffer.toString();
    }

    public static void escape(Appendable out, CharSequence text) throws IOException {
        block10: for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '<': {
                    out.append("&lt;");
                    continue block10;
                }
                case '>': {
                    out.append("&gt;");
                    continue block10;
                }
                case '&': {
                    out.append("&amp;");
                    continue block10;
                }
                case '\"': {
                    out.append("&quot;");
                    continue block10;
                }
                case '\'': {
                    out.append("&apos;");
                    continue block10;
                }
                case '\n': {
                    out.append('\n');
                    continue block10;
                }
                case '\t': {
                    out.append('\t');
                    continue block10;
                }
                case '\r': {
                    out.append('\n');
                    if (i + 1 >= text.length() || text.charAt(i + 1) != '\n') continue block10;
                    ++i;
                    continue block10;
                }
                default: {
                    if (Character.isDefined(ch) && !Character.isISOControl(ch)) {
                        out.append(ch);
                        continue block10;
                    }
                    out.append("&#" + ch + ";");
                }
            }
        }
    }

    public static String unescape(CharSequence text) {
        StringBuilder buffer = new StringBuilder(text.length());
        try {
            Xml.unescape(buffer, text);
        }
        catch (IOException ex) {
            throw new IllegalStateException("StringBuilder thrown IOException!", ex);
        }
        return buffer.toString();
    }

    public static void unescape(Appendable out, CharSequence text) throws IOException {
        Xml.unescape(out, text, new EntityMapper(){

            public void map(Appendable out, String entity) throws IOException {
                if (entity.equals("amp")) {
                    out.append('&');
                } else if (entity.equals("lt")) {
                    out.append('<');
                } else if (entity.equals("gt")) {
                    out.append('>');
                } else if (entity.equals("quot")) {
                    out.append('\"');
                } else if (entity.equals("apos")) {
                    out.append('\'');
                } else {
                    super.map(out, entity);
                }
            }
        });
    }

    public static Charset getCharset(String contentType) {
        logger.finest("getCharset(" + contentType + ")");
        if (contentType == null) {
            return null;
        }
        Matcher matcher = CHARSET_ATTRIBUTE.matcher(contentType);
        if (!matcher.find()) {
            logger.finest("no charset specified: " + contentType);
            return null;
        }
        String charset = matcher.group(1);
        boolean supported = false;
        try {
            supported = Charset.isSupported(charset);
        }
        catch (IllegalCharsetNameException ex) {
            // empty catch block
        }
        if (!supported) {
            logger.finest("unsupported charset specified: " + charset + ": " + contentType);
            return null;
        }
        logger.finest("charset retrieved: " + charset + ": " + contentType);
        return Charset.forName(charset);
    }

    static void unescape(Appendable out, CharSequence text, EntityMapper mapper) throws IOException {
        int tail;
        int head;
        int begin = 0;
        while (begin < text.length() && (head = Xml.indexOf(text, begin, '&')) >= 0 && (tail = Xml.indexOf(text, head + 1, ';')) >= 0) {
            out.append(text, begin, head);
            String entity = ((Object)text.subSequence(head + 1, tail)).toString();
            mapper.map(out, entity);
            begin = tail + 1;
        }
        if (begin < text.length()) {
            out.append(text, begin, text.length());
        }
    }

    private static int indexOf(CharSequence text, int begin, char ch) {
        for (int i = begin; i < text.length(); ++i) {
            if (text.charAt(i) != ch) continue;
            return i;
        }
        return -1;
    }

    static class EntityMapper {
        EntityMapper() {
        }

        public void map(Appendable out, String entity) throws IOException {
            if (entity.length() > 1 && entity.charAt(0) == '#') {
                boolean hex = entity.length() > 2 && Character.toLowerCase(entity.charAt(1)) == 'x';
                int ch = 0;
                try {
                    ch = hex ? Integer.parseInt(entity.substring(2), 16) : Integer.parseInt(entity.substring(1), 10);
                    if (ch < 0 || ch > 65535) {
                        throw new NumberFormatException(String.valueOf(ch));
                    }
                    out.append((char)ch);
                }
                catch (NumberFormatException ex) {
                    logger.fine("invalid number entity reference: &" + entity + ";");
                    out.append('&').append(entity).append(';');
                }
            } else {
                logger.fine("unrecognized entity character reference: &" + entity + ";");
                out.append('&').append(entity).append(';');
            }
        }
    }
}

