/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.xml;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.koiroha.xml.Xml;

public final class Html {
    private static final Logger logger = Logger.getLogger(Html.class.getName());
    private static final Map<String, Character> ENTITY2CHAR = new HashMap<String, Character>();
    private static final Map<Character, String> CHAR2ENTITY = new HashMap<Character, String>();
    private static final Pattern NUM10_REF = Pattern.compile("&#([\\d]{1,5});");
    private static final Pattern NUM16_REF = Pattern.compile("&#[xX]([\\da-fA-F]{1,4});");

    private Html() {
    }

    public static int getCharacter(String entity) throws NullPointerException {
        int num;
        if (entity == null) {
            throw new NullPointerException();
        }
        if (entity.length() < 2 || entity.charAt(0) != '&' || entity.charAt(entity.length() - 1) != ';') {
            logger.fine("invalid entity reference: " + entity + "; entity must start with '&' and end with ';'.");
            return -1;
        }
        Character ch = ENTITY2CHAR.get(entity);
        if (ch != null) {
            return ch.charValue();
        }
        Matcher m = NUM10_REF.matcher(entity);
        if (m.matches() && (num = Integer.parseInt(m.group(1))) >= 0 && num <= 65535) {
            return num;
        }
        m = NUM16_REF.matcher(entity);
        if (m.matches() && (num = Integer.parseInt(m.group(1), 16)) >= 0 && num <= 65535) {
            return num;
        }
        return -1;
    }

    public static String getEntityReference(char ch) {
        String entity = CHAR2ENTITY.get(Character.valueOf(ch));
        if (entity != null) {
            return entity;
        }
        return "&#x" + Integer.toHexString(ch).toUpperCase() + ";";
    }

    public static String escape(CharSequence text) {
        StringBuilder buffer = new StringBuilder((int)((double)text.length() * 1.1));
        try {
            Html.escape(buffer, text);
        }
        catch (IOException ex) {
            throw new IllegalStateException("StringBuilder thrown IOException!", ex);
        }
        return buffer.toString();
    }

    public static void escape(Appendable out, CharSequence text) throws IOException {
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            String entity = CHAR2ENTITY.get(Character.valueOf(ch));
            if (entity == null) {
                out.append(ch);
                continue;
            }
            out.append(entity);
        }
    }

    public static String unescape(CharSequence text) {
        StringBuilder buffer = new StringBuilder((int)((double)text.length() * 1.1));
        try {
            Html.unescape(buffer, text);
        }
        catch (IOException ex) {
            throw new IllegalStateException("StringBuilder thrown IOException!", ex);
        }
        return buffer.toString();
    }

    public static void unescape(Appendable out, CharSequence text) throws IOException {
        Xml.unescape(out, text, new Xml.EntityMapper(){

            public void map(Appendable out, String entity) throws IOException {
                int ch = Html.getCharacter("&" + entity + ";");
                if (ch < 0) {
                    out.append(entity);
                } else {
                    out.append((char)ch);
                }
            }
        });
    }

    static {
        ResourceBundle res = ResourceBundle.getBundle("org.koiroha.xml.htmlentity");
        Enumeration<String> en = res.getKeys();
        while (en.hasMoreElements()) {
            String key = en.nextElement();
            String value = res.getString(key);
            String entity = "&" + key + ";";
            Character ch = Character.valueOf((char)Integer.parseInt(value));
            ENTITY2CHAR.put(entity, ch);
            CHAR2ENTITY.put(ch, entity);
        }
    }
}

