/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch.worker;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.koiroha.jive2ch.client.Connection;
import org.koiroha.jive2ch.util.ProgressAdapter;
import org.koiroha.jive2ch.worker.AbortException;

public abstract class Worker<P, R>
implements Runnable {
    private static final Logger logger = Logger.getLogger(Worker.class.getName());
    public static final int INDETERMINATE = Integer.MAX_VALUE;
    public static final int DISABLE = 0x7FFFFFFE;
    private final List<Listener<P, R>> listener = new ArrayList<Listener<P, R>>();
    private final PropertyChangeSupport propListener = new PropertyChangeSupport(this);
    private volatile int progress = 0;
    private volatile int minimum = 0;
    private volatile int maximum = Integer.MAX_VALUE;
    private volatile String status = "";
    private volatile R result = null;
    private volatile Throwable ex = null;
    private final boolean[] finish = new boolean[1];
    private volatile Thread thread = null;

    protected Worker() {
    }

    public final boolean isAlive() {
        return this.thread != null;
    }

    public void cancel() {
        if (this.isAlive()) {
            Thread t = this.thread;
            if (t != null) {
                logger.finer("*** \u51e6\u7406\u3092\u30ad\u30e3\u30f3\u30bb\u30eb\u3057\u3066\u3044\u307e\u3059: " + t.getName());
                this.thread.interrupt();
            } else {
                logger.finer("*** \u30ad\u30e3\u30f3\u30bb\u30eb\u8981\u6c42\u304c\u51fa\u3055\u308c\u307e\u3057\u305f\u304c\u30b9\u30ec\u30c3\u30c9\u304c\u5272\u308a\u5f53\u3066\u3089\u308c\u3066\u3044\u307e\u305b\u3093");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        assert (this.thread == null);
        this.thread = Thread.currentThread();
        this.finish[0] = false;
        Object t = null;
        try {
            this.setMinimum(0);
            this.setMaximum(Integer.MAX_VALUE);
            this.setProgress(0);
            this.setStatus("");
            t = this.execute();
        }
        catch (Throwable ex) {
            this.ex = ex;
            logger.fine("\u51e6\u7406\u306f\u4f8b\u5916\u3067\u7d42\u4e86\u3057\u307e\u3057\u305f: " + ex);
            for (Listener<P, R> l : this.listener) {
                l.error(ex);
            }
            if (ex instanceof ThreadDeath) {
                throw (ThreadDeath)ex;
            }
        }
        finally {
            boolean[] blArray = this.finish;
            synchronized (this.finish) {
                this.finish[0] = true;
                this.result = t;
                this.finish.notify();
                // ** MonitorExit[var2_2] (shouldn't be in output)
                if (this.ex == null) {
                    for (Listener<P, R> l : this.listener) {
                        l.done(this.result);
                    }
                }
                this.thread = null;
                this.setMaximum(0x7FFFFFFE);
            }
        }
    }

    public abstract R execute() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public R getResult() throws InterruptedException {
        boolean[] blArray = this.finish;
        synchronized (this.finish) {
            if (!this.isAlive()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.result;
            }
            this.finish.wait();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.result;
        }
    }

    public Throwable getException() {
        return this.ex;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        Integer oldValue = this.progress;
        Integer newValue = progress;
        this.progress = progress;
        this.firePropertyChange("progress", oldValue, newValue);
    }

    public int getMinimum() {
        return this.minimum;
    }

    public void setMinimum(int minimum) {
        Integer oldValue = this.maximum;
        Integer newValue = minimum;
        this.minimum = minimum;
        this.firePropertyChange("minimum", oldValue, newValue);
    }

    public int getMaximum() {
        return this.maximum;
    }

    public void setMaximum(int maximum) {
        Integer oldValue = this.maximum;
        Integer newValue = maximum;
        this.maximum = maximum;
        this.firePropertyChange("maximum", oldValue, newValue);
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        String oldValue = this.status;
        String newValue = status;
        this.status = status;
        this.firePropertyChange("status", oldValue, newValue);
    }

    public void addListener(Listener<P, R> l) {
        this.listener.add(l);
        this.addPropertyChangeListener(l);
    }

    public void removeListener(Listener<P, R> l) {
        this.listener.remove(l);
        this.removePropertyListener(l);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propListener.addPropertyChangeListener(l);
    }

    public void removePropertyListener(PropertyChangeListener l) {
        this.propListener.removePropertyChangeListener(l);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.propListener.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void processing(List<P> proc) {
        proc = new ArrayList<P>(proc);
        for (Listener<P, R> l : this.listener) {
            l.processing(proc);
        }
    }

    protected void checkCancel() throws AbortException {
        if (Thread.interrupted()) {
            logger.fine("\u51e6\u7406\u306e\u4e2d\u65ad\u3092\u691c\u51fa\u3057\u307e\u3057\u305f");
            throw new AbortException();
        }
    }

    protected void bypassProgress(Connection con) {
        this.setMinimum(0);
        con.addProgressListener(new ProgressAdapter(){

            @Override
            public void setProgress(int progress) {
                Worker.this.setProgress(progress);
            }

            @Override
            public void setMaximum(int maximum) {
                Worker.this.setMaximum(maximum);
            }
        });
    }

    public static class Adapter<P, R>
    implements Listener<P, R> {
        @Override
        public void processing(List<P> value) {
        }

        @Override
        public void done(R ret) {
        }

        @Override
        public void error(Throwable ex) {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
        }
    }

    public static interface Listener<P, R>
    extends PropertyChangeListener {
        public void processing(List<P> var1);

        public void done(R var1);

        public void error(Throwable var1);

        @Override
        public void propertyChange(PropertyChangeEvent var1);
    }
}

