/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch.worker;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.koiroha.jive2ch.Response;
import org.koiroha.jive2ch.Thread;
import org.koiroha.jive2ch.client.Connection;
import org.koiroha.jive2ch.client.InvalidDatException;
import org.koiroha.jive2ch.client.OfflineException;
import org.koiroha.jive2ch.client.UserAgent;
import org.koiroha.jive2ch.func.SkinManager;
import org.koiroha.jive2ch.util.IO;
import org.koiroha.jive2ch.util.Performance;
import org.koiroha.jive2ch.util.Pointer;
import org.koiroha.jive2ch.worker.Worker;

public class ResponseUpdateWorker
extends Worker<String, Integer> {
    private static final Logger logger = Logger.getLogger(ResponseUpdateWorker.class.getName());
    private final int frequency = 100;
    private final boolean resume;
    private final Thread thread;
    private final Pointer pointer;
    private final boolean local;
    private final boolean remote;
    private Connection con = null;
    private boolean canceled = false;

    public ResponseUpdateWorker(Thread thread, boolean resume, Pointer pointer, boolean local, boolean remote) {
        this.thread = thread;
        this.resume = resume;
        this.pointer = pointer;
        this.local = local;
        this.remote = remote;
    }

    public Thread getThread() {
        return this.thread;
    }

    @Override
    public void cancel() {
        this.canceled = true;
        super.cancel();
        Connection con = this.con;
        if (con != null) {
            con.disconnect();
        }
    }

    @Override
    public Integer execute() throws Exception {
        this.setStatus("\u30b9\u30ec\u30c3\u30c9 \"" + this.thread.getTitle() + "\" \u3092\u66f4\u65b0\u3057\u3066\u3044\u307e\u3059...");
        int recent = 0;
        if (this.local) {
            this.updateLocal();
        }
        File file = this.thread.getLocalFile();
        if (this.remote) {
            recent = this.updateRemote(file);
        }
        NumberFormat nf = NumberFormat.getNumberInstance();
        int total = this.thread.getResponseCount();
        this.setStatus("\u30b9\u30ec\u30c3\u30c9 \"" + this.thread.getTitle() + "\" \u3092\u66f4\u65b0\u3057\u307e\u3057\u305f: \u65b0\u7740 " + nf.format(recent) + " \u30ec\u30b9 / \u5168 " + nf.format(total) + " \u30ec\u30b9 (" + nf.format(file.length() / 1024L) + "kB)");
        this.thread.getBoard().getCategory().getJive2ch().getRecentReadBoard().addThread(this.thread);
        return total - (recent == 0 ? 0 : recent - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updateLocal() throws Exception {
        Thread thread = this.thread;
        synchronized (thread) {
            if (!this.thread.isCharged()) {
                logger.finer("\u30ed\u30fc\u30ab\u30eb\u304b\u3089\u30b9\u30ec\u30c3\u30c9\u306e\u30c7\u30fc\u30bf\u3092\u8aad\u307f\u8fbc\u3093\u3067\u3044\u307e\u3059: " + this.thread.getFileName());
                this.thread.charge();
                IO.checkCancel();
                List<Response> list = this.thread.getResponse();
                list = this.pointer.pickup(list);
                this.notifyResponse(list);
                return list.size();
            }
        }
        logger.finer("\u30b9\u30ec\u30c3\u30c9\u306f\u65e2\u306b\u30c1\u30e3\u30fc\u30b8\u6e08\u307f\u3067\u3059");
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updateRemote(File file) throws Exception {
        Performance pfm = Performance.start();
        File dir = file.getParentFile();
        IO.mkdir(dir);
        int count = 0;
        Thread thread = this.thread;
        synchronized (thread) {
            if (file.isFile()) {
                logger.finer("\u30ed\u30fc\u30ab\u30eb\u30ad\u30e3\u30c3\u30b7\u30e5\u304c\u5b58\u5728\u3057\u307e\u3059: " + file.getName() + " (" + file.length() + "B)");
                if (!this.thread.isCharged()) {
                    logger.fine("\u30ed\u30fc\u30ab\u30eb\u306edat\u304c\u8aad\u307f\u8fbc\u307e\u308c\u3066\u3044\u306a\u3044\u72b6\u614b\u3067\u30b9\u30ec\u30c3\u30c9\u66f4\u65b0\u304c\u884c\u308f\u308c\u307e\u3057\u305f");
                    this.thread.charge();
                }
            } else {
                logger.finer("\u30ed\u30fc\u30ab\u30eb\u30ad\u30e3\u30c3\u30b7\u30e5\u306f\u5b58\u5728\u3057\u307e\u305b\u3093: " + file.getName());
                this.thread.uncharge();
                this.thread.charge();
            }
            this.thread.clearAllNew();
            try {
                this.con = this.prepareConnection(file);
                count = this.download(this.con, file);
                this.saveMetaInfo(this.con);
            }
            catch (OfflineException ex) {
                logger.finer("\u30aa\u30d5\u30e9\u30a4\u30f3\u3067\u3059");
            }
            catch (IOException ex) {
                if (!this.canceled) {
                    throw ex;
                }
                logger.finer("\u51e6\u7406\u306e\u30ad\u30e3\u30f3\u30bb\u30eb\u306b\u3088\u308bI/O\u4f8b\u5916\u3092\u691c\u51fa\u3057\u307e\u3057\u305f");
            }
        }
        pfm.mark("\u30b9\u30ec\u30c3\u30c9\u8aad\u307f\u8fbc\u307f\u51e6\u7406");
        return count;
    }

    private Connection prepareConnection(File file) throws Exception {
        String datFile = this.thread.getFileName();
        URL url = this.thread.getBoard().getURI().resolve("dat/" + datFile).toURL();
        UserAgent ua = UserAgent.getDefault();
        Connection con = ua.open(url);
        this.bypassProgress(con);
        if (this.resume && file.isFile() && file.length() > 0L) {
            String etag;
            logger.finer("\u5dee\u5206\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u7528\u306e\u30ea\u30af\u30a8\u30b9\u30c8\u3092\u5b9f\u884c");
            con.setRequestHeader("Range", "bytes=" + (file.length() - 1L) + "-");
            Date lm = this.thread.getLastModified();
            if (lm != null) {
                con.setDateRequestHeader("If-Modified-Since", lm);
            }
            if ((etag = this.thread.getETag()) != null) {
                con.setRequestHeader("If-None-Match", "\"" + etag + "\"");
            }
            con.setRequestHeader("Accept-Encoding", "");
        }
        return con;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int download(Connection con, File file) throws IOException {
        int count = 0;
        ArrayList<Response> list = new ArrayList<Response>();
        InputStream in = null;
        try {
            String line;
            in = con.getDatInputStream(file);
            BufferedReader r = new BufferedReader(new InputStreamReader(in, IO.SJIS));
            int i = 0;
            while ((line = r.readLine()) != null) {
                logger.finest(line);
                if (i == 0 && line.matches("(?i)<html\\s*.*>.*")) {
                    String message = line + "\n" + IO.readFully(r);
                    in.close();
                    in = null;
                    IO.delete(file);
                    throw new InvalidDatException(message);
                }
                Response res = Response.parse(line);
                res.setNew(true);
                list.add(res);
                ++count;
                if (list.size() == 100) {
                    this.thread.addResponses(list);
                    this.notifyResponse(list);
                    list.clear();
                }
                this.checkCancel();
                ++i;
            }
        }
        finally {
            IO.close(in);
        }
        if (list.size() > 0) {
            this.thread.addResponses(list);
            this.notifyResponse(list);
        }
        this.thread.setResponseCount(this.thread.getAcquiredCount());
        return count;
    }

    private void notifyResponse(List<Response> list) throws IOException {
        SkinManager skin = SkinManager.getDefault();
        String html = skin.getResponseHTML(list, new HashMap<String, String>());
        ArrayList<String> proc = new ArrayList<String>();
        proc.add(html);
        proc.add(String.valueOf(list.size()));
        this.processing(proc);
    }

    private void saveMetaInfo(Connection con) throws IOException {
        Date lastModified;
        Date date = con.getDateResponseHeader("Date");
        if (date != null) {
            this.thread.setRecentAccess(date);
        }
        if ((lastModified = con.getDateResponseHeader("Last-Modified")) == null) {
            lastModified = date;
        }
        if (lastModified == null) {
            lastModified = new Date();
        }
        this.thread.setLastModified(lastModified);
        String etag = con.getResponseHeader("ETag");
        if (etag != null) {
            Pattern p = Pattern.compile(".*\"([^\"]*)\".*");
            Matcher m = p.matcher(etag);
            if (m.matches()) {
                etag = m.group(1);
            }
            this.thread.setETag(etag);
        } else {
            logger.finest("ETag\u304c\u898b\u4ed8\u304b\u308a\u307e\u305b\u3093");
        }
        this.thread.saveMetaInfo();
    }
}

