/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch.worker;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.koiroha.jive2ch.Board;
import org.koiroha.jive2ch.Icon;
import org.koiroha.jive2ch.Thread;
import org.koiroha.jive2ch.client.Connection;
import org.koiroha.jive2ch.client.OfflineException;
import org.koiroha.jive2ch.client.UserAgent;
import org.koiroha.jive2ch.func.Service;
import org.koiroha.jive2ch.util.IO;
import org.koiroha.jive2ch.util.Performance;
import org.koiroha.jive2ch.util.RollbackOutputStream;
import org.koiroha.jive2ch.worker.BoardUpdateWorker;

public class RemoteBoardUpdateWorker
extends BoardUpdateWorker {
    private static final Logger logger = Logger.getLogger(RemoteBoardUpdateWorker.class.getName());
    private final Board board;
    private final boolean local;
    private final boolean remote;
    private final Set<String> existingThreadFileNames = new HashSet<String>();

    public RemoteBoardUpdateWorker(Board board, List<Thread> threads, boolean local, boolean remote) {
        assert (board != null);
        this.board = board;
        this.local = local;
        this.remote = remote;
        this.setExistingThreadList(threads);
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("\u8868\u793a\u4e2d\u306e\u30b9\u30ec\u30c3\u30c9: " + this.existingThreadFileNames);
        }
    }

    @Override
    public Icon execute() throws Exception {
        List<Thread> list;
        NumberFormat nf = NumberFormat.getNumberInstance();
        this.setStatus(this.board.getName() + "\u677f\u306e\u30b9\u30ec\u30c3\u30c9\u4e00\u89a7\u3092\u66f4\u65b0\u3057\u3066\u3044\u307e\u3059...");
        int count = 0;
        if (this.local) {
            list = this.updateLocal();
            this.setExistingThreadList(list);
            count = list.size();
        }
        try {
            if (this.remote) {
                list = this.updateRemote(this.board);
                for (Thread t : list) {
                    t.setNew(this.isNewThread(t));
                }
                this.appendArcives(this.board, list);
                this.processing(list);
                this.updateSystemBoard(list);
                count = list.size();
            }
            this.setStatus(this.board.getName() + "\u677f\u306e\u30b9\u30ec\u30c3\u30c9\u3092 " + nf.format(count) + " \u4ef6\u53d6\u5f97\u3057\u307e\u3057\u305f");
        }
        catch (OfflineException ex) {
            this.setStatus("\u30aa\u30d5\u30e9\u30a4\u30f3\u30e2\u30fc\u30c9\u306e\u305f\u3081\u30b9\u30ec\u30c3\u30c9\u4e00\u89a7\u306e\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u3092\u30ad\u30e3\u30f3\u30bb\u30eb\u3057\u307e\u3057\u305f");
        }
        this.loadSetting();
        long span = 259200000L;
        File file = this.board.getDefaultIconFile();
        if (!file.exists() || file.lastModified() + span < System.currentTimeMillis()) {
            return this.loadFavicon(file);
        }
        return null;
    }

    @Override
    public boolean sameAs(BoardUpdateWorker obj) {
        if (!(obj instanceof RemoteBoardUpdateWorker)) {
            return false;
        }
        RemoteBoardUpdateWorker other = (RemoteBoardUpdateWorker)obj;
        return this.board.sameAs(other.board) && this.remote == other.remote;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.board.getName() + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected List<Thread> updateLocal() throws IOException {
        Performance pfm = Performance.start();
        ArrayList<Thread> list = new ArrayList<Thread>();
        File file = this.board.getSubjectFile();
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), IO.SJIS));
            int i = 0;
            while (true) {
                IO.checkCancel();
                String line = in.readLine();
                if (line == null) break;
                Thread thread = this.board.parse(line);
                if (thread != null) {
                    thread.setNumber(list.size() + 1);
                    list.add(thread);
                }
                ++i;
            }
        }
        catch (FileNotFoundException ex) {
            IO.close(in);
            catch (Throwable throwable) {
                IO.close(in);
                throw throwable;
            }
        }
        IO.close(in);
        pfm.mark("\u30ed\u30fc\u30ab\u30eb\u304b\u3089\u30b9\u30ec\u30c3\u30c9\u4e00\u89a7\u306e\u8aad\u307f\u8fbc\u307f\u5b8c\u4e86: " + list.size() + "\u30b9\u30ec\u30c3\u30c9");
        this.appendArcives(this.board, list);
        this.processing(list);
        return list;
    }

    private void appendArcives(Board board, List<Thread> thread) {
        logger.finer("\u30a2\u30fc\u30ab\u30a4\u30d6\u3092\u691c\u7d22\u3057\u3066\u3044\u307e\u3059: " + board.getDirectory());
        HashSet<String> exists = new HashSet<String>();
        for (Thread t : thread) {
            exists.add(t.getFileName());
        }
        Service service = board.getService();
        File dir = board.getDirectory();
        if (dir.isDirectory()) {
            return;
        }
        String[] fs = dir.list();
        for (int i = 0; fs != null && i < fs.length; ++i) {
            String f = fs[i];
            if (f.endsWith(".gz")) {
                f = f.substring(0, f.length() - 3);
            }
            if (f.startsWith(".") || !f.endsWith(".dat") || exists.contains(f)) continue;
            try {
                Thread t = service.createThread(board, f, null, 0);
                t.setNumber(thread.size() + 1);
                t.setArchived(true);
                t.chargeTitle();
                thread.add(t);
                exists.add(f);
                logger.finer("\u30a2\u30fc\u30ab\u30a4\u30d6\u5316\u3055\u308c\u305f\u30b9\u30ec\u30c3\u30c9\u3092\u8aad\u307f\u8fbc\u307f\u307e\u3057\u305f: " + t);
                continue;
            }
            catch (IOException ex) {
                logger.log(Level.WARNING, "\u30a2\u30fc\u30ab\u30a4\u30d6\u5316\u3055\u308c\u305f\u30b9\u30ec\u30c3\u30c9\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f", ex);
            }
        }
    }

    private void setExistingThreadList(List<Thread> threads) {
        this.existingThreadFileNames.clear();
        for (Thread t : threads) {
            this.existingThreadFileNames.add(t.getFileName());
        }
    }

    private boolean isNewThread(Thread thread) {
        return !this.existingThreadFileNames.contains(thread.getFileName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSetting() {
        long span = 604800000L;
        File file = this.board.getSettingFile();
        if (file.exists() && file.lastModified() + span > System.currentTimeMillis()) {
            logger.finest("\u63b2\u793a\u677f\u8a2d\u5b9a\u306f\u307e\u3060\u66f4\u65b0\u3055\u308c\u307e\u305b\u3093");
            return;
        }
        URI uri = this.board.getURI();
        uri = uri.resolve("SETTING.TXT");
        try {
            file.createNewFile();
            UserAgent ua = UserAgent.getDefault();
            Connection con = ua.open(uri.toURL());
            InputStream in = con.getInputStream();
            RollbackOutputStream out = null;
            try {
                out = new RollbackOutputStream(file);
                IO.safeCopy(in, out);
                logger.finer("\u63b2\u793a\u677f\u8a2d\u5b9a\u3092\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u3057\u307e\u3057\u305f: " + uri + " (" + file.length() + "B)");
            }
            finally {
                IO.close(in);
                IO.close(out);
            }
        }
        catch (IOException ex) {
            logger.finer("\u63b2\u793a\u677f\u8a2d\u5b9a\u3092\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f: " + ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Icon loadFavicon(File file) {
        URI uri = this.board.getURI();
        uri = uri.resolve("/favicon.ico");
        try {
            file.createNewFile();
            UserAgent ua = UserAgent.getDefault();
            Connection con = ua.open(uri.toURL());
            InputStream in = con.getInputStream();
            RollbackOutputStream out = null;
            try {
                out = new RollbackOutputStream(file);
                IO.safeCopy(in, out);
                logger.finer("\u63b2\u793a\u677f\u30a2\u30a4\u30b3\u30f3\u3092\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u3057\u307e\u3057\u305f: " + uri + " (" + file.length() + "B)");
            }
            finally {
                IO.close(in);
                IO.close(out);
            }
            return new Icon(file);
        }
        catch (IOException ex) {
            logger.finer("\u30a2\u30a4\u30b3\u30f3\u3092\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f: " + ex);
            return null;
        }
    }
}

