/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch.worker;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.koiroha.jive2ch.Board;
import org.koiroha.jive2ch.Icon;
import org.koiroha.jive2ch.Thread;
import org.koiroha.jive2ch.func.LocalBoard;
import org.koiroha.jive2ch.util.Performance;
import org.koiroha.jive2ch.worker.AbortException;
import org.koiroha.jive2ch.worker.BoardUpdateWorker;

public class LocalBoardUpdateWorker
extends BoardUpdateWorker {
    private final LocalBoard board;
    private final boolean remote;
    private volatile int count = 0;

    public LocalBoardUpdateWorker(LocalBoard board, boolean remote) {
        this.board = board;
        this.remote = remote;
    }

    @Override
    public Icon execute() throws Exception {
        int i;
        List<Thread> threads = this.board.getThreads();
        if (!this.remote) {
            this.processing(threads);
            return null;
        }
        Performance pfm = Performance.start();
        this.setMaximum(-1);
        ArrayList<Board> boards = new ArrayList<Board>();
        for (Thread t : threads) {
            if (boards.contains(t.getBoard())) continue;
            boards.add(t.getBoard());
        }
        HashMap<String, ArrayList<Board>> map = new HashMap<String, ArrayList<Board>>();
        for (Board b : boards) {
            ArrayList<Board> list = (ArrayList<Board>)map.get(b.getURI().getHost());
            if (list == null) {
                list = new ArrayList<Board>();
                map.put(b.getURI().getHost(), list);
            }
            list.add(b);
        }
        ArrayList bd = new ArrayList(map.values());
        this.setProgress(0);
        this.setMinimum(0);
        this.setMaximum(boards.size());
        java.lang.Thread[] ts = new java.lang.Thread[bd.size()];
        for (i = 0; i < bd.size(); ++i) {
            final List bs = (List)bd.get(i);
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    try {
                        LocalBoardUpdateWorker.this.update(bs);
                    }
                    catch (AbortException abortException) {
                        // empty catch block
                    }
                }
            };
            ts[i] = new java.lang.Thread(r, "PARUPDT " + i);
            ts[i].setDaemon(true);
            ts[i].start();
        }
        try {
            for (i = 0; i < ts.length; ++i) {
                ts[i].join();
            }
        }
        catch (InterruptedException ex) {
            for (int i2 = 0; i2 < ts.length; ++i2) {
                ts[i2].interrupt();
            }
            throw new AbortException();
        }
        this.setProgress(0);
        pfm.mark("\u5168" + boards.size() + "\u677f\u306e\u30b9\u30ec\u30c3\u30c9\u4e00\u89a7\u66f4\u65b0\u5b8c\u4e86");
        this.setStatus("\u30b9\u30ec\u30c3\u30c9\u4e00\u89a7\u3092\u66f4\u65b0\u3057\u307e\u3057\u305f");
        return null;
    }

    @Override
    public boolean sameAs(BoardUpdateWorker obj) {
        if (!(obj instanceof LocalBoardUpdateWorker)) {
            return false;
        }
        LocalBoardUpdateWorker other = (LocalBoardUpdateWorker)obj;
        return this.board.sameAs(other.board) && this.remote == other.remote;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.board.getName() + "]";
    }

    private void update(List<Board> boards) {
        for (Board b : boards) {
            try {
                this.setStatus(b.getName() + "\u677f\u306e\u30b9\u30ec\u30c3\u30c9\u4e00\u89a7\u3092\u66f4\u65b0\u3057\u3066\u3044\u307e\u3059...");
                List<Thread> list = this.updateRemote(b, false);
                if (java.lang.Thread.interrupted()) {
                    return;
                }
                this.processing(list);
                ++this.count;
                this.setProgress(this.count);
                this.updateSystemBoard(list);
            }
            catch (IOException ex) {
                this.setStatus(b.getName() + "\u306e\u30b9\u30ec\u30c3\u30c9\u4e00\u89a7\u306e\u66f4\u65b0\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
            }
        }
    }
}

