/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch.worker;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.koiroha.jive2ch.worker.Worker;

public final class Launcher {
    private static final Logger logger = Logger.getLogger(Launcher.class.getName());
    private static final Map<Class<?>, Launcher> LAUNCHER = Collections.synchronizedMap(new HashMap());
    private final BlockingQueue<Runnable> queue = new ArrayBlockingQueue<Runnable>(1);
    private final ThreadPoolExecutor pool;

    private Launcher(int poolSize) {
        this.pool = new ThreadPoolExecutor(poolSize, poolSize, 5L, TimeUnit.SECONDS, this.queue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void kick(Worker<?, ?> worker) {
        BlockingQueue<Runnable> blockingQueue = this.queue;
        synchronized (blockingQueue) {
            if (this.queue.size() > 0) {
                logger.finer("\u5f85\u6a5f\u4e2d\u306e " + this.queue.size() + " \u51e6\u7406\u3092\u9664\u53bb");
            }
            this.queue.clear();
            this.pool.execute(worker);
        }
    }

    public static synchronized void start(Worker<?, ?> worker) {
        Launcher launcher = LAUNCHER.get(worker.getClass());
        if (launcher == null) {
            launcher = new Launcher(1);
            LAUNCHER.put(worker.getClass(), launcher);
        }
        launcher.kick(worker);
    }

    public static void dispose() {
        for (Launcher l : LAUNCHER.values()) {
            l.pool.shutdown();
        }
    }
}

