/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch.worker;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.text.DateFormat;
import java.util.Date;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import org.koiroha.jive2ch.Kakiko;
import org.koiroha.jive2ch.Thread;
import org.koiroha.jive2ch.util.IO;
import org.koiroha.jive2ch.worker.Worker;
import org.xml.sax.SAXException;

public class ContributeWorker
extends Worker<Object, Boolean> {
    private static final Logger logger = Logger.getLogger(ContributeWorker.class.getName());
    private final Thread thread;
    private final Kakiko kakiko;

    public ContributeWorker(Thread thread, Kakiko kakiko) {
        this.thread = thread;
        this.kakiko = kakiko;
    }

    @Override
    public Boolean execute() throws Exception {
        logger.fine("\u66f8\u304d\u8fbc\u307f\u3092\u884c\u3063\u3066\u3044\u307e\u3059: ");
        if (!this.thread.getBoard().getService().contribute(this.thread, this.kakiko)) {
            return false;
        }
        this.saveLog();
        this.thread.getBoard().getCategory().getJive2ch().getRecentWriteBoard().addThread(this.thread);
        this.setStatus("\u66f8\u304d\u8fbc\u307f\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f: " + this.thread.getTitle());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveLog() throws IOException, SAXException, ParserConfigurationException {
        File file = this.thread.getBoard().getCategory().getJive2ch().repository.kakikomiFile;
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(file, true);
            os.getChannel().lock();
            PrintWriter out = new PrintWriter(os);
            URI uri = this.thread.getBoard().getService().getBrowserURI(this.thread);
            DateFormat df = DateFormat.getDateTimeInstance();
            Date date = new Date();
            out.println("--------------------------------------------------------");
            out.println("\u65e5\u6642: " + df.format(date));
            out.println("URL: " + uri);
            out.println("\u30bf\u30a4\u30c8\u30eb: " + this.thread.getTitle());
            out.println("\u540d\u524d: " + this.kakiko.getName());
            out.println("\u30e1\u30fc\u30eb: " + this.kakiko.getMail());
            out.println();
            out.println(this.kakiko.getContent());
            out.flush();
        }
        catch (Throwable throwable) {
            IO.close(os);
            throw throwable;
        }
        IO.close(os);
        logger.finer("\u66f8\u304d\u8fbc\u307f\u30ed\u30b0\u3092\u4fdd\u5b58\u3057\u307e\u3057\u305f");
    }
}

