/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch.worker;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.koiroha.jive2ch.Board;
import org.koiroha.jive2ch.Icon;
import org.koiroha.jive2ch.Jive2ch;
import org.koiroha.jive2ch.Thread;
import org.koiroha.jive2ch.client.Connection;
import org.koiroha.jive2ch.client.UserAgent;
import org.koiroha.jive2ch.util.IO;
import org.koiroha.jive2ch.util.Performance;
import org.koiroha.jive2ch.util.RollbackOutputStream;
import org.koiroha.jive2ch.util.TeeInputStream;
import org.koiroha.jive2ch.worker.Worker;

public abstract class BoardUpdateWorker
extends Worker<Thread, Icon> {
    private static final Logger logger = Logger.getLogger(BoardUpdateWorker.class.getName());

    public abstract boolean sameAs(BoardUpdateWorker var1);

    protected List<Thread> updateRemote(Board board) throws IOException {
        return this.updateRemote(board, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Thread> updateRemote(Board board, boolean bypass) throws IOException {
        Performance pfm = Performance.start();
        ArrayList<Thread> list = new ArrayList<Thread>();
        int count = 0;
        InputStream is = this.getSubjectInputStream(board, bypass);
        RollbackOutputStream out = null;
        boolean success = false;
        try {
            File localFile = this.getLocalSubjectFile(board);
            if (localFile != null) {
                out = new RollbackOutputStream(localFile);
                is = new TeeInputStream(is, out);
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(is, IO.SJIS));
            int i = 0;
            while (true) {
                IO.checkCancel();
                String line = in.readLine();
                if (line == null) break;
                logger.finest(line);
                Thread t = board.parse(line);
                if (t != null) {
                    t.setNumber(count + 1);
                    list.add(t);
                    ++count;
                } else {
                    logger.fine("\u672a\u5bfe\u5fdc\u306e\u884c\u3092\u691c\u51fa: " + line);
                }
                ++i;
            }
            success = true;
        }
        finally {
            if (!success && out != null) {
                out.rollback();
            }
            IO.close(is);
            IO.close(out);
        }
        pfm.mark("\u30b9\u30ec\u30c3\u30c9\u4e00\u89a7\u3092\u66f4\u65b0\u3057\u307e\u3057\u305f: " + list.size() + "\u30b9\u30ec\u30c3\u30c9");
        return list;
    }

    protected void updateSystemBoard(List<Thread> threads) {
        Jive2ch app = Jive2ch.getDefault();
        for (int i = 0; i < threads.size(); ++i) {
            app.getRecentReadBoard().update(threads.get(i));
            app.getRecentWriteBoard().update(threads.get(i));
        }
    }

    private InputStream getSubjectInputStream(Board board, boolean bypass) throws IOException {
        URL url = board.getURI().resolve("subject.txt").toURL();
        UserAgent ua = UserAgent.getDefault();
        Connection con = ua.open(url);
        if (bypass) {
            this.bypassProgress(con);
        }
        return con.getInputStream();
    }

    private File getLocalSubjectFile(Board board) {
        File dir = board.getDirectory();
        return new File(dir, "subject.txt");
    }
}

