/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch.worker;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.koiroha.jive2ch.Board;
import org.koiroha.jive2ch.Category;
import org.koiroha.jive2ch.Icon;
import org.koiroha.jive2ch.client.Connection;
import org.koiroha.jive2ch.client.OfflineException;
import org.koiroha.jive2ch.client.UserAgent;
import org.koiroha.jive2ch.util.IO;
import org.koiroha.jive2ch.util.RollbackOutputStream;
import org.koiroha.jive2ch.worker.Worker;

public class BoardIconUpdateWorker
extends Worker<Board, Object> {
    private static final Logger logger = Logger.getLogger(BoardIconUpdateWorker.class.getName());
    private final List<Category> category;
    private final boolean remote;

    public BoardIconUpdateWorker(List<Category> category, boolean remote) {
        this.category = category;
        this.remote = remote;
    }

    @Override
    public Integer execute() {
        if (this.remote) {
            return this.remoteDownload();
        }
        return this.localUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private int remoteDownload() {
        logger.fine("\u63b2\u793a\u677f\u306e\u30a2\u30a4\u30b3\u30f3\u3092\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u3057\u3066\u3044\u307e\u3059");
        Map<File, List<Board>> fileBoardMap = this.getFileBoardMap();
        logger.finer(fileBoardMap.size() + " \u500b\u306e\u30a2\u30a4\u30b3\u30f3\u3092\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u3057\u307e\u3059");
        UserAgent ua = UserAgent.getDefault();
        for (File iconFile : fileBoardMap.keySet()) {
            List<Board> boards;
            block10: {
                boards = fileBoardMap.get(iconFile);
                URI uri = boards.get(0).getURI().resolve("/favicon.ico");
                InputStream in = null;
                BufferedOutputStream out = null;
                try {
                    Connection con = ua.open(uri.toURL());
                    this.bypassProgress(con);
                    IO.mkdir(iconFile.getParentFile());
                    in = con.getInputStream();
                    out = new BufferedOutputStream(new RollbackOutputStream(iconFile));
                    IO.copy(in, out);
                    logger.finest("\u30a2\u30a4\u30b3\u30f3\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u5b8c\u4e86: " + uri);
                    IO.close(in);
                }
                catch (OfflineException ex) {
                    logger.finer("\u30aa\u30d5\u30e9\u30a4\u30f3\u30e2\u30fc\u30c9\u306e\u305f\u3081\u30a2\u30a4\u30b3\u30f3\u3092\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u51fa\u6765\u307e\u305b\u3093");
                    break block10;
                }
                catch (IOException ex2) {
                    logger.log(Level.FINE, "\u30a2\u30a4\u30b3\u30f3\u306e\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f: " + uri, ex2);
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    IO.close(in);
                    IO.close(out);
                    break block10;
                }
                finally {
                    IO.close(in);
                    IO.close(out);
                }
                IO.close(out);
            }
            Icon icon = new Icon(iconFile);
            if (icon.getImage() != null) {
                for (Board b : boards) {
                    b.resetIcon();
                }
                this.processing(boards);
                continue;
            }
            iconFile.delete();
            if (iconFile.getParentFile().list().length != 0) continue;
            iconFile.getParentFile().delete();
        }
        return 0;
    }

    private int localUpdate() {
        logger.fine("\u30ed\u30fc\u30ab\u30eb\u306e\u63b2\u793a\u677f\u30a2\u30a4\u30b3\u30f3\u3092\u30ed\u30fc\u30c9\u3057\u3066\u3044\u307e\u3059");
        Map<File, List<Board>> fileBoardMap = this.getFileBoardMap();
        for (File iconFile : fileBoardMap.keySet()) {
            List<Board> boards = fileBoardMap.get(iconFile);
            Icon icon = new Icon(iconFile);
            if (icon.getImage() == null) continue;
            for (Board b : boards) {
                b.resetIcon();
            }
            this.processing(boards);
        }
        return 0;
    }

    private Map<File, List<Board>> getFileBoardMap() {
        HashMap<File, List<Board>> fileBoardMap = new HashMap<File, List<Board>>();
        for (Category c : this.category) {
            for (Board b : c.getBoards()) {
                ArrayList<Board> list = (ArrayList<Board>)fileBoardMap.get(b.getDefaultIconFile());
                if (list == null) {
                    list = new ArrayList<Board>();
                    fileBoardMap.put(b.getDefaultIconFile(), list);
                }
                list.add(b);
            }
        }
        return fileBoardMap;
    }
}

