/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathException;
import javax.xml.xpath.XPathFactory;
import org.koiroha.jive2ch.util.IO;
import org.koiroha.xml.Xml;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;

public final class XML {
    private XML() {
    }

    public static Document newDocument() {
        try {
            DocumentBuilderFactory f = DocumentBuilderFactory.newInstance();
            DocumentBuilder b = f.newDocumentBuilder();
            return b.newDocument();
        }
        catch (ParserConfigurationException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public static Document read(InputStream in) throws IOException {
        InputSource is = new InputSource(in);
        return XML.read(is);
    }

    public static Document read(InputSource is) throws IOException {
        return XML.read(is, false);
    }

    public static Document read(InputSource is, boolean ns) throws IOException {
        Document doc = null;
        try {
            DocumentBuilderFactory f = DocumentBuilderFactory.newInstance();
            f.setNamespaceAware(ns);
            DocumentBuilder b = f.newDocumentBuilder();
            doc = b.parse(is);
        }
        catch (SAXException ex) {
            throw IO.wrapThrow(ex);
        }
        catch (ParserConfigurationException ex) {
            throw new IllegalStateException(ex);
        }
        return doc;
    }

    public static void write(Node node, OutputStream out) throws IOException {
        XML.write(node, new StreamResult(out));
    }

    public static void write(Node node, Writer out) throws IOException {
        XML.write(node, new StreamResult(out));
    }

    public static void write(Node node, Result rs) throws IOException {
        try {
            TransformerFactory f = TransformerFactory.newInstance();
            Transformer t = f.newTransformer();
            t.transform(new DOMSource(node), rs);
        }
        catch (TransformerException ex) {
            throw IO.wrapThrow(ex);
        }
    }

    public static String toString(Node node) {
        StringWriter out = new StringWriter();
        try {
            XML.write(node, out);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        return out.toString();
    }

    public static Object evaluate(String expr, Node node, QName qname) {
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            return xpath.evaluate(expr, node, qname);
        }
        catch (XPathException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public static String evalString(String expr, Node node) {
        return (String)XML.evaluate(expr, node, XPathConstants.STRING);
    }

    public static List<Node> evalList(String expr, Node node) {
        ArrayList<Node> list = new ArrayList<Node>();
        NodeList nl = (NodeList)XML.evaluate(expr, node, XPathConstants.NODESET);
        for (int i = 0; i < nl.getLength(); ++i) {
            list.add(nl.item(i));
        }
        return list;
    }

    public static class StreamFilterHandler
    extends DefaultHandler2 {
        protected final Writer out;

        public StreamFilterHandler(Writer out) {
            this.out = out;
        }

        @Override
        public void startDocument() throws SAXException {
            try {
                this.out.write("<?xml version=\"1.0\"?>\n");
            }
            catch (IOException ex) {
                throw new SAXException(ex);
            }
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attr) throws SAXException {
            try {
                this.out.write("<");
                this.out.write(name);
                for (int i = 0; i < attr.getLength(); ++i) {
                    String qName = attr.getQName(i);
                    String value = attr.getValue(i);
                    this.out.write(32);
                    this.out.write(qName);
                    this.out.write("=\"");
                    Xml.escape(this.out, value);
                    this.out.write(34);
                }
                this.out.write(">");
            }
            catch (IOException ex) {
                throw new SAXException(ex);
            }
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            try {
                this.out.write("</");
                this.out.write(name);
                this.out.write(">");
            }
            catch (IOException ex) {
                throw new SAXException(ex);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            try {
                Xml.escape(this.out, new String(ch, start, length));
            }
            catch (IOException ex) {
                throw new SAXException(ex);
            }
        }

        @Override
        public void comment(char[] ch, int start, int length) throws SAXException {
            try {
                this.out.write("<!--");
                this.out.write(ch, start, length);
                this.out.write("-->");
            }
            catch (IOException ex) {
                throw new SAXException(ex);
            }
        }
    }
}

