/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch.util;

import java.util.Comparator;
import java.util.Date;
import org.koiroha.jive2ch.Thread;

public final class ThreadSorter {
    public static final Sorter[] SORTER = new Sorter[]{new Sorter(){

        @Override
        public int compare(Thread t1, Thread t2) {
            if (t1.isNew() && !t2.isNew()) {
                return -1;
            }
            if (!t1.isNew() && t2.isNew()) {
                return 1;
            }
            if (t1.isShinchaku() && !t2.isShinchaku()) {
                return -1;
            }
            if (!t1.isShinchaku() && t2.isShinchaku()) {
                return 1;
            }
            if (t1.isKidoku() && !t2.isKidoku()) {
                return -1;
            }
            if (!t1.isKidoku() && t2.isKidoku()) {
                return 1;
            }
            return ThreadSorter.compareDefault(t1, t2);
        }
    }, new Sorter(){

        @Override
        public int compare(Thread t1, Thread t2) {
            return ThreadSorter.numCompare(t1.getNumber(), t2.getNumber());
        }
    }, new Sorter(){

        @Override
        public int compare(Thread t1, Thread t2) {
            int cmp = t1.getTitle().compareTo(t2.getTitle());
            if (cmp != 0) {
                return cmp;
            }
            return ThreadSorter.compareDefault(t1, t2);
        }
    }, new Sorter(){

        @Override
        public int compare(Thread t1, Thread t2) {
            int cmp = ThreadSorter.numCompare(t1.getResponseCount(), t2.getResponseCount());
            if (cmp != 0) {
                return cmp;
            }
            return ThreadSorter.compareDefault(t1, t2);
        }
    }, new Sorter(){

        @Override
        public int compare(Thread t1, Thread t2) {
            int cmp = ThreadSorter.numCompare(t1.getAcquiredCount(), t2.getAcquiredCount());
            if (cmp != 0) {
                return cmp;
            }
            return ThreadSorter.compareDefault(t1, t2);
        }
    }, new Sorter(){

        @Override
        public int compare(Thread t1, Thread t2) {
            int cmp = ThreadSorter.numCompare(t1.getEnergy(), t2.getEnergy());
            if (cmp != 0) {
                return cmp;
            }
            return ThreadSorter.compareDefault(t1, t2);
        }
    }, new Sorter(){

        @Override
        public int compare(Thread t1, Thread t2) {
            int cmp = ThreadSorter.dateCompare(t1.getRecentAccess(), t2.getRecentAccess());
            if (cmp != 0) {
                return cmp;
            }
            return ThreadSorter.compareDefault(t1, t2);
        }
    }, new Sorter(){

        @Override
        public int compare(Thread t1, Thread t2) {
            int cmp = ThreadSorter.dateCompare(t1.getContributeDate(), t2.getContributeDate());
            if (cmp != 0) {
                return cmp;
            }
            return ThreadSorter.compareDefault(t1, t2);
        }
    }, new Sorter(){

        @Override
        public int compare(Thread t1, Thread t2) {
            int cmp = ThreadSorter.dateCompare(t1.getCreated(), t2.getCreated());
            if (cmp != 0) {
                return cmp;
            }
            return ThreadSorter.compareDefault(t1, t2);
        }
    }, new Sorter(){

        @Override
        public int compare(Thread t1, Thread t2) {
            int cmp = t1.getBrowserURI().compareTo(t2.getBrowserURI());
            if (cmp != 0) {
                return cmp;
            }
            return ThreadSorter.compareDefault(t1, t2);
        }
    }};

    private ThreadSorter() {
    }

    private static int compareDefault(Thread t1, Thread t2) {
        return ThreadSorter.numCompare(t1.getNumber(), t2.getNumber());
    }

    private static int numCompare(long num1, long num2) {
        if (num1 < num2) {
            return -1;
        }
        if (num1 > num2) {
            return 1;
        }
        return 0;
    }

    private static int numCompare(double num1, double num2) {
        if (num1 < num2) {
            return -1;
        }
        if (num1 > num2) {
            return 1;
        }
        return 0;
    }

    private static int dateCompare(Date d1, Date d2) {
        if (d1 == null && d2 == null) {
            return 0;
        }
        if (d1 == null) {
            return 1;
        }
        if (d2 == null) {
            return -1;
        }
        return ThreadSorter.numCompare(d1.getTime(), d2.getTime());
    }

    public static interface Sorter
    extends Comparator<Thread> {
    }
}

