/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch.util;

import java.nio.charset.CharsetEncoder;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.koiroha.jive2ch.Response;
import org.koiroha.jive2ch.util.IO;
import org.koiroha.xml.Html;

public final class TextUtil {
    private static final Logger logger = Logger.getLogger(TextUtil.class.getName());
    public static final String PATTERN_URL_REGEX = "(h?ttps?|ftp)://[\\p{Alnum}\\p{Punct}]{1,}";
    public static final Pattern PATTERN_URL = Pattern.compile("(h?ttps?|ftp)://[\\p{Alnum}\\p{Punct}]{1,}");
    public static final String PATTERN_POINTER_REGEX = "[>\uff1e\u226b]{1,2}([\\d\uff10-\uff19]{1,4}((-[\\d\uff10-\uff19]{1,4})|(,[\\d\uff10-\uff19]{1,4}))*)";
    public static final Pattern PATTERN_POINTER = Pattern.compile("[>\uff1e\u226b]{1,2}([\\d\uff10-\uff19]{1,4}((-[\\d\uff10-\uff19]{1,4})|(,[\\d\uff10-\uff19]{1,4}))*)");
    private static final char[] KANA_ZEN = new char[]{'\u30a1', '\u30a2', '\u30a3', '\u30a4', '\u30a5', '\u30a6', '\u30a7', '\u30a8', '\u30a9', '\u30aa', '\u30ab', '\u30ac', '\u30ad', '\u30ae', '\u30af', '\u30b0', '\u30b1', '\u30b2', '\u30b3', '\u30b4', '\u30b5', '\u30b6', '\u30b7', '\u30b8', '\u30b9', '\u30ba', '\u30bb', '\u30bc', '\u30bd', '\u30be', '\u30bf', '\u30c0', '\u30c1', '\u30c2', '\u30c3', '\u30c4', '\u30c5', '\u30c6', '\u30c7', '\u30c8', '\u30c9', '\u30ca', '\u30cb', '\u30cc', '\u30cd', '\u30ce', '\u30cf', '\u30d0', '\u30d1', '\u30d2', '\u30d3', '\u30d4', '\u30d5', '\u30d6', '\u30d7', '\u30d8', '\u30d9', '\u30da', '\u30db', '\u30dc', '\u30dd', '\u30de', '\u30df', '\u30e0', '\u30e1', '\u30e2', '\u30e3', '\u30e4', '\u30e5', '\u30e6', '\u30e7', '\u30e8', '\u30e9', '\u30ea', '\u30eb', '\u30ec', '\u30ed', '\u30ee', '\u30ef', '\u30f0', '\u30f1', '\u30f2', '\u30f3', '\u30f4', '\u30f5', '\u30f6', '\u30f7', '\u30f8', '\u30f9', '\u30fa', '\u30fb', '\u30fc'};
    private static final char[] KANA_HAN = new char[]{'\uff71', '\uff71', '\uff72', '\uff72', '\uff73', '\uff73', '\uff74', '\uff74', '\uff75', '\uff75', '\uff76', '\uff76', '\uff77', '\uff77', '\uff78', '\uff78', '\uff79', '\uff79', '\uff7a', '\uff7a', '\uff7b', '\uff7b', '\uff7c', '\uff7c', '\uff7d', '\uff7d', '\uff7e', '\uff7e', '\uff7f', '\uff7f', '\uff80', '\uff80', '\uff81', '\uff81', '\uff82', '\uff82', '\uff82', '\uff83', '\uff83', '\uff84', '\uff84', '\uff85', '\uff86', '\uff87', '\uff88', '\uff89', '\uff8a', '\uff8a', '\uff8a', '\uff8b', '\uff8b', '\uff8b', '\uff8c', '\uff8c', '\uff8c', '\uff8d', '\uff8d', '\uff8d', '\uff8e', '\uff8e', '\uff8e', '\uff8f', '\uff90', '\uff91', '\uff92', '\uff93', '\uff94', '\uff94', '\uff95', '\uff95', '\uff96', '\uff96', '\uff97', '\uff98', '\uff99', '\uff9a', '\uff9b', '\uff9c', '\uff9c', '\uff72', '\uff74', '\uff66', '\uff9d', '\uff73', '\uff76', '\uff79', '\uff9c', '\uff72', '\uff74', '\uff66', '\uff65', '\uff70'};

    private TextUtil() {
    }

    public static String normalizeToContribute(String text, Set<Character> invalid, boolean unicode) {
        CharsetEncoder encoder = IO.SJIS.newEncoder();
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch == '\u301c') {
                ch = '\uff5e';
            }
            if (encoder.canEncode(ch)) {
                if (ch != ' ' || buffer.length() == 0 || buffer.charAt(buffer.length() - 1) != ' ') {
                    buffer.append(ch);
                    continue;
                }
                buffer.append("&nbsp;");
                continue;
            }
            String str = Html.getEntityReference(ch);
            if (str.charAt(1) == '#' && !unicode) {
                buffer.append(ch);
                invalid.add(Character.valueOf(ch));
                continue;
            }
            buffer.append(str);
        }
        if (logger.isLoggable(Level.FINEST) && !text.equals(buffer.toString())) {
            logger.finest("SJIS\u672a\u5bfe\u5fdc\u6587\u5b57\u5909\u63db: " + text + " -> " + buffer);
        }
        return buffer.toString();
    }

    public static final String toSearchString(String text) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            int ch = TextUtil.toSearch(text.charAt(i));
            if (ch < 0) continue;
            buffer.append((char)ch);
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("\u691c\u7d22\u7528\u6587\u5b57\u5217\u5909\u63db: " + text + " -> " + buffer);
        }
        return buffer.toString();
    }

    private static int toSearch(char ch) {
        if (Character.isWhitespace(ch)) {
            return -1;
        }
        if (ch >= '\uff01' && ch <= '\uff5e') {
            ch = (char)(ch - 65281 + 33);
        }
        if (ch >= 'a' && ch <= 'z') {
            ch = (char)(ch - 97 + 65);
        }
        if (ch >= '!' && ch <= '~') {
            return ch;
        }
        if (ch >= '\u3041' && ch <= '\u3096') {
            ch = (char)(ch - 12353 + 12449);
        } else {
            switch (ch) {
                case '\u309d': {
                    ch = (char)12541;
                    break;
                }
                case '\u309e': {
                    ch = (char)12542;
                    break;
                }
            }
        }
        if (ch >= KANA_ZEN[0] && ch <= KANA_ZEN[KANA_ZEN.length - 1]) {
            return KANA_HAN[ch - KANA_ZEN[0]];
        }
        switch (ch) {
            case '\u3002': {
                return 65377;
            }
            case '\u300c': {
                return 65378;
            }
            case '\u300d': {
                return 65379;
            }
            case '\u3001': {
                return 65380;
            }
            case '\u309b': {
                return -1;
            }
            case '\u309c': {
                return -1;
            }
        }
        return ch;
    }

    public static boolean isAsciiArt(Response res) {
        String content = res.getPlainText();
        int uch = 0;
        Matcher m = PATTERN_URL.matcher(content);
        StringBuilder buffer = new StringBuilder();
        int begin = 0;
        while (m.find()) {
            uch += m.group(0).length();
            buffer.append(content.substring(begin, m.start()));
            begin = m.end();
        }
        buffer.append(content.substring(begin));
        content = buffer.toString();
        int zk = 0;
        int hk = 0;
        int nl = 0;
        int ot = uch;
        for (int i = 0; i < content.length() && i < 500; ++i) {
            char ch = content.charAt(i);
            if (TextUtil.isZenkakuKigo(ch)) {
                ++zk;
                continue;
            }
            if (TextUtil.isHankakuKigo(ch)) {
                ++hk;
                continue;
            }
            if (ch == '\n' || ch == '\r') {
                ++nl;
                continue;
            }
            ++ot;
        }
        if (ot < 10 || nl < 2) {
            return false;
        }
        double kigoRate = ((double)zk * 2.0 + (double)hk) / ((double)ot * 3.0);
        return kigoRate > 0.2;
    }

    private static boolean isZenkakuKigo(char ch) {
        return ch >= '\u00a0' && ch <= '\u3030';
    }

    private static boolean isHankakuKigo(char ch) {
        return ch >= '!' && ch <= '@' || ch >= '[' && ch <= '`' || ch >= '{' && ch <= '~';
    }
}

