/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;
import org.koiroha.jive2ch.util.IO;
import org.koiroha.jive2ch.util.RollbackOutputStream;

public class TeeInputStream
extends FilterInputStream {
    private static final Logger logger = Logger.getLogger(TeeInputStream.class.getName());
    private final OutputStream out;
    private boolean error = false;

    public TeeInputStream(InputStream in, OutputStream out) {
        super(in);
        this.out = out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        int n;
        boolean success = false;
        try {
            int ch = super.read();
            if (ch >= 0) {
                this.out.write(ch);
            }
            success = true;
            n = ch;
            this.error = this.error || !success;
        }
        catch (Throwable throwable) {
            this.error = this.error || !success;
            throw throwable;
        }
        return n;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int n;
        boolean success = false;
        try {
            int length = super.read(b, off, len);
            if (length > 0) {
                this.out.write(b, off, length);
            }
            success = true;
            n = length;
            this.error = this.error || !success;
        }
        catch (Throwable throwable) {
            this.error = this.error || !success;
            throw throwable;
        }
        return n;
    }

    @Override
    public void close() throws IOException {
        if (this.error) {
            logger.finer("\u30b9\u30c8\u30ea\u30fc\u30e0\u304b\u3089\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u3066\u3044\u307e\u3059");
            if (this.out instanceof RollbackOutputStream) {
                ((RollbackOutputStream)this.out).rollback();
            } else {
                logger.warning("\u51fa\u529b\u30b9\u30c8\u30ea\u30fc\u30e0\u304c\u30ed\u30fc\u30eb\u30d0\u30c3\u30af\u53ef\u80fd\u3067\u306f\u3042\u308a\u307e\u305b\u3093; \u30c7\u30fc\u30bf\u306f\u4e0d\u5b8c\u5168\u306a\u72b6\u614b\u3067\u66f8\u304d\u8fbc\u307e\u308c\u3066\u3044\u307e\u3059");
            }
        }
        IO.close(this.out);
        super.close();
    }
}

