/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.logging.Logger;
import org.koiroha.jive2ch.util.IO;

public class RollbackOutputStream
extends FilterOutputStream {
    private static final Logger logger = Logger.getLogger(RollbackOutputStream.class.getName());
    private final File file;
    private final File temp;
    private boolean rollback = false;
    private boolean closed = false;

    public RollbackOutputStream(File file) throws IOException {
        this(file, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RollbackOutputStream(File file, boolean append) throws IOException {
        super(null);
        if (file.isDirectory()) {
            throw new IOException(file + " \u306f\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3067\u3059");
        }
        this.file = file;
        this.temp = IO.mktemp(file);
        FileOutputStream os = null;
        boolean success = false;
        try {
            os = new FileOutputStream(this.temp);
            if (append) {
                FileInputStream is = null;
                try {
                    long length = file.length();
                    is = new FileInputStream(file);
                    FileChannel ifc = is.getChannel();
                    ifc.lock(0L, Integer.MAX_VALUE, true);
                    ifc.transferTo(0L, length, os.getChannel());
                    logger.finer("\u8ffd\u52a0\u30e2\u30fc\u30c9: " + length + "B \u3092\u30b3\u30d4\u30fc");
                }
                catch (FileNotFoundException ex) {
                    try {
                        logger.finest("\u8ffd\u52a0\u30e2\u30fc\u30c9\u3067\u3059\u304c\u5bfe\u8c61\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u307e\u305b\u3093; \u65b0\u898f\u30d5\u30a1\u30a4\u30eb\u3067\u3059");
                    }
                    catch (Throwable throwable) {
                        IO.close(is);
                        throw throwable;
                    }
                    IO.close(is);
                }
                IO.close(is);
            }
            success = true;
        }
        finally {
            if (!success) {
                IO.close(os);
                os = null;
            }
        }
        this.out = new BufferedOutputStream(os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int b) throws IOException {
        boolean success = false;
        try {
            this.out.write(b);
            success = true;
            this.rollback = this.rollback || !success;
        }
        catch (Throwable throwable) {
            this.rollback = this.rollback || !success;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b) throws IOException {
        boolean success = false;
        try {
            this.out.write(b);
            success = true;
            this.rollback = this.rollback || !success;
        }
        catch (Throwable throwable) {
            this.rollback = this.rollback || !success;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        boolean success = false;
        try {
            this.out.write(b, off, len);
            success = true;
            this.rollback = this.rollback || !success;
        }
        catch (Throwable throwable) {
            this.rollback = this.rollback || !success;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        boolean success = false;
        try {
            this.out.close();
            success = true;
        }
        finally {
            if (this.rollback || !success) {
                IO.delete(this.temp);
                logger.warning("\u30b8\u30e3\u30fc\u30ca\u30eb\u30d5\u30a1\u30a4\u30eb\u3092\u524a\u9664\u3057\u307e\u3057\u305f: " + this.temp.getName());
                return;
            }
        }
        if (!this.rollback) {
            IO.rename(this.temp, this.file);
        }
    }

    public void rollback() {
        if (!this.closed) {
            logger.warning("\u30ed\u30fc\u30eb\u30d0\u30c3\u30af\u51e6\u7406\u3092\u884c\u3063\u3066\u3044\u307e\u3059...: " + this.file.getName());
            this.rollback = true;
            IO.close(this);
        }
    }
}

