/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.koiroha.jive2ch.util.ProgressListener;

public class ProgressSupport {
    private final List<ProgressListener> listener = new ArrayList<ProgressListener>();

    public ProgressSupport(Object source) {
    }

    public void addProgressListener(ProgressListener l) {
        this.listener.add(l);
    }

    public void removeProgressListener(ProgressListener l) {
        for (int i = 0; i < this.listener.size(); ++i) {
            if (this.listener.get(i) != l) continue;
            this.listener.remove(i);
            return;
        }
    }

    public void fireSetProgress(long value) {
        for (ProgressListener l : this.listener) {
            l.setProgress(value);
        }
    }

    public void fireSetMaximum(long value) {
        for (ProgressListener l : this.listener) {
            l.setMaximum(value);
        }
    }

    public InputStream wrap(InputStream in, long max, long cur) {
        return new IS(in, max, cur);
    }

    private class IS
    extends FilterInputStream {
        private long current;

        public IS(InputStream in, long max, long current) {
            super(in);
            this.current = 0L;
            ProgressSupport.this.fireSetMaximum(max);
            ProgressSupport.this.fireSetProgress(current);
            this.current = current;
        }

        @Override
        public int read() throws IOException {
            ++this.current;
            ProgressSupport.this.fireSetProgress(this.current);
            return super.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int offset, int length) throws IOException {
            int len = super.read(b, offset, length);
            this.current += (long)len;
            ProgressSupport.this.fireSetProgress(this.current);
            return len;
        }
    }
}

