/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.koiroha.jive2ch.util.Selector;

public final class Pointer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(Pointer.class.getName());
    public static final Pointer EMPTY = Pointer.compile("");
    public static final Pointer ALL = Pointer.compile("1-2147483647");
    private final List<Elem> pointer;

    private Pointer(List<Elem> elems) {
        this.pointer = elems;
    }

    public Selector newSelector(final int total) {
        return new Selector(){
            private final List<Elem> elems;
            {
                this.elems = Pointer.this.share(Pointer.this.pointer, total);
            }

            @Override
            public int count() {
                int count = 0;
                for (Elem e : this.elems) {
                    assert (!(e instanceof Last));
                    count += e.count(total);
                }
                return count;
            }

            @Override
            public <T> List<T> pickup(List<T> list, List<T> result) {
                for (int i = 0; i < this.elems.size(); ++i) {
                    Elem e = this.elems.get(i);
                    e.pickup(list, result);
                }
                return result;
            }

            @Override
            public boolean contains(int num) {
                for (int i = 0; i < this.elems.size(); ++i) {
                    Elem e = this.elems.get(i);
                    if (!e.contains(num)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    private List<Elem> share(List<Elem> elem, int total) {
        if (elem.size() < 1 || !(elem.get(elem.size() - 1) instanceof Last)) {
            return elem;
        }
        if (total == 0) {
            ArrayList<Elem> copy = new ArrayList<Elem>(elem);
            if (copy.size() > 0) {
                copy.remove(copy.size() - 1);
            }
            return copy;
        }
        Last last = (Last)elem.get(elem.size() - 1);
        int begin = Math.max(1, total - last.num + 1);
        int end = total;
        Span span = new Span(begin, end);
        ArrayList<Elem> copy = new ArrayList<Elem>(elem);
        copy.set(copy.size() - 1, span);
        Pointer.marge(copy);
        return copy;
    }

    public String toPattern() {
        StringBuilder buffer = new StringBuilder();
        for (Elem e : this.pointer) {
            if (buffer.length() > 0) {
                buffer.append(',');
            }
            buffer.append(e.toString());
        }
        return buffer.toString();
    }

    public <T> List<T> pickup(List<T> list) {
        ArrayList result = new ArrayList();
        return this.newSelector(list.size()).pickup(list, result);
    }

    public boolean contains(int total, int num) {
        return this.newSelector(total).contains(num);
    }

    public Pointer add(int num) {
        String str = this.toPattern();
        str = str.length() == 0 ? String.valueOf(num) : str + "," + num;
        return Pointer.compile(str);
    }

    public Pointer minus(int num) {
        Pointer other = new Pointer(this.pointer);
        for (int i = 0; i < other.pointer.size(); ++i) {
            Elem e = other.pointer.get(i);
            if (!(e instanceof Span) || !e.contains(num)) continue;
            other.pointer.remove(i);
            Span s = (Span)e;
            if (s.start() < num) {
                other.pointer.add(i, new Span(s.start(), num - 1));
            }
            if (s.end() <= num) break;
            other.pointer.add(i, new Span(num + 1, s.end()));
            break;
        }
        return other;
    }

    public String toString() {
        return this.toPattern();
    }

    public int hashCode() {
        return ((Object)this.pointer).hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof Pointer) {
            return ((Object)this.pointer).equals(((Pointer)o).pointer);
        }
        return false;
    }

    public static Pointer compile(String pointer) {
        ArrayList<Elem> elem = new ArrayList<Elem>();
        try {
            String[] split = pointer.split(",");
            for (int i = 0; i < split.length; ++i) {
                if (split[i].length() == 0) continue;
                int sep = split[i].indexOf(45);
                if (sep >= 0) {
                    String left = split[i].substring(0, sep);
                    String right = split[i].substring(sep + 1);
                    int start = Integer.parseInt(left);
                    int end = right.length() == 0 ? Integer.MAX_VALUE : Integer.parseInt(right);
                    elem.add(new Span(start, end));
                    continue;
                }
                int len = split[i].length();
                if (i + 1 == split.length && Character.toUpperCase(split[i].charAt(len - 1)) == 'L') {
                    int num = Integer.parseInt(split[i].substring(0, len - 1));
                    elem.add(new Last(num));
                    continue;
                }
                int num = Integer.parseInt(split[i]);
                elem.add(new Span(num));
            }
        }
        catch (NumberFormatException ex) {
            logger.fine("\u30dd\u30a4\u30f3\u30bf\u30fc\u8868\u73fe\u4e2d\u306b\u4e0d\u6b63\u306a\u6570\u5024\u304c\u542b\u307e\u308c\u3066\u3044\u307e\u3059: " + ex);
        }
        Pointer.marge(elem);
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("\u30dd\u30a4\u30f3\u30bf\u30fc\u89e3\u6790\u7d50\u679c[" + pointer + "] " + elem);
        }
        return new Pointer(elem);
    }

    private static void marge(List<Elem> elem) {
        int i;
        for (i = 0; i < elem.size(); ++i) {
            Elem e = elem.get(i);
            if (!(e instanceof Span)) continue;
            Span s = (Span)e;
            if (s.start == s.end) {
                elem.set(i, new Span(((Span)e).start));
                continue;
            }
            if (s.start <= s.end) continue;
            elem.set(i, new Span(s.end, s.start));
        }
        Collections.sort(elem, new Comparator<Elem>(){

            @Override
            public int compare(Elem o1, Elem o2) {
                if (o1.start() > o2.start()) {
                    return 1;
                }
                if (o1.start() < o2.start()) {
                    return -1;
                }
                return 0;
            }
        });
        i = 0;
        while (i + 1 < elem.size()) {
            Elem e1;
            Elem e0 = elem.get(i);
            Elem e = Pointer.marge(e0, e1 = elem.get(i + 1));
            if (e != null) {
                elem.remove(i + 1);
                elem.set(i, e);
                --i;
            }
            ++i;
        }
    }

    private static Elem marge(Elem e0, Elem e1) {
        if (e0 instanceof Span && e1 instanceof Span) {
            Span s0 = (Span)e0;
            Span s1 = (Span)e1;
            if (s0.end >= s1.start || s0.start >= s1.end || s0.end + 1 == s1.start || s1.end + 1 == s0.start) {
                return new Span(Math.min(s0.start, s1.start), Math.max(s0.end, s1.end));
            }
        }
        return null;
    }

    private static final class Last
    implements Elem {
        private final int num;

        public Last(int num) {
            this.num = num;
        }

        @Override
        public <T> void pickup(List<? extends T> list, Collection<T> out) {
            throw new IllegalStateException();
        }

        @Override
        public int start() {
            return this.num;
        }

        @Override
        public int end() {
            return this.num;
        }

        @Override
        public int count(int total) {
            throw new IllegalStateException();
        }

        @Override
        public boolean contains(int num) {
            throw new IllegalStateException();
        }

        public int hashCode() {
            return this.num;
        }

        public String toString() {
            return Integer.toString(this.num) + 'L';
        }

        public boolean equals(Object o) {
            return o instanceof Last && ((Last)o).num == this.num;
        }
    }

    private static final class Span
    implements Elem {
        private final int start;
        private final int end;

        public Span(int num) {
            this.start = this.end = num;
        }

        public Span(int start, int end) {
            assert (start > 0 && end > 0) : start + "/" + end;
            this.start = start;
            this.end = end;
        }

        @Override
        public <T> void pickup(List<? extends T> list, Collection<T> out) {
            for (int i = this.start; i <= Math.min(this.end, list.size()); ++i) {
                out.add(list.get(i - 1));
            }
            logger.finest("pickup(): " + this);
        }

        @Override
        public int start() {
            return this.start;
        }

        @Override
        public int end() {
            return this.end;
        }

        @Override
        public int count(int total) {
            return Math.max(0, Math.min(total - 1, this.end) - this.start + 1);
        }

        @Override
        public boolean contains(int num) {
            return num >= this.start && num <= this.end;
        }

        public int hashCode() {
            return this.start + this.end;
        }

        public String toString() {
            if (this.start == this.end) {
                return String.valueOf(this.start);
            }
            if (this.end == Integer.MAX_VALUE) {
                return this.start + "-";
            }
            return this.start + "-" + this.end;
        }

        public boolean equals(Object o) {
            return o instanceof Span && ((Span)o).start == this.start && ((Span)o).end == this.end;
        }
    }

    private static interface Elem {
        public <T> void pickup(List<? extends T> var1, Collection<T> var2);

        public int start();

        public int end();

        public int count(int var1);

        public boolean contains(int var1);
    }
}

