/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch.util;

import java.text.NumberFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Performance {
    private static final Logger logger = Logger.getLogger(Performance.class.getName());
    private static final Performance DUMMY = new Performance(){

        @Override
        public void mark(String msg) {
        }

        @Override
        public void reset() {
        }
    };
    private long start = System.currentTimeMillis();

    private Performance() {
    }

    public static Performance start() {
        if (logger.isLoggable(Level.FINER)) {
            return new Performance();
        }
        return DUMMY;
    }

    public void mark(String msg) {
        NumberFormat nf = NumberFormat.getNumberInstance();
        long cur = System.currentTimeMillis();
        logger.finer("*** " + msg + ": " + nf.format(cur - this.start) + "[ms]");
        this.start = cur;
    }

    public void reset() {
        this.start = System.currentTimeMillis();
    }
}

