/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.koiroha.jive2ch.Response;
import org.koiroha.jive2ch.util.IO;
import org.koiroha.jive2ch.util.RollbackOutputStream;
import org.koiroha.jive2ch.util.XML;
import org.koiroha.xml.Xml;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class NGWord
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(NGWord.class.getName());
    public static final int NAME = 1;
    public static final int MAIL = 2;
    public static final int ID = 4;
    public static final int BE = 8;
    public static final int CONTENT = 16;
    public static final int ALL = 31;
    private boolean enabled = true;
    private String ngword = "";
    private Pattern pattern = null;
    private int field = 31;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enable) {
        this.enabled = enable;
    }

    public void setNGWord(String ngword) {
        this.ngword = ngword;
        this.pattern = null;
    }

    public String getNGWord() {
        return this.ngword;
    }

    public void setRegex(boolean regex) {
        if (regex) {
            try {
                this.pattern = Pattern.compile(this.ngword);
            }
            catch (PatternSyntaxException ex) {
                logger.log(Level.WARNING, "NG\u30ef\u30fc\u30c9\u306f\u6b63\u898f\u8868\u73fe\u3067\u306f\u3042\u308a\u307e\u305b\u3093: " + this.ngword, ex);
                this.pattern = null;
            }
        } else {
            this.pattern = null;
        }
    }

    public boolean isRegex() {
        return this.pattern != null;
    }

    public void setField(int field) {
        this.field = field;
    }

    public int getField() {
        return this.field;
    }

    public boolean isNG(Response res) {
        if (!this.enabled) {
            return false;
        }
        if ((this.field & 1) != 0 && this.isNG(res.getAuthor())) {
            return true;
        }
        if ((this.field & 4) != 0 && this.isNG(res.getId())) {
            return true;
        }
        if ((this.field & 0x10) != 0 && this.isNG(res.getPlainText())) {
            return true;
        }
        if ((this.field & 8) != 0 && this.isNG(res.getBe())) {
            return true;
        }
        return (this.field & 8) != 0 && this.isNG(res.getId());
    }

    public String toString() {
        return this.getNGWord();
    }

    private boolean isNG(String text) {
        if (text == null) {
            return false;
        }
        if (this.pattern != null) {
            return this.pattern.matcher(text).find();
        }
        return this.ngword.length() != 0 && text.indexOf(this.ngword) >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static ArrayList<NGWord> load(File file) throws IOException {
        ArrayList<NGWord> list = new ArrayList<NGWord>();
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(file));
            Document doc = XML.read(in);
            for (Node node : XML.evalList("ngword", doc.getDocumentElement())) {
                Element elem = (Element)node;
                NGWord w = new NGWord();
                w.setEnabled(Boolean.parseBoolean(elem.getAttribute("enabled")));
                w.setNGWord(elem.getTextContent());
                w.setRegex(Boolean.parseBoolean(elem.getAttribute("regex")));
                try {
                    w.setField(Integer.decode(elem.getAttribute("field")));
                }
                catch (NumberFormatException ex) {
                    logger.log(Level.WARNING, "NG\u30ef\u30fc\u30c9\u306e\u30d5\u30a3\u30fc\u30eb\u30c9\u5024\u304c\u4e0d\u6b63\u3067\u3059: " + elem.getAttribute("field"), ex);
                }
                list.add(w);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            IO.close(in);
            catch (Throwable throwable) {
                IO.close(in);
                throw throwable;
            }
        }
        IO.close(in);
        logger.finer("NG\u30ef\u30fc\u30c9\u3092\u5fa9\u5143\u3057\u307e\u3057\u305f: " + file);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void store(File file, List<NGWord> list) throws IOException {
        PrintWriter out = null;
        try {
            BufferedOutputStream os = new BufferedOutputStream(new RollbackOutputStream(file));
            out = new PrintWriter(new OutputStreamWriter((OutputStream)os, IO.UTF8));
            out.println("<?xml version=\"1.0\"?>");
            out.println("<ngwords>");
            for (NGWord w : list) {
                out.print("\t<ngword");
                out.print(" enabled=\"" + w.isEnabled() + "\"");
                out.print(" regex=\"" + w.isRegex() + "\"");
                out.print(" field=\"0x" + Integer.toHexString(w.getField()) + "\"");
                out.print(">");
                out.print(Xml.escape(w.getNGWord()));
                out.println("</ngword>");
            }
            out.println("</ngwords>");
            out.flush();
        }
        catch (Throwable throwable) {
            IO.close(out);
            throw throwable;
        }
        IO.close(out);
        logger.finer("NG\u30ef\u30fc\u30c9\u3092\u4fdd\u5b58\u3057\u307e\u3057\u305f: " + file);
    }
}

