/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class J2Formatter
extends Formatter {
    @Override
    public String format(LogRecord r) {
        int len = 20;
        String className = r.getSourceClassName();
        int sep = className.lastIndexOf(46);
        if (sep >= 0) {
            className = className.substring(sep + 1);
        }
        if (className.length() > len) {
            className = className.substring(className.length() - len);
        }
        String l = "?";
        if (r.getLevel().equals(Level.SEVERE)) {
            l = "E";
        } else if (r.getLevel().equals(Level.WARNING)) {
            l = "W";
        } else if (r.getLevel().equals(Level.INFO)) {
            l = "I";
        } else if (r.getLevel().equals(Level.FINE)) {
            l = "D";
        } else if (r.getLevel().equals(Level.FINER)) {
            l = "d";
        } else if (r.getLevel().equals(Level.FINEST)) {
            l = "-";
        }
        String log = String.format("[%1$tF %1$tT.%1$tL] %3$s: %4$-20s: %5$s: %6$s%n", new Date(r.getMillis()), r.getLevel().getName(), Thread.currentThread().getName(), className, l, r.getMessage());
        if (r.getThrown() != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            r.getThrown().printStackTrace(pw);
            log = log + sw;
        }
        return log;
    }
}

